/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.internal.AbstractCredentialDialog;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.PasswordComposite;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CredentialsDialog
extends AbstractCredentialDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String initialCredentialsNameForCreate;
    private String initialUserNameForCreate;
    private static final String THEME_ID = "themeid";
    private static final String DEFAULT_THEME_ID = "DEFAULT";
    private static final String ECLIPSE_THEME_PLUGIN_ID = "org.eclipse.e4.ui.css.swt.theme";
    private static Color bgColor = null;
    private static Color bgColorDark = null;
    private static final RGB bgColorRGB = new RGB(240, 240, 240);
    private static final RGB bgColorDarkRGB = new RGB(81, 88, 86);

    public CredentialsDialog(Shell parentShell, CredentialsMode credentialsMode) {
        super(parentShell);
        this.credentialsMode = credentialsMode;
        this.credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
    }

    public CredentialsDialog(Shell parentShell, CredentialsConfiguration credentialsConfiguration) {
        this(parentShell, CredentialsMode.EDIT_CREDENTIAL);
        this.credentialsConfiguration = credentialsConfiguration;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        childArea.setLayoutData((Object)new GridData(1808));
        childArea.setBackgroundMode(2);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginRight = 20;
        gridLayout.marginLeft = 20;
        childArea.setLayout((Layout)gridLayout);
        this.passwordComposite = new PasswordComposite(childArea, true, this.credentialsManager.isPasswordSaveable(), this.credentialsMode, this.credentialsManager.getAllCredentials(), true, true, this.credentialsConfiguration, this.errorStateManager);
        this.usernameAndPasswordComposite = this.passwordComposite.getUsernameAndPasswordComposite();
        this.updateBackgroundColor(this.usernameAndPasswordComposite);
        this.oneTimePasswordComposite = this.passwordComposite.getOneTimePasswordComposite();
        this.updateBackgroundColor(this.oneTimePasswordComposite);
        this.keystoreComposite = this.passwordComposite.getKeystoreComposite();
        this.updateBackgroundColor(this.keystoreComposite);
        this.smartcardComposite = this.passwordComposite.getSmartcardComposite();
        this.updateBackgroundColor(this.smartcardComposite);
        if (this.credentialsMode == CredentialsMode.EDIT_CREDENTIAL) {
            PasswordComposite.CredentialType initialCredentialType = this.passwordComposite.getCredentialType();
            this.passwordComposite.getCurrentCredentialsComposite().setCredentialsName(this.credentialsConfiguration.getName());
            this.passwordComposite.getCurrentCredentialsComposite().setUserID(this.credentialsConfiguration.getUserID());
            if (initialCredentialType.equals((Object)PasswordComposite.CredentialType.PASSWORD)) {
                if (StringUtil.hasContent((String)this.credentialsConfiguration.getPassword())) {
                    this.usernameAndPasswordComposite.setPassword(this.credentialsConfiguration.getPassword());
                }
                this.usernameAndPasswordComposite.setSavePassword(this.credentialsConfiguration.isSavePassword());
            } else {
                initialCredentialType.equals((Object)PasswordComposite.CredentialType.ONETIMEPASSWORD);
            }
        } else {
            if (StringUtil.hasContent((String)this.initialCredentialsNameForCreate)) {
                this.usernameAndPasswordComposite.setUserID(this.initialUserNameForCreate);
                this.oneTimePasswordComposite.setUserID(this.initialUserNameForCreate);
                this.keystoreComposite.setUserID(this.initialUserNameForCreate);
                this.smartcardComposite.setUserID(this.initialUserNameForCreate);
            }
            if (StringUtil.hasContent((String)this.initialUserNameForCreate)) {
                this.usernameAndPasswordComposite.setCredentialsName(this.initialUserNameForCreate);
                this.oneTimePasswordComposite.setCredentialsName(this.initialUserNameForCreate);
                this.keystoreComposite.setCredentialsName(this.initialUserNameForCreate);
                this.smartcardComposite.setCredentialsName(this.initialUserNameForCreate);
            }
        }
        GridData data = new GridData(4, 4, true, true);
        this.passwordComposite.setLayoutData(data);
        this.passwordComposite.setInitialFocus();
        this.passwordComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CredentialsDialog.this.validate(e == null ? null : e.widget);
            }
        });
        this.addSelectionListener();
        return c;
    }

    protected void okPressed() {
        if (this.credentialsMode == CredentialsMode.EDIT_CREDENTIAL) {
            this.credentialsConfiguration.setUserID(this.passwordComposite.getCurrentCredentialsComposite().getUserID());
            this.credentialsConfiguration.setName(this.passwordComposite.getCurrentCredentialsComposite().getCredentialsName());
            if (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.PASSWORD) {
                this.credentialsConfiguration.setPassword(this.usernameAndPasswordComposite.getPassword());
                this.credentialsConfiguration.setSavePassword(this.usernameAndPasswordComposite.isSavePassword());
            } else {
                this.passwordComposite.getCredentialType();
            }
            this.credentialsManager.update(this.credentialsConfiguration);
        } else {
            CredentialsConfiguration newCredentialsConfiguration = this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.PASSWORD ? CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.usernameAndPasswordComposite.getCredentialsName(), (String)this.usernameAndPasswordComposite.getUserID(), (String)this.usernameAndPasswordComposite.getPassword(), (boolean)this.usernameAndPasswordComposite.isSavePassword()) : (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.ONETIMEPASSWORD ? CredentialsConfiguration.createOneTimePasswordCredential((String)this.oneTimePasswordComposite.getCredentialsName(), (String)this.oneTimePasswordComposite.getUserID()) : (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.KEYSTORE ? CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.keystoreComposite.getCredentialsName(), (String)this.keystoreComposite.getUserID(), (CertificateDetails)this.keystoreComposite.getCertificate()) : CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.smartcardComposite.getCredentialsName(), (String)this.smartcardComposite.getUserID(), (CertificateDetails)this.smartcardComposite.getCertificate())));
            this.credentialsManager.update(newCredentialsConfiguration);
        }
        super.okPressed();
    }

    public void setInitialCreateDetails(String userName, String newCredentialsName) {
        this.initialUserNameForCreate = userName;
        this.initialCredentialsNameForCreate = newCredentialsName;
    }

    @Override
    String getHelpContextId() {
        return "com.ibm.cics.explorer.logindetails_dialog";
    }

    @Override
    String getShellText() {
        if (this.credentialsMode == CredentialsMode.EDIT_CREDENTIAL) {
            return Messages.ConnectionDialog_Edit_Credential;
        }
        return Messages.CredentialsManager_newCredentials;
    }

    @Override
    String getTitle() {
        if (this.credentialsMode == CredentialsMode.EDIT_CREDENTIAL) {
            return Messages.ConnectionDialog_Edit_Credential;
        }
        return Messages.CredentialsManager_newCredentials;
    }

    @Override
    String getTitleMessage() {
        return this.passwordComposite != null ? this.passwordComposite.getTitleMessage() : "";
    }

    public String getCurrentThemeID() {
        IEclipsePreferences theme_prefs = InstanceScope.INSTANCE.getNode(ECLIPSE_THEME_PLUGIN_ID);
        return theme_prefs.get(THEME_ID, DEFAULT_THEME_ID);
    }

    public boolean isCurrentlyDarkTheme(String curThemeID) {
        return curThemeID.toLowerCase().indexOf("dark") != -1;
    }

    private void updateBackgroundColor(Composite pageComposite) {
        if (this.isCurrentlyDarkTheme(this.getCurrentThemeID()) && pageComposite.getShell() != null && pageComposite.getDisplay() != null) {
            if (bgColorDark == null) {
                bgColorDark = new Color((Device)pageComposite.getShell().getDisplay(), bgColorDarkRGB);
            }
            pageComposite.setBackground(bgColorDark);
        } else {
            if (bgColor == null) {
                bgColor = new Color((Device)pageComposite.getShell().getDisplay(), bgColorRGB);
            }
            pageComposite.setBackground(bgColor);
        }
    }
}

