/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.IConnectionsInfoProvider;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.AbstractConfigurationOperation;
import com.ibm.cics.core.connections.internal.AddConfigurationOperation;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionCustomizerRegistry;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.DebugOptions;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.IConnectionCustomizerDescriptor;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.UpdateConfigurationCommand;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.editor.TitleAreaDialogErrorStateManager;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditConnectionDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(EditConnectionDialog.class);
    private static int SAVE_AND_CONNECT = 909;
    private ConnectionParameters existingConnectionConfiguration;
    private ConnectionCustomizerRegistry customizerRegistry = new ConnectionCustomizerRegistry();
    IConnectionCustomizer connectionCustomizer;
    private Group serverGroup;
    private Text hostText;
    private Text portText;
    private Button sslFlag;
    private IConnectionManager connectionManager;
    Composite customizerGroup;
    private final IConnectionDescriptor connectionDescriptor;
    private Composite nameGroup;
    private Text nameText;
    private final Mode mode;
    private boolean nameIsDefault;
    private IConnectionCustomizerListener connectionCustomizerListener;
    private TitleAreaDialogErrorStateManager errorStateManager;
    private boolean isPopulatingData;
    private IConnectionProvider connectionProvider;
    private IConnectionService connectionService;
    private final boolean connected;
    private ConnectionConfiguration customizerConfiguration;
    private List<String> existingNames;

    private EditConnectionDialog(Shell shell, IConnectionDescriptor descriptor, ConnectionParameters config, Mode mode, IConnectionProvider provider, boolean connected) {
        super(shell);
        this.connectionProvider = provider;
        this.connected = connected;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        debug.event("ConnectionDialog", new Object[]{mode, descriptor.getId()});
        if (this.connectionProvider != null && !(this.connectionProvider instanceof IWritableConnectionProvider)) {
            this.mode = Mode.Browse;
            debug.event("ConnectionDialog mode overridden", new Object[]{mode, this.mode, this.connectionProvider});
        } else {
            this.mode = mode;
        }
        this.existingConnectionConfiguration = config;
        this.connectionDescriptor = descriptor;
        this.connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        this.connectionManager = this.connectionService.getConnectionManager();
        this.errorStateManager = new TitleAreaDialogErrorStateManager((TitleAreaDialog)this);
        this.customizerConfiguration = this.createCustomizerConfiguration();
        this.existingNames = this.getExistingConnectionNames();
        if (config != null) {
            this.existingNames.remove(config.getName());
        }
    }

    private List<String> getExistingConnectionNames() {
        ArrayList<String> names = new ArrayList<String>();
        List<ConnectionProfile> existingConnections = this.connectionManager.getConnectionProfiles();
        for (ConnectionProfile profile : existingConnections) {
            names.add(profile.getName());
        }
        return names;
    }

    private ConnectionConfiguration createCustomizerConfiguration() {
        ConnectionConfiguration config;
        if (this.existingConnectionConfiguration != null) {
            config = new ConnectionConfiguration(this.existingConnectionConfiguration.getId(), this.existingConnectionConfiguration.getName(), ConfigurationUtils.getHost(this.existingConnectionConfiguration), ConfigurationUtils.getPort(this.existingConnectionConfiguration), "");
            for (IConnectionDescriptor.ExtendedAttribute attribute : this.connectionDescriptor.getExtendedAttributes()) {
                config.setExtendedAttribute(attribute.getKey(), this.existingConnectionConfiguration.getAttribute(attribute.getKey()));
            }
        } else {
            config = new ConnectionConfiguration("DUMMY-ID", "", "", 0, "");
        }
        return config;
    }

    public static EditConnectionDialog editExisting(Shell shell, ConnectionProfile config, boolean connected) {
        return new EditConnectionDialog(shell, config.getConnectionDescriptor(), config.getConnectionParameters(), Mode.Edit, config.getConnectionProvider(), connected);
    }

    public static EditConnectionDialog createNew(Shell shell, IConnectionDescriptor descriptor) {
        return new EditConnectionDialog(shell, descriptor, null, Mode.Create_With_Descriptor, ConnectionProviderRegistry.getDefault().getConnectionProvider(descriptor), false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.setTitleImage(ConnectionsImages.getImage("CONNECTION_WIZ_BAN"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        childArea.setLayout((Layout)gridLayout);
        this.createName(childArea);
        this.createHostAndPort(childArea);
        this.createCustomizerArea(childArea);
        this.populateData();
        if (this.hostText.isEnabled()) {
            this.hostText.setFocus();
        }
        this.createHostAndPortToNameListeners();
        this.nameIsDefault = this.nameText.getText().equals(this.getDefaultName());
        this.createTitle();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connection_dialog");
        return c;
    }

    public ConnectionParameters getConnectionConfiguration() {
        return this.existingConnectionConfiguration;
    }

    private void createTitle() {
        switch (this.mode) {
            case Create_With_Descriptor: {
                this.setTitle(MessageFormat.format(Messages.ConnectionDialog_Add_Connection, this.connectionDescriptor.getName()));
                this.getShell().setText(MessageFormat.format(Messages.ConnectionDialog_Add_Connection, this.connectionDescriptor.getName()));
                break;
            }
            case Edit: {
                this.setTitle(MessageFormat.format(Messages.ConnectionDialog_Edit_Connection, this.connectionDescriptor.getName()));
                this.getShell().setText(MessageFormat.format(Messages.ConnectionDialog_Edit_Connection, this.connectionDescriptor.getName()));
                break;
            }
            case Browse: {
                this.setTitle(MessageFormat.format(Messages.ConnectionDialog_Display_Connection, this.connectionDescriptor.getName()));
                this.getShell().setText(MessageFormat.format(Messages.ConnectionDialog_Display_Connection, this.connectionDescriptor.getName()));
            }
        }
    }

    private void createHostAndPortToNameListeners() {
        ModifyListener hostAndPortModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditConnectionDialog.this.validate();
                if (EditConnectionDialog.this.nameIsDefault) {
                    EditConnectionDialog.this.setNameToDefault();
                }
            }
        };
        this.hostText.addModifyListener(hostAndPortModifyListener);
        this.portText.addModifyListener(hostAndPortModifyListener);
        ModifyListener nameModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String currentName = EditConnectionDialog.this.nameText.getText();
                String defaultName = EditConnectionDialog.this.getDefaultName();
                if (!defaultName.equals(currentName)) {
                    EditConnectionDialog.this.nameIsDefault = false;
                }
                EditConnectionDialog.this.validate();
            }
        };
        this.nameText.addModifyListener(nameModifyListener);
    }

    private String getDefaultName() {
        StringBuffer buffer = new StringBuffer();
        if (StringUtil.hasContent((String)this.hostText.getText())) {
            String hostName = this.hostText.getText();
            if (hostName.indexOf(".") != -1) {
                hostName = hostName.substring(0, hostName.indexOf("."));
            }
            buffer.append(hostName);
        }
        if (StringUtil.hasContent((String)this.portText.getText())) {
            buffer.append(":");
            buffer.append(this.portText.getText());
        }
        return buffer.toString();
    }

    private void validate() {
        if (this.isPopulatingData) {
            return;
        }
        this.validateData();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(StringUtil.isEmpty((String)this.getErrorMessage()));
            this.getButton(SAVE_AND_CONNECT).setEnabled(StringUtil.isEmpty((String)this.getErrorMessage()));
        }
    }

    private void recordSevereError(String errorMessage, Control aControl) {
        this.errorStateManager.recordSevereError(errorMessage, aControl);
    }

    private void validateData() {
        String customizerErroMessage;
        int nameLength;
        String name;
        block10: {
            if (DebugOptions.DEBUG_CONNECTION) {
                debug.event("validateData", (Object)this.existingConnectionConfiguration);
            }
            name = this.nameText.getText();
            nameLength = name.length();
            String host = this.hostText.getText().trim();
            int hostLength = host.length();
            int portLength = this.portText.getText().trim().length();
            if (hostLength == 0) {
                this.recordSevereError(Messages.ConnectionPreferencePage_IZE0406E_mandatoryHost, (Control)this.hostText);
                return;
            }
            if (host.indexOf("/") != -1) {
                this.recordSevereError(Messages.ConnectionPreferencePage_IZE0402E_invalidHost, (Control)this.hostText);
                return;
            }
            if (portLength > 0) {
                try {
                    int port = Integer.parseInt(this.portText.getText().trim());
                    if (port < 1 || port > 65535) {
                        this.recordSevereError(Messages.ConnectionPreferencePage_IZE0401E_invalidPort, (Control)this.portText);
                        return;
                    }
                    break block10;
                }
                catch (NumberFormatException numberFormatException) {
                    this.recordSevereError(Messages.ConnectionPreferencePage_IZE0401E_invalidPort, (Control)this.portText);
                    return;
                }
            }
            this.recordSevereError(Messages.ConnectionPreferencePage_IZE0405E_mandatoryPort, (Control)this.portText);
            return;
        }
        if (this.connectionCustomizer != null && (customizerErroMessage = this.connectionCustomizer.validateEnteredData()) != null) {
            this.recordSevereError(customizerErroMessage, (Control)this.customizerGroup);
            return;
        }
        if (name.indexOf("/") != -1 || nameLength == 0) {
            this.recordSevereError(Messages.ConnectionPreferencePage_IZE0404E_invalidConnectionName, (Control)this.nameText);
            return;
        }
        if (this.existingNames.contains(name)) {
            this.recordSevereError(Messages.ConnectionPreferencePage_IZE0403E_duplicateName, (Control)this.nameText);
            return;
        }
        this.errorStateManager.clearErrors();
    }

    private void setNameToDefault() {
        this.nameText.setText(this.getDefaultName());
    }

    private void createName(Composite c) {
        this.nameGroup = new Composite(c, 0);
        GridData data = new GridData(4, 0, true, false);
        this.nameGroup.setLayoutData((Object)data);
        this.nameGroup.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(this.nameGroup, 0);
        l.setText(Messages.ConnectionPreferencePage_name);
        this.nameText = new Text(this.nameGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.nameText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        this.nameText.setLayoutData((Object)data);
    }

    private void createHostAndPort(Composite c) {
        this.serverGroup = new Group(c, 0);
        this.serverGroup.setText(Messages.ConnectionPreferencePage_location);
        GridData data = new GridData(4, 0, true, false);
        this.serverGroup.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 10;
        this.serverGroup.setLayout((Layout)gridLayout);
        Label l = new Label((Composite)this.serverGroup, 0);
        l.setText(Messages.ConnectionPreferencePage_host);
        this.hostText = new Text((Composite)this.serverGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.hostText, (Label)l);
        this.hostText.forceFocus();
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.hostText.setLayoutData((Object)data);
        this.hostText.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                EditConnectionDialog.this.nameText.setLocation(((EditConnectionDialog)EditConnectionDialog.this).hostText.getLocation().x, ((EditConnectionDialog)EditConnectionDialog.this).nameText.getLocation().y);
                EditConnectionDialog.this.nameText.setSize(EditConnectionDialog.this.hostText.getSize());
            }

            public void controlResized(ControlEvent e) {
                EditConnectionDialog.this.nameText.setLocation(((EditConnectionDialog)EditConnectionDialog.this).hostText.getLocation().x, ((EditConnectionDialog)EditConnectionDialog.this).nameText.getLocation().y);
                EditConnectionDialog.this.nameText.setSize(EditConnectionDialog.this.hostText.getSize());
            }
        });
        l = new Label((Composite)this.serverGroup, 0);
        l.setText(Messages.ConnectionPreferencePage_port);
        this.portText = new Text((Composite)this.serverGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.portText, (Label)l);
        data = new GridData();
        data.widthHint = 90;
        this.portText.setLayoutData((Object)data);
        if (this.connectionDescriptor.isSSLEnabled()) {
            this.sslFlag = new Button((Composite)this.serverGroup, 32);
            this.sslFlag.setText(Messages.SSL_flag);
            data = new GridData();
            this.sslFlag.setLayoutData((Object)data);
        }
    }

    protected void buttonPressed(int buttonId) {
        if ((buttonId == 0 || buttonId == SAVE_AND_CONNECT) && this.mode != Mode.Browse) {
            if (this.connectionCustomizer != null) {
                this.connectionCustomizer.updateCurrentConfiguration();
            }
            AbstractConfigurationOperation updateConfigurationCommand = null;
            switch (this.mode) {
                case Create_With_Descriptor: {
                    ConnectionParameters.AttributeValue[] attributes = this.getAttributes();
                    updateConfigurationCommand = new AddConfigurationOperation(this.nameText.getText().trim(), this.connectionDescriptor.getId(), attributes, (IWritableConnectionProvider)this.connectionProvider);
                    break;
                }
                case Edit: {
                    ConnectionParameters newConfiguration = this.existingConnectionConfiguration.setAttributes(this.getAttributes());
                    newConfiguration = newConfiguration.setName(this.nameText.getText().trim());
                    updateConfigurationCommand = new UpdateConfigurationCommand(this.existingConnectionConfiguration, newConfiguration, (IWritableConnectionProvider)this.connectionProvider);
                }
            }
            try {
                OperationHistoryFactory.getOperationHistory().execute(updateConfigurationCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                if (buttonId == SAVE_AND_CONNECT) {
                    super.buttonPressed(0);
                    this.connectionService.connectAsync(((AbstractConfigurationOperation)updateConfigurationCommand).getConfigurationId());
                }
            }
            catch (ExecutionException e) {
                this.setErrorMessage(e.getLocalizedMessage());
                return;
            }
        }
        if (this.mode == Mode.Browse && buttonId == SAVE_AND_CONNECT) {
            super.buttonPressed(0);
            this.connectionService.connectAsync(this.existingConnectionConfiguration.getId());
            return;
        }
        super.buttonPressed(buttonId);
    }

    private ConnectionParameters.AttributeValue[] getAttributes() {
        ArrayList<ConnectionParameters.AttributeValue> attributes = new ArrayList<ConnectionParameters.AttributeValue>();
        attributes.add(ConnectionParameters.av("host", this.hostText.getText().trim()));
        attributes.add(ConnectionParameters.av("port", this.portText.getText().trim()));
        if (this.connectionDescriptor.isSSLEnabled()) {
            attributes.add(ConnectionParameters.av("ATTEMPT_SECURE", String.valueOf(this.sslFlag.getSelection())));
            attributes.add(ConnectionParameters.av("ssl_confirmed", "true"));
        }
        for (IConnectionDescriptor.ExtendedAttribute attribute : this.connectionDescriptor.getExtendedAttributes()) {
            String key = attribute.getKey();
            String value = this.customizerConfiguration.getExtendedAttribute(key);
            attributes.add(ConnectionParameters.av(key, value));
        }
        return attributes.toArray(new ConnectionParameters.AttributeValue[attributes.size()]);
    }

    private void createCustomizerArea(Composite aComposite) {
        if (this.connectionDescriptor != null) {
            IConnectionCustomizerDescriptor connectionCustomizerDescriptor = this.customizerRegistry.find(this.connectionDescriptor.getId());
            try {
                if (this.customizerGroup != null && !this.customizerGroup.isDisposed()) {
                    this.customizerGroup.dispose();
                }
                if (connectionCustomizerDescriptor == null) {
                    this.customizerGroup = new Composite(aComposite, 0);
                    GridData data = new GridData(4, 4, false, true);
                    data.minimumHeight = 125;
                    data.widthHint = 150;
                    this.customizerGroup.setLayoutData((Object)data);
                    return;
                }
                if (Utilities.hasContent((String)connectionCustomizerDescriptor.getName())) {
                    this.customizerGroup = new Group(aComposite, 0);
                    ((Group)this.customizerGroup).setText(StringUtil.toDisplayString((String)connectionCustomizerDescriptor.getName()));
                } else {
                    this.customizerGroup = new Composite(aComposite, 0);
                }
                GridData data = new GridData(4, 4, false, true);
                data.minimumHeight = 125;
                data.widthHint = 150;
                this.customizerGroup.setLayoutData((Object)data);
                this.customizerGroup.setLayout((Layout)new GridLayout(2, false));
                this.connectionCustomizer = connectionCustomizerDescriptor.createConnectionCustomizer();
                this.connectionCustomizer.setConnectionsInfoProvider(this.getConnectionsInfoProvider());
                this.connectionCustomizer.createControl(this.customizerGroup);
                this.connectionCustomizer.addListener(this.getConnectionCustomizerListener());
            }
            catch (CoreException e) {
                debug.error("createCustomizerArea", (Throwable)e);
            }
        }
    }

    private IConnectionCustomizerListener getConnectionCustomizerListener() {
        if (this.connectionCustomizerListener == null) {
            this.connectionCustomizerListener = new IConnectionCustomizerListener(){

                @Override
                public void propertyChanged(String propertyName, Object propertyValue) {
                    EditConnectionDialog.this.validate();
                }
            };
        }
        return this.connectionCustomizerListener;
    }

    private IConnectionsInfoProvider getConnectionsInfoProvider() {
        return new IConnectionsInfoProvider(){
            private List<IConnectionDescriptor> descriptors;
            private Map<String, ConnectionConfiguration>[] configurationsMap;

            @Override
            public Collection<IConnectionDescriptor> getDescriptors() {
                if (this.descriptors == null) {
                    this.descriptors = Arrays.asList(new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry()).getConnections());
                }
                return this.descriptors;
            }

            @Override
            public IConnectionDescriptor getCurrentDescriptor() {
                return EditConnectionDialog.this.connectionDescriptor;
            }

            @Override
            public Map<String, ConnectionConfiguration>[] getConfigurationsMap() {
                if (this.configurationsMap == null) {
                    List<ConnectionProfile> configurations = EditConnectionDialog.this.connectionManager.getConnectionProfiles();
                    List<List<ConnectionProfile>> groupedByDescriptor = CollectionUtils.groupBy(configurations, new Function<ConnectionProfile, Object>(){

                        @Override
                        public Object evaluate(ConnectionProfile v) {
                            return v.getConnectionDescriptor();
                        }
                    });
                    Map<IConnectionDescriptor, List<ConnectionProfile>> mapByDescriptor = CollectionUtils.map(groupedByDescriptor, new Function<List<ConnectionProfile>, IConnectionDescriptor>(){

                        @Override
                        public IConnectionDescriptor evaluate(List<ConnectionProfile> v) {
                            return v.get(0).getConnectionDescriptor();
                        }
                    });
                    ArrayList<Map<String, ConnectionConfiguration>> listOfMaps = new ArrayList<Map<String, ConnectionConfiguration>>();
                    for (IConnectionDescriptor descriptor : this.getDescriptors()) {
                        List<ConnectionProfile> profiles = mapByDescriptor.get(descriptor);
                        if (profiles == null || profiles.isEmpty()) {
                            listOfMaps.add(Collections.EMPTY_MAP);
                            continue;
                        }
                        List<ConnectionConfiguration> configs = CollectionUtils.transform(profiles, new Function<ConnectionProfile, ConnectionConfiguration>(){

                            @Override
                            public ConnectionConfiguration evaluate(ConnectionProfile v) {
                                return v.getConnectionConfiguration();
                            }
                        });
                        Map<String, ConnectionConfiguration> configurationsById = CollectionUtils.map(configs, new Function<ConnectionConfiguration, String>(){

                            @Override
                            public String evaluate(ConnectionConfiguration v) {
                                return v.getID();
                            }
                        });
                        listOfMaps.add(configurationsById);
                    }
                    this.configurationsMap = listOfMaps.toArray(new Map[0]);
                }
                return this.configurationsMap;
            }
        };
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        if (this.mode == Mode.Create_With_Descriptor) {
            this.getButton(0).setEnabled(false);
            this.getButton(SAVE_AND_CONNECT).setEnabled(false);
        }
        return buttonBar;
    }

    private void populateData() {
        this.isPopulatingData = true;
        try {
            switch (this.mode) {
                case Create_With_Descriptor: {
                    IConnectionDescriptor.ExtendedAttribute defaultPortAttribute = this.connectionDescriptor.getExtendedAttribute("DEFAULT_PORT");
                    int defaultPort = 0;
                    if (defaultPortAttribute != null) {
                        String defaultPortStr = defaultPortAttribute.getDefault();
                        try {
                            defaultPort = Integer.parseInt(defaultPortStr);
                        }
                        catch (Exception exc) {
                            debug.error("Default port can't be set ", (Throwable)exc);
                        }
                    }
                    if (defaultPort > 0) {
                        this.portText.setText(String.valueOf(defaultPort));
                    }
                    this.nameText.setText(this.getDefaultName());
                    break;
                }
                case Edit: 
                case Browse: {
                    this.hostText.setText(this.existingConnectionConfiguration.getAttribute("host"));
                    this.portText.setText(this.existingConnectionConfiguration.getAttribute("port"));
                    this.nameText.setText(StringUtil.toDisplayString((String)this.existingConnectionConfiguration.getName()));
                    if (!this.connectionDescriptor.isSSLEnabled()) break;
                    this.sslFlag.setSelection(ConfigurationUtils.isSecureHint(this.existingConnectionConfiguration));
                }
            }
            if (this.mode == Mode.Browse) {
                this.hostText.setEnabled(false);
                this.portText.setEnabled(false);
                this.nameText.setEnabled(false);
                if (this.connectionDescriptor.isSSLEnabled()) {
                    this.sslFlag.setEnabled(false);
                }
                this.recursiveSetEditControlsEnabled(this.customizerGroup, false);
                this.setMessage(String.valueOf(Messages.ConnectionDialog_Connection_from_provider_msg) + System.getProperty("line.separator") + this.connectionProvider.getDescription());
            }
            if (this.connectionCustomizer != null) {
                if (this.mode == Mode.Create_With_Descriptor) {
                    this.connectionCustomizer.clear();
                }
                this.connectionCustomizer.setConfiguration(this.customizerConfiguration);
            }
            if (this.connectionProvider instanceof IWritableConnectionProvider) {
                this.setMessage(Messages.ConnectionDialog_Connection_Details_info);
            }
        }
        finally {
            this.isPopulatingData = false;
        }
    }

    void recursiveSetEditControlsEnabled(Composite aComposite, boolean enabled) {
        Control[] controlArray = aComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control aControl = controlArray[n2];
            if (aControl instanceof Composite) {
                this.recursiveSetEditControlsEnabled((Composite)aControl, enabled);
            }
            if (this.isUserInputControl(aControl)) {
                aControl.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private boolean isUserInputControl(Control aControl) {
        if (aControl instanceof Label) {
            return false;
        }
        if (aControl.getClass() == Composite.class) {
            return false;
        }
        if (aControl instanceof CTabFolder) {
            return false;
        }
        if (aControl instanceof TabFolder) {
            return false;
        }
        return aControl.getClass() != Group.class;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Point preferredSize = this.getShell().computeSize(-1, -1);
        Point actualSize = this.getShell().getSize();
        Point adjustedSize = new Point(Math.max(preferredSize.x, actualSize.x), Math.max(preferredSize.y, actualSize.y));
        this.getShell().setSize(adjustedSize);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mode == Mode.Browse) {
            if (!this.connected) {
                this.createButton(parent, SAVE_AND_CONNECT, Messages.ConnectionDialog_connect, false);
            }
        } else {
            this.createButton(parent, SAVE_AND_CONNECT, Messages.ConnectionDialog_save_and_connect, false);
        }
        this.createButton(parent, 0, this.mode == Mode.Browse ? Messages.ConnectionDialog_close : Messages.ConnectionDialog_save_and_close, true);
        if (this.mode != Mode.Browse) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    static enum Mode {
        Create_With_Descriptor,
        Edit,
        Browse;

    }
}

