/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.views.ConnectionsTreeAndButtonsComposite;
import com.ibm.cics.core.connections.internal.views.Messages;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConnectionRequiredDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CONTEXT_HELP_ID = "com.ibm.cics.zos.ui.ZOSConnectionRequiredDialog";
    private static final int CONNECT_ID = 1038;
    private Button connectButton;
    private Button okButton;
    private final FilteredConnectionRegistry filteredRegistry;
    private IObservableMap categoryActiveConnectionState = new WritableMap();
    private ConnectionService connectionService = InternalConnectionsPlugin.getDefault().getConnectionService();
    private ConnectionsTreeAndButtonsComposite connectionsTreeComposite;
    private TreeViewer treeViewer;
    private WritableValue selectedItem = new WritableValue();
    private String description;
    private IConnectionCategory category;
    private ConnectionServiceListener connectionServiceListener;

    public ConnectionRequiredDialog(Shell parentShell, String connectionCategoryID, String description) {
        super(parentShell);
        this.description = description;
        this.filteredRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry(), connectionCategoryID);
        this.category = this.filteredRegistry.findCategory(connectionCategoryID);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.setTitleImage(ConnectionsImages.getImage("CONNECTION_WIZ_BAN"));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(700, 450);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NLS.bind((String)Messages.ConnectionRequiredDialog_title, (Object)this.category.getName()));
        this.setTitle(NLS.bind((String)Messages.ConnectionRequiredDialog_title_area_message, (Object)this.category.getName()));
        this.setMessage(this.description);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite body = new Composite(area, 0);
        GridData gridData = new GridData(4, 4, false, true);
        body.setLayoutData((Object)gridData);
        body.setFont(parent.getFont());
        body.setLayout((Layout)new GridLayout());
        this.connectionsTreeComposite = new ConnectionsTreeAndButtonsComposite(body, this.categoryActiveConnectionState, this.connectionService, null, this.filteredRegistry);
        this.treeViewer = this.connectionsTreeComposite.getTreeViewer();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ConnectionRequiredDialog.this.selectedItem.setValue(selection.getFirstElement());
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.connectButton = this.createButton(parent, 1038, Messages.ConnectionsViewPart_Connect, false);
        this.connectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ConnectionProfile connectionProfile = (ConnectionProfile)ConnectionRequiredDialog.this.selectedItem.getValue();
                ConnectionRequiredDialog.this.connectionService.connectAsync(connectionProfile.getId());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.connectionServiceListener = new ConnectionServiceListener(){

            public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                ConnectionRequiredDialog.this.connectButton.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getConnectionCategoryId().equals(ConnectionRequiredDialog.this.category.getId())) {
                            if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                ConnectionRequiredDialog.this.okButton.setEnabled(true);
                            } else {
                                ConnectionRequiredDialog.this.okButton.setEnabled(false);
                            }
                        }
                    }
                });
            }
        };
        this.connectionService.addConnectionServiceListener(this.connectionServiceListener);
        this.connectButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ConnectionRequiredDialog.this.connectionServiceListener.makeStale();
            }
        });
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.connectButton), (IObservableValue)this.selectedItem, null, new UpdateValueStrategy().setConverter((IConverter)new Converter(Object.class, Boolean.TYPE){

            public Object convert(Object fromObject) {
                if (fromObject instanceof ConnectionProfile) {
                    return true;
                }
                return false;
            }
        }));
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(result, CONTEXT_HELP_ID);
        return result;
    }

    public boolean close() {
        this.connectionsTreeComposite.dispose();
        return super.close();
    }
}

