/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;

public class UTF8HexStringParser {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Charset charset;
    private static final CharsetDecoder decoder;
    private static final CharsetEncoder encoder;

    static {
        try {
            charset = Charset.forName("UTF-8");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            charset = null;
        }
        if (charset != null) {
            decoder = charset.newDecoder();
            encoder = charset.newEncoder();
        } else {
            decoder = null;
            encoder = null;
        }
    }

    public static String hexToString(String unicodeChars) {
        if (unicodeChars.length() % 2 == 0) {
            byte[] bytes = new byte[unicodeChars.length() / 2];
            int i = 0;
            while (i < unicodeChars.length() / 2) {
                try {
                    bytes[i] = (byte)Integer.parseInt(unicodeChars.substring(2 * i, 2 * (i + 1)), 16);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(ex);
                }
                ++i;
            }
            if (decoder != null) {
                try {
                    decoder.reset();
                    CharBuffer chars = decoder.decode(ByteBuffer.wrap(bytes));
                    return chars.toString();
                }
                catch (CharacterCodingException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            throw new RuntimeException("UTF-8 not available on this platform");
        }
        throw new IllegalArgumentException("Input string '" + unicodeChars + "' could not be split into bytes");
    }

    public static String stringToHex(String string) {
        if (encoder != null) {
            encoder.reset();
            try {
                ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(string));
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < byteBuffer.limit()) {
                    String nextByte = Integer.toHexString(byteBuffer.get(i) & 0xFF);
                    if (nextByte.length() == 1) {
                        sb.append('0');
                    }
                    sb.append(nextByte);
                    ++i;
                }
                return sb.toString().toUpperCase(Locale.ENGLISH);
            }
            catch (CharacterCodingException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        throw new RuntimeException("UTF-8 not available on this platform");
    }
}

