/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.core.comm.Activator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;

public class ExplorerHostnameVerifier
implements HostnameVerifier {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String ALLOW_OVERRIDE_HOSTNAME_VERIFICATION = "com.ibm.cics.core.connections.allowOverrideHostnameVerification";
    public static String FORCE_OVERRIDE_HOSTNAME_VERIFICATION = "com.ibm.cics.core.connections.forceOverrideHostnameVerification";
    DefaultHostnameVerifier dhv = new DefaultHostnameVerifier();
    private String overrideHost;

    public ExplorerHostnameVerifier() {
    }

    public ExplorerHostnameVerifier(String overrideHost) {
        this.overrideHost = overrideHost;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        Boolean allowOverrideHostnameVerification = Boolean.valueOf(System.getProperty(ALLOW_OVERRIDE_HOSTNAME_VERIFICATION, "true"));
        Boolean forceOverrideHostnameVerification = Boolean.valueOf(System.getProperty(FORCE_OVERRIDE_HOSTNAME_VERIFICATION, "false"));
        Boolean prefOverrideHostnameVerification = false;
        IPreferencesService preferencesService = Platform.getPreferencesService();
        if (preferencesService != null) {
            prefOverrideHostnameVerification = preferencesService.getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.overrideHostnameVerification", false, null);
        }
        if (forceOverrideHostnameVerification.booleanValue() || allowOverrideHostnameVerification.booleanValue() && prefOverrideHostnameVerification.booleanValue()) {
            return true;
        }
        if (this.overrideHost != null) {
            hostname = this.overrideHost;
        }
        return this.dhv.verify(hostname, session);
    }
}

