/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.query.QueryResult;
import com.ibm.cics.model.query.Request;
import com.ibm.cics.sm.comm.AbstractSystemManagerConnection;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.ISystemManagerResponseValues;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.cpsm.CPSMConnection;
import com.ibm.cics.sm.comm.sm.IModelNames;
import com.ibm.cics.sm.comm.sm.VSEConnectionException;
import com.ibm.cics.sm.comm.sm.WrongCMCIPortException;
import com.ibm.cics.sm.comm.sm.internal.AbstractSMConnection;
import com.ibm.cics.sm.comm.sm.internal.CMCIConnectionFinder;
import com.ibm.cics.sm.comm.sm.internal.Messages;
import com.ibm.cics.sm.comm.sm.internal.SMCICSConnection;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMConnection;
import com.ibm.cics.sm.comm.sm.internal.SMVSEConnection;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocketFactory;
import org.xml.sax.SAXParseException;

public class SMConnection
extends AbstractSMConnection
implements ISystemManagerConnection2,
IModelNames,
IResourceTables,
ISystemManagerResponseValues {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SMConnection.class);
    private AbstractSystemManagerConnection delegate;
    private SSLSocketFactory sslSocketFactory;

    public boolean isConnected() {
        return this.delegate != null && this.delegate.isConnected();
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public SMConnectionResponse add(String resourceType, IFilteredContext definition, IFilteredContext group) throws ConnectionException {
        return this.delegate.add(resourceType, definition, group);
    }

    public void connect() throws ConnectionException {
        block12: {
            debug.enter("connect", (Object)this);
            SMCPSMConnection newDelegate = null;
            try {
                try {
                    newDelegate = new SMCPSMConnection();
                    newDelegate.setConfiguration(this.getConfiguration());
                    if (this.sslSocketFactory != null) {
                        newDelegate.setSSLSocketFactory(this.sslSocketFactory);
                    }
                    debug.event("connect", (Object)newDelegate);
                    newDelegate.connect();
                }
                catch (SystemManagerConnectionException ex) {
                    debug.event("connect", (Object)ex);
                    if (ex.getCause() instanceof SAXParseException) {
                        int suggestedPort;
                        CPSMConnection connection = new CPSMConnection();
                        connection.setConfiguration(this.getConfiguration());
                        if (this.sslSocketFactory != null) {
                            newDelegate.setSSLSocketFactory(this.sslSocketFactory);
                        }
                        if ((suggestedPort = new CMCIConnectionFinder((ISystemManagerConnection)connection).getCMCIPort()) == -2) {
                            throw new ConnectionException(MessageFormat.format(Messages.SMConnection_pickedADataPort, this.getConfiguration().getPort()));
                        }
                        if (suggestedPort != -1) {
                            throw new WrongCMCIPortException(this.getConfiguration().getPort(), suggestedPort);
                        }
                    }
                    if (ex.getResponseCode() == 404) {
                        newDelegate = this.connectToSMSS(newDelegate);
                        break block12;
                    }
                    ex.setConfiguration(this.getConfiguration());
                    throw ex;
                }
            }
            finally {
                debug.event("connect", (Object)newDelegate);
                if (newDelegate != null && newDelegate.isConnected()) {
                    this.delegate = newDelegate;
                }
            }
        }
        debug.exit("connect");
    }

    private AbstractSystemManagerConnection connectToSMSS(AbstractSystemManagerConnection newDelegate) throws ConnectionException, SystemManagerConnectionException {
        try {
            newDelegate = new SMCICSConnection();
            newDelegate.setConfiguration(this.getConfiguration());
            if (this.sslSocketFactory != null) {
                newDelegate.setSSLSocketFactory(this.sslSocketFactory);
            }
            debug.event("connect", (Object)newDelegate);
            newDelegate.connect();
        }
        catch (VSEConnectionException vCE) {
            debug.event("connect", (Object)vCE);
            newDelegate = new SMVSEConnection();
            newDelegate.setConfiguration(this.getConfiguration());
            if (this.sslSocketFactory != null) {
                newDelegate.setSSLSocketFactory(this.sslSocketFactory);
            }
            debug.event("connect", (Object)newDelegate);
            newDelegate.connect();
        }
        return newDelegate;
    }

    public SMConnectionResponse create(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        return this.delegate.create(resourceType, context, record);
    }

    public SMConnectionResponse delete(String resourceType, IContext context) throws SystemManagerConnectionException {
        return this.delegate.delete(resourceType, context);
    }

    public void discard(String stub) throws ConnectionException {
        this.delegate.discard(stub);
    }

    public void disconnect() throws ConnectionException {
        debug.enter("disconnect", (Object)this);
        if (this.delegate != null) {
            this.delegate.disconnect();
        }
        debug.exit("disconnect");
    }

    public SMConnectionResponse fetch(String stub, int position, int count) throws ConnectionException {
        return this.delegate.fetch(stub, position, count);
    }

    public SMConnectionResponse get(String resourceType, IContext context) throws ConnectionException {
        return this.delegate.get(resourceType, context);
    }

    public int count(String resourceType, IContext context) throws ConnectionException {
        return this.delegate.count(resourceType, context);
    }

    public String getActions(String resourceName, IContext context) {
        return this.delegate.getActions(resourceName, context);
    }

    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        return this.delegate.checkOperation(resourceType, context, operation);
    }

    public SMConnectionResponse getResources(String resourceName, IContext context) throws ConnectionException {
        return this.delegate.getResources(resourceName, context);
    }

    public String getServerApplID() {
        return this.delegate.getServerApplID();
    }

    public SMConnectionResponse install(String resourceType, IFilteredContext definition, IScopedContext target) throws ConnectionException {
        return this.delegate.install(resourceType, definition, target);
    }

    public boolean isSecure() {
        return this.delegate != null ? this.delegate.isSecure() : false;
    }

    public SMConnectionResponse perform(String resourceType, IContext context, ICICSAction action) throws ConnectionException {
        return this.delegate.perform(resourceType, context, action);
    }

    public SMConnectionResponse remove(String resourceType, IFilteredContext definition, IFilteredContext group) throws SystemManagerConnectionException {
        return this.delegate.remove(resourceType, definition, group);
    }

    public SMConnectionResponse update(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        return this.delegate.update(resourceType, context, record);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + (this.delegate != null ? this.delegate.toString() : "") + "]";
    }

    public List<IRepository> getRepositories() {
        return this.delegate instanceof ISystemManagerConnection2 ? ((ISystemManagerConnection2)this.delegate).getRepositories() : Collections.emptyList();
    }

    public boolean isAggregatable(ICICSType<?> type) {
        return this.delegate.isAggregatable(type);
    }

    public QueryResult graphQuery(Consumer<Request> query) throws ConnectionException {
        return this.delegate.graphQuery(query);
    }

    public boolean isGraphQuerySupported() {
        return this.delegate.isGraphQuerySupported();
    }

    public boolean isSMSS() {
        return this.delegate.isSMSS();
    }
}

