/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.sm.internal.GraphQLFilterNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class GraphQLFilterCompositeOperatorNode
implements GraphQLFilterNode {
    private final String name;
    private final List<GraphQLFilterNode> filterNodes;

    public GraphQLFilterCompositeOperatorNode(String name, List<GraphQLFilterNode> filterNodes) {
        if (filterNodes == null || filterNodes.isEmpty()) {
            throw new IllegalArgumentException("filterNodes must not be empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        this.name = name;
        this.filterNodes = filterNodes;
    }

    public String getName() {
        return this.name;
    }

    public List<GraphQLFilterNode> getFilterNodes() {
        return Collections.unmodifiableList(this.filterNodes);
    }

    @Override
    public void render(StringBuilder sb) {
        sb.append(this.name).append(":[");
        Iterator<GraphQLFilterNode> iter = this.filterNodes.iterator();
        while (iter.hasNext()) {
            sb.append("{");
            GraphQLFilterNode graphQLFilterNode = iter.next();
            graphQLFilterNode.render(sb);
            sb.append("},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
    }

    public Builder toBuilder() {
        return new Builder(this.name, this.filterNodes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filterNodes == null ? 0 : this.filterNodes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphQLFilterCompositeOperatorNode other = (GraphQLFilterCompositeOperatorNode)obj;
        if (this.filterNodes == null ? other.filterNodes != null : !this.filterNodes.equals(other.filterNodes)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class Builder {
        private final String name;
        private List<GraphQLFilterNode> filterNodes = new ArrayList<GraphQLFilterNode>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder(String name, List<GraphQLFilterNode> filterNodes) {
            this(name);
            this.children(filterNodes);
        }

        public Builder child(GraphQLFilterNode ... filterNode) {
            return this.children(Arrays.asList(filterNode));
        }

        public Builder child(Builder ... builders) {
            Builder[] builderArray = builders;
            int n = builders.length;
            int n2 = 0;
            while (n2 < n) {
                Builder builder = builderArray[n2];
                this.filterNodes.add(builder.build());
                ++n2;
            }
            return this;
        }

        public Builder children(List<GraphQLFilterNode> filterNodes) {
            this.filterNodes.addAll(filterNodes);
            return this;
        }

        public GraphQLFilterCompositeOperatorNode build() {
            return new GraphQLFilterCompositeOperatorNode(this.name, this.filterNodes);
        }
    }
}

