/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ibm.cics.sm.comm.sm.internal.graphql.AbstractValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.osgi.util.NLS;

class ArrayValueParser<T>
extends AbstractValueParser<List<T>> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private NodeParser<JsonElement, T> parser;

    private ArrayValueParser(NodeParser<JsonElement, T> parser) {
        this.parser = parser;
    }

    public static <T> ArrayValueParser<T> nonNullValues(AbstractValueParser<T> valueParser) {
        return new ArrayValueParser<Object>(e -> {
            Optional t = valueParser.parse((JsonElement)e);
            return t.orElseThrow(() -> new NodeParseException("Non null array value was null"));
        });
    }

    public static <T> ArrayValueParser<Optional<T>> nullableValues(AbstractValueParser<T> valueParser) {
        return new ArrayValueParser<Optional<T>>(valueParser);
    }

    @Override
    public List<T> parseValue(JsonElement je) throws NodeParseException {
        if (je.isJsonArray()) {
            JsonArray array = je.getAsJsonArray();
            ArrayList<T> list = new ArrayList<T>(array.size());
            int i = 0;
            while (i < array.size()) {
                JsonElement jsonElement = array.get(i);
                try {
                    list.add(this.parser.parse(jsonElement));
                }
                catch (NodeParseException e) {
                    throw new NodeParseException(NLS.bind((String)"[{0}]: {1}", (Object)i, (Object)e.getMessage()), e);
                }
                ++i;
            }
            return list;
        }
        throw new NodeParseException("property was not a json array");
    }
}

