/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.cics.sm.comm.sm.internal.graphql.AbstractValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParserOptional;
import java.util.Optional;
import org.eclipse.osgi.util.NLS;

class FieldParser<T>
implements NodeParserOptional<JsonObject, T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String property;
    private AbstractValueParser<T> valueParser;

    public FieldParser(String property, AbstractValueParser<T> valueParser) {
        this.property = property;
        this.valueParser = valueParser;
    }

    @Override
    public Optional<T> parse(JsonObject parent) throws NodeParseException {
        try {
            if (!parent.has(this.property)) {
                throw new NodeParseException("Property " + this.property + " was missing");
            }
            JsonElement child = parent.get(this.property);
            return this.valueParser.parse(child);
        }
        catch (NodeParseException e) {
            throw new NodeParseException(NLS.bind((String)"{0}: {1}", (Object)this.property, (Object)e.getMessage()), e);
        }
    }
}

