/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonObject;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParserOptional;
import com.ibm.cics.sm.comm.sm.internal.graphql.ObjectContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.ObjectValueParser;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class Node<T>
extends ObjectValueParser<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ObjectContext oc;
    private final String typeId;

    public Node(String typeId) {
        this.typeId = typeId;
    }

    public void setObjectContext(ObjectContext oc) {
        this.oc = oc;
    }

    public String getGraphQLTypeName() {
        return this.typeId;
    }

    protected <X extends Node<X>> void fragmentReference(String fragmentId) {
        this.oc.fragmentReference(fragmentId, this);
    }

    protected NodeParserOptional<JsonObject, Boolean> booleanField(String name) {
        return this.oc.booleanField(name);
    }

    protected NodeParserOptional<JsonObject, String> stringField(String name) {
        return this.oc.stringField(name);
    }

    protected NodeParserOptional<JsonObject, Long> longField(String name) {
        return this.oc.longField(name);
    }

    protected NodeParserOptional<JsonObject, Double> doubleField(String name) {
        return this.oc.doubleField(name);
    }

    protected <SubType, SubNode extends Node<SubType>> NodeParserOptional<JsonObject, List<SubType>> arrayFieldNonNullValues(String name, SubNode node, Consumer<? super SubNode> query) {
        return this.arrayFieldNonNullValues(name, null, node, query);
    }

    protected <SubType, SubNode extends Node<SubType>> NodeParserOptional<JsonObject, List<SubType>> arrayFieldNonNullValues(String name, Consumer<ArgumentsContext> args, SubNode node, Consumer<? super SubNode> query) {
        return this.oc.arrayFieldNonNullValues(name, args, node, query);
    }

    protected <SubType, SubNode extends Node<SubType>> NodeParserOptional<JsonObject, List<Optional<SubType>>> arrayFieldNullableValues(String name, SubNode node, Consumer<? super SubNode> query) {
        return this.arrayFieldNullableValues(name, null, node, query);
    }

    protected <SubType, SubNode extends Node<SubType>> NodeParserOptional<JsonObject, List<Optional<SubType>>> arrayFieldNullableValues(String name, Consumer<ArgumentsContext> args, SubNode node, Consumer<? super SubNode> query) {
        return this.oc.arrayFieldNullableValues(name, args, node, query);
    }

    protected <SubType, SubNode extends Node<SubType>> NodeParserOptional<JsonObject, SubType> objectField(String name, SubNode node, Consumer<? super SubNode> query) {
        return this.oc.objectField(name, null, node, query);
    }

    protected <SubType, SubNode extends Node<SubType>> NodeParserOptional<JsonObject, SubType> objectField(String name, Consumer<ArgumentsContext> args, SubNode node, Consumer<? super SubNode> query) {
        return this.oc.objectField(name, args, node, query);
    }

    protected NodeParserOptional<JsonObject, ObjectContext.UnionResult> unionObjectField(String name, List<ObjectContext.NodeQueryTuple<?, ?>> nodeQueries) {
        return this.oc.unionObjectField(name, nodeQueries);
    }

    public static <K, V> Map<K, V> parseMap(NodeParser<JsonObject, Map<K, V>> parser, JsonObject o) throws NodeParseException {
        return parser != null ? parser.parse(o) : Collections.emptyMap();
    }

    public static <T> List<T> parseOptionalList(NodeParser<JsonObject, Optional<List<T>>> parser, JsonObject o) throws NodeParseException {
        return parser != null ? parser.parse(o).orElse(Collections.emptyList()) : Collections.emptyList();
    }

    public static <T> List<T> parseList(NodeParser<JsonObject, List<T>> parser, JsonObject o) throws NodeParseException {
        return parser != null ? parser.parse(o) : Collections.emptyList();
    }

    public static <T> Optional<T> parseOptionalResult(NodeParser<JsonObject, Optional<T>> parser, JsonObject o) throws NodeParseException {
        if (parser != null) {
            return parser.parse(o);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> parse(NodeParser<JsonObject, T> parser, JsonObject o) throws NodeParseException {
        if (parser != null) {
            return Optional.of(parser.parse(o));
        }
        return Optional.empty();
    }
}

