/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.offline;

import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.query.QueryResult;
import com.ibm.cics.model.query.Request;
import com.ibm.cics.model.topology.CPSM;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSplex;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class OfflineCPSM
implements CPSM {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, OfflineCICSplex> cicsplexes = new HashMap<String, OfflineCICSplex>();

    public Map<String, OfflineCICSplex> getCICSplexes() {
        return Collections.unmodifiableMap(this.cicsplexes);
    }

    public Optional<OfflineCICSplex> getCICSplex(String name) {
        return Optional.ofNullable(this.cicsplexes.get(name));
    }

    public OfflineCICSplex getOrCreateOfflineCICSplex(String name) {
        if (this.cicsplexes.containsKey(name)) {
            return this.cicsplexes.get(name);
        }
        OfflineCICSplex plex = new OfflineCICSplex(name, this);
        this.cicsplexes.put(name, plex);
        return plex;
    }

    public QueryResult graphQuery(Consumer<Request> request) throws CICSActionException {
        throw new UnsupportedOperationException();
    }

    public boolean isGraphQuerySupported() {
        return false;
    }
}

