/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectQueryImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;

class FilterArgumentHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    FilterArgumentHelper() {
    }

    static Consumer<ArgumentsContext> toGraphQLArgument(FilterExpression filter) {
        ToGraphQLFilterVisitor visitor = new ToGraphQLFilterVisitor();
        filter.accept((IFilterVisitor)visitor);
        return visitor.getFilterWriter();
    }

    static Set<ICICSAttribute<?>> getIncludedAttributes(FilterExpression filter) {
        GetIncludedAttributes visitor = new GetIncludedAttributes();
        filter.accept((IFilterVisitor)visitor);
        return visitor.getIncludedAttributes();
    }

    private static class CompositeOperation
    implements Consumer<ArgumentsContext> {
        private final List<Consumer<ArgumentsContext>> operations = new ArrayList<Consumer<ArgumentsContext>>();
        private final FilterExpression.CompositeOperator operator;

        public CompositeOperation(FilterExpression.CompositeOperator operator) {
            this.operator = operator;
        }

        @Override
        public void accept(ArgumentsContext ac) {
            ac.argArray(CompositeOperation.getField(this.operator), aac -> this.operations.forEach(aac::valueComplex));
        }

        private static String getField(FilterExpression.CompositeOperator operator) {
            switch (operator) {
                case AND: {
                    return "_and";
                }
                case OR: {
                    return "_or";
                }
            }
            throw new IllegalStateException("Unrecognized composite operator: " + operator);
        }
    }

    static class GetIncludedAttributes
    implements IFilterVisitor {
        private Set<ICICSAttribute<?>> includedAttributes = new HashSet();

        GetIncludedAttributes() {
        }

        public Set<ICICSAttribute<?>> getIncludedAttributes() {
            return this.includedAttributes;
        }

        public void or() {
        }

        public void and() {
        }

        public void not() {
        }

        public <T> void eq(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }

        public <T> void is(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }

        public <T> void le(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }

        public <T> void lt(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }

        public <T> void ge(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }

        public <T> void gt(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }

        public <T> void ne(ICICSAttribute<T> attribute, T value) {
            this.includedAttributes.add(attribute);
        }
    }

    static class ToGraphQLFilterVisitor
    implements IFilterVisitor {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX");
        private Stack<Consumer<ArgumentsContext>> stack = new Stack();

        ToGraphQLFilterVisitor() {
        }

        public Consumer<ArgumentsContext> getFilterWriter() {
            return ac -> {
                if (!this.stack.isEmpty()) {
                    ac.argComplex("filter", this.stack.pop());
                }
            };
        }

        private <T> void filterValue(ICICSAttribute<T> attribute, T value, FilterExpression.AttributeOperator operator) {
            Consumer<ArgumentsContext> operatorWriter = ac -> {
                ArgumentsContext argumentsContext = ac.argEnum("operator", operator.name());
            };
            Consumer<ArgumentsContext> valueWriter = this.getValueWriter(attribute, value, operatorWriter);
            this.stack.push(ac -> {
                ArgumentsContext argumentsContext = ac.argComplex(CICSObjectQueryImpl.getAttributeFieldName(attribute), valueWriter);
            });
        }

        private <T> Consumer<ArgumentsContext> getValueWriter(ICICSAttribute<T> attribute, T value, Consumer<ArgumentsContext> operatorWriter) {
            Class attributeType = attribute.getType();
            if (attributeType == String.class) {
                return ac -> operatorWriter.accept(ac.argString("value", (String)value));
            }
            if (attributeType == Long.class) {
                return ac -> operatorWriter.accept(ac.argLong("value", (Long)value));
            }
            if (ICICSEnum.class.isAssignableFrom(attributeType)) {
                if (((ICICSEnum)value).isSpecialValue()) {
                    throw new IllegalArgumentException("Special values can't be serialized");
                }
                return ac -> operatorWriter.accept(ac.argString("value", attribute.internalToExternal(value)));
            }
            if (attributeType == Date.class) {
                return ac -> operatorWriter.accept(ac.argString("value", this.dateFormat.format((Date)value)));
            }
            throw new RuntimeException("Unrecognized attribute type: " + attribute);
        }

        public void or() {
            this.composite(FilterExpression.CompositeOperator.OR);
        }

        public void and() {
            this.composite(FilterExpression.CompositeOperator.AND);
        }

        private void composite(FilterExpression.CompositeOperator operator) {
            CompositeOperation toPush;
            CompositeOperation cl;
            Consumer<ArgumentsContext> sr = this.stack.pop();
            Consumer<ArgumentsContext> sl = this.stack.pop();
            CompositeOperation cr = sr instanceof CompositeOperation ? (CompositeOperation)sr : null;
            CompositeOperation compositeOperation = cl = sl instanceof CompositeOperation ? (CompositeOperation)sl : null;
            if (cr != null && cl != null && cr.operator == operator && cl.operator == operator) {
                cl.operations.addAll(cr.operations);
                toPush = cl;
            } else if (cr != null && cr.operator == operator) {
                cr.operations.add(0, sl);
                toPush = cr;
            } else if (cl != null && cl.operator == operator) {
                cl.operations.add(sr);
                toPush = cl;
            } else {
                toPush = new CompositeOperation(operator);
                toPush.operations.add(sl);
                toPush.operations.add(sr);
            }
            this.stack.push(toPush);
        }

        public void not() {
            throw new IllegalStateException("NOT expressions are not supported by GraphQL API");
        }

        public <T> void eq(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.EQ);
        }

        public <T> void is(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.IS);
        }

        public <T> void le(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.LE);
        }

        public <T> void lt(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.LT);
        }

        public <T> void ge(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.GE);
        }

        public <T> void gt(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.GT);
        }

        public <T> void ne(ICICSAttribute<T> attribute, T value) {
            this.filterValue(attribute, value, FilterExpression.AttributeOperator.NE);
        }
    }
}

