/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.ui.Messages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class VersionTextValueHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static UpdateValueStrategy getEMFToVersionTextValueUpdateValueStrategy() {
        return new UpdateValueStrategy().setConverter((IConverter)new Converter(Integer.class, Long.class){

            public Object convert(Object fromObject) {
                return fromObject == null ? null : Long.valueOf(((Integer)fromObject).longValue());
            }
        });
    }

    public static UpdateValueStrategy getVersionTextValuePartToEMFUpdateValueStrategy() {
        return new UpdateValueStrategy().setConverter((IConverter)new Converter(Long.class, Integer.class){

            public Object convert(Object fromObject) {
                return fromObject == null ? null : Integer.valueOf(((Long)fromObject).intValue());
            }
        }).setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                Long longValue = (Long)value;
                if (longValue != null && longValue > Integer.MAX_VALUE) {
                    return new Status(4, "com.ibm.cics.core.ui", Messages.getString("VersionTextValueHelper.overlongSectionError", longValue));
                }
                return Status.OK_STATUS;
            }
        });
    }

    public static UpdateValueStrategy getVersionTextUpdateValueStrategy() {
        return new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                Pattern pattern = Pattern.compile("([0-9]+)(\\.([0-9]+)(\\.([0-9]+))?)?");
                Matcher matcher = pattern.matcher((String)value);
                if (!matcher.matches()) {
                    return new Status(4, "com.ibm.cics.core.ui", Messages.getString("VersionTextValueHelper.invalidFormatError"));
                }
                String major = matcher.group(1);
                IStatus parseStatus = this.parseableAsInteger(major);
                if (!parseStatus.isOK()) {
                    return parseStatus;
                }
                String minor = matcher.group(3);
                if (minor != null) {
                    parseStatus = this.parseableAsInteger(minor);
                    if (!parseStatus.isOK()) {
                        return parseStatus;
                    }
                    String micro = matcher.group(5);
                    if (micro != null && !(parseStatus = this.parseableAsInteger(micro)).isOK()) {
                        return parseStatus;
                    }
                }
                return Status.OK_STATUS;
            }

            private IStatus parseableAsInteger(String number) {
                try {
                    Integer.parseInt(number);
                    return Status.OK_STATUS;
                }
                catch (NumberFormatException e) {
                    return new Status(4, "com.ibm.cics.core.ui", Messages.getString("VersionTextValueHelper.overlongSectionError", number));
                }
            }
        });
    }
}

