/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.progress.IElementCollector;

public class AdapterUtility {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AdapterUtility.class);

    public static void getSystemGroups(IElementCollector collector, IProgressMonitor monitor, ICPSM cpsm, IContext context) {
        try {
            if (cpsm.checkPermission(ICICSOperation.GET, (ICICSType)CICSRegionGroupDefinitionType.getInstance())) {
                Object[] groups = (ICICSRegionGroupDefinition[])cpsm.getDefinitions2((ICICSType)CICSRegionGroupDefinitionType.getInstance(), context);
                collector.add(groups, monitor);
            }
        }
        catch (CICSSystemManagerException e) {
            debug.warning("getSystemGroups", (Object)e);
        }
    }

    public static boolean cmasNameIsAvailable(ICICSplex cicsplex) {
        return !cicsplex.getCMASName().equals(CICSplexType.CMAS_NAME.getUnsupportedValue());
    }

    public static Map<String, ICICSplex> getUniqueCICSplexes(ICPSM cpsm) {
        TreeMap<String, ICICSplex> allCICSplexes = new TreeMap<String, ICICSplex>();
        ICICSplex[] iCICSplexArray = cpsm.getCICSplexes();
        int n = iCICSplexArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSplex cicsPlex = iCICSplexArray[n2];
            String name = cicsPlex.getName();
            ICICSplex old = (ICICSplex)allCICSplexes.get(name);
            if (old != null) {
                if (cicsPlex.getMPStatus() == ICICSEnums.YesNoValue.YES) {
                    allCICSplexes.remove(name);
                } else if (old.getMPStatus() == ICICSEnums.YesNoValue.YES || cicsPlex.getAccessType() != ICICSplex.AccessTypeValue.LOCAL) {
                    cicsPlex = old;
                }
            }
            allCICSplexes.put(name, cicsPlex);
            ++n2;
        }
        return allCICSplexes;
    }
}

