/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.adapters.WLMAbstractRuleRelatedAdapter;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTarget;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public abstract class WLMAbstractTargetsAdapter
extends WLMAbstractRuleRelatedAdapter
implements IDeferredWorkbenchAdapter,
IAdaptableTreeNode,
IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object[] children;

    public WLMAbstractTargetsAdapter(IWorkload wlmActiveWorkload) {
        super(wlmActiveWorkload);
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        collector.add(this.getChildren(object), monitor);
    }

    public Object[] getChildren(Object o) {
        this.cacheChildrenIfNotKnown();
        ArrayList<Object> targetsAsAdapters = new ArrayList<Object>(this.children.length);
        Object[] objectArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Object targetAdapter = this.convertChildObjectToTargetAdapter(object);
            if (targetAdapter != null) {
                targetsAsAdapters.add(targetAdapter);
            }
            ++n2;
        }
        return targetsAsAdapters.toArray();
    }

    protected abstract Object convertChildObjectToTargetAdapter(Object var1);

    public String getLabel(Object o) {
        return Messages.getString("WorkbenchAdapterFactory.targets");
    }

    public String getDecoration() {
        this.cacheChildrenIfNotKnown();
        return this.getActiveChildrenCount() + "/" + this.children.length;
    }

    private int getActiveChildrenCount() {
        this.cacheChildrenIfNotKnown();
        int active = 0;
        Object[] objectArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IWorkloadTarget && this.isWorkloadTargetActive((IWorkloadTarget)object)) {
                ++active;
            }
            ++n2;
        }
        return active;
    }

    private boolean isWorkloadTargetActive(IWorkloadTarget target) {
        return target.getStatus().equals((Object)IWorkloadTarget.StatusValue.ACTIVE);
    }

    private synchronized void cacheChildrenIfNotKnown() {
        if (this.children == null) {
            this.children = this.getChildrenImpl();
        }
    }

    protected abstract Object[] getChildrenImpl();

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object getAdapter(Class adapterType) {
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return null;
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        return adapter;
    }
}

