/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.model.WorkloadTargetStatusType;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.adapters.IDecoratableWLMAdapter;
import com.ibm.cics.core.ui.adapters.IWorkloadTargetSource;
import com.ibm.cics.core.ui.adapters.WLMAbstractRuleRelatedAdapter;
import com.ibm.cics.core.ui.adapters.WLMDefaultRoutingTargetsAdapter;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.model.ui.ModelUIPlugin;
import com.ibm.cics.sm.comm.IContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WLMDefaultRuleTargetAdapter
extends WLMAbstractRuleRelatedAdapter
implements IAdaptableTreeNode,
IAdaptable,
IDeferredWorkbenchAdapter,
IDecoratableWLMAdapter,
IWorkloadTargetSource,
IContextProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private WLMDefaultRoutingTargetsAdapter parentAdapter;
    private IWorkloadTarget target;

    public WLMDefaultRuleTargetAdapter(IWorkloadTarget target, IWorkload wlmActiveWorkload, WLMDefaultRoutingTargetsAdapter wlmDefaultRoutingTargetsAdapter) {
        super(wlmActiveWorkload);
        this.parentAdapter = wlmDefaultRoutingTargetsAdapter;
        this.target = target;
    }

    public ICPSM getCPSM() {
        return ((ICoreObject)this.activeWorkload).getCPSM();
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        collector.add(this.getChildren(object), monitor);
    }

    public boolean isContainer() {
        return false;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return this.parentAdapter;
    }

    public String getLabel(Object o) {
        return this.target.getName();
    }

    public String getTargetStatus() {
        return this.target.getStatus().toString();
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor descriptor = this.target.getStatus().equals((Object)IWorkloadTarget.StatusValue.QUIESCED) ? UIPlugin.IMGD_QUIESCED_ACTIVE_AOR : ModelUIPlugin.getTypeImageDescriptor((ICICSType)WorkloadTargetStatusType.getInstance());
        return descriptor;
    }

    public ICICSObject getEditorInputObject() {
        return this.getAdaptedWorkload();
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object getAdapter(Class adapterType) {
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return new CICSObjectPropertySource((ICICSObject)WLMDefaultRuleTargetAdapter.this.target);
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        return adapter;
    }

    @Override
    public String getDecoration() {
        return this.getDecorationForTarget(this.target);
    }

    @Override
    public IWorkloadTarget getTarget() {
        return this.target;
    }

    public IContext getIContext() {
        return new ScopedContext((IContext)WLMDefaultRuleTargetAdapter.getWorkloadBaseContext(this.activeWorkload), this.getTarget().getName());
    }
}

