/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.WorkloadSpecificationType;
import com.ibm.cics.core.model.WorkloadType;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.decorators.LazyQueryCompositeImageDescriptor;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadSpecification;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class WLMWorkloadTreeAdapter
implements IDeferredWorkbenchAdapter,
IAdaptable,
IAdaptableTreeNode,
IContextProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(WLMWorkloadTreeAdapter.class);
    private ICICSplex cicsPlex;
    private boolean hasChildren = true;
    private boolean errorState = false;

    public WLMWorkloadTreeAdapter(ICICSplex cicsPlex) {
        this.cicsPlex = cicsPlex;
    }

    public String toString() {
        return "IDeferredWorkbenchAdapter[workloadTreeAdapter]";
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        Object imageDescriptor = UIPlugin.IMGD_WORKLOAD_GROUP;
        if (this.errorState) {
            ImageDescriptor error = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
            imageDescriptor = new LazyQueryCompositeImageDescriptor((ImageDescriptor)imageDescriptor, error);
        }
        return imageDescriptor;
    }

    public void setErrorState(boolean error) {
        this.errorState = error;
    }

    public String getLabel(Object o) {
        return Messages.getString("WLMWorkloadTreeAdapter.workload_management");
    }

    public Object getParent(Object o) {
        return null;
    }

    public void checkForChildren(IProgressMonitor monitor) throws CICSSystemManagerException {
        int workloadSpecCount;
        if (monitor.isCanceled()) {
            return;
        }
        this.hasChildren = false;
        ICPSM cpsm = ((ICoreObject)this.cicsPlex).getCPSM();
        if (!cpsm.checkPermission(ICICSOperation.GET, (ICICSType)WorkloadSpecificationType.getInstance())) {
            throw new CICSSystemManagerException("CPSM Workload not supported.");
        }
        Context context = new Context(this.cicsPlex.getName());
        int workloadCount = cpsm.count(WorkloadType.getInstance().getResourceTableName(), (IContext)context);
        if (workloadCount > 0) {
            this.hasChildren = true;
        }
        if ((workloadSpecCount = cpsm.count(WorkloadSpecificationType.getInstance().getResourceTableName(), (IContext)context)) > 0) {
            this.hasChildren = true;
        }
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        Context context = new Context(this.cicsPlex.getName());
        ICoreObject coreObject = (ICoreObject)this.cicsPlex;
        ICPSM cpsm = coreObject.getCPSM();
        Object[] activeWorkloads = (IWorkload[])cpsm.getDefinitions((ICICSType)WorkloadType.getInstance(), (IContext)context);
        debug.event("fetchDeferredChildren", (Object)"WorkloadType", (Object)activeWorkloads.length);
        IWorkloadSpecification[] specifications = (IWorkloadSpecification[])cpsm.getDefinitions((ICICSType)WorkloadSpecificationType.getInstance(), (IContext)context);
        debug.event("fetchDeferredChildren", (Object)"WorkloadSpecificationType", (Object)specifications.length);
        ArrayList toAdd = new ArrayList();
        collector.add(activeWorkloads, monitor);
        IWorkloadSpecification[] iWorkloadSpecificationArray = specifications;
        int n = specifications.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkloadSpecification workloadSpec = iWorkloadSpecificationArray[n2];
            if (!this.isWorkloadActive(workloadSpec.getName(), (IWorkload[])activeWorkloads)) {
                collector.add((Object)workloadSpec, monitor);
            }
            ++n2;
        }
        collector.add(toAdd.toArray(), monitor);
    }

    private boolean isWorkloadActive(String workloadName, IWorkload[] activeWorkloads) {
        IWorkload[] iWorkloadArray = activeWorkloads;
        int n = activeWorkloads.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkload activeWorkload = iWorkloadArray[n2];
            if (activeWorkload.getName().equals(workloadName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isContainer() {
        return this.hasChildren;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object getAdapter(Class adapterType) {
        debug.enter("getAdapter", (Object)this, (Object)adapterType);
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return null;
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        debug.exit("getAdapter", adapter);
        return adapter;
    }

    public ICPSM getCPSM() {
        return null;
    }

    public IContext getIContext() {
        return new Context(this.cicsPlex.getName());
    }
}

