/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.flhsupport;

import com.ibm.cics.core.ui.Debug;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

class FLHelpSynchronization {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FLHelpSynchronization.class.getPackage().getName());
    public static final String helpViewId = "org.eclipse.help.ui.HelpView";
    private boolean enabled = false;
    private IScopeContext[] cachedScopeContexts;

    FLHelpSynchronization() {
    }

    public void setEnabled(boolean newState) {
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"setEnabled", (Object)newState);
        }
        this.enabled = newState;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void requestWorkbenchHelpSystemDisplayHelp(final Object helpContextId) {
        if (this.enabled && helpContextId instanceof String && ((String)helpContextId).startsWith("com.ibm.cics.core.ui")) {
            IViewPart helpView;
            if (Debug.DEBUG_SELECTION) {
                Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"requestWorkbenchHelpSystemDisplayHelp", (Object)helpContextId);
            }
            if ((helpView = this.findHelpViewIfVisibleAndUsable()) != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IHelpResource[] topics;
                        IContext context = HelpSystem.getContext((String)((String)helpContextId));
                        if (context != null && (topics = context.getRelatedTopics()) != null && topics.length > 0) {
                            ((HelpView)helpView).showHelp(topics[0].getHref());
                        }
                    }
                });
            }
        }
    }

    private IViewPart findHelpViewIfVisibleAndUsable() {
        boolean winfopop;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart helpView = activePage.findView(helpViewId);
        IViewPart result = null;
        if (helpView != null && activePage.isPartVisible((IWorkbenchPart)helpView) && !(winfopop = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "window_infopop", false, this.getPreferenceScopeToSearchForHelpInfopopOption()))) {
            result = helpView;
        }
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHelpSynchronization.class.getName(), (String)"findHelpViewIfVisibleAndUsable", result);
        }
        return result;
    }

    private IScopeContext[] getPreferenceScopeToSearchForHelpInfopopOption() {
        if (this.cachedScopeContexts == null) {
            this.cachedScopeContexts = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        }
        return this.cachedScopeContexts;
    }
}

