/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.LocalTransactionType;
import com.ibm.cics.core.model.OperationTypesWrapper;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.model.ProgramType;
import com.ibm.cics.core.model.RemoteTransactionType;
import com.ibm.cics.core.model.URIMapType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.ApplicationContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;

public class ApplicationOperationsNodeDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(ApplicationOperationsNodeDeferredWorkbenchAdapter.class);
    private final IApplication application;

    public ApplicationOperationsNodeDeferredWorkbenchAdapter(CloudInput aCloudInput, IApplication application) {
        super(aCloudInput);
        this.application = application;
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = CloudMessages.ApplicationOperationsNodeDeferredWorkbenchAdapter_operationsLabel;
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = UIPlugin.IMGD_OPERATION_GROUP;
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    @Override
    public Object[] getDataChildren(Object inputElement) {
        Object[] results;
        DEBUG.enter("getDataChildren", (Object)this, inputElement);
        try {
            ArrayList<OperationTypesWrapper> operations = new ArrayList<OperationTypesWrapper>();
            this.addOperation(operations, SupportEntryPointResourceType.PROGRAM);
            this.addOperation(operations, SupportEntryPointResourceType.URIMAP);
            this.addOperation(operations, SupportEntryPointResourceType.LOCTRAN);
            this.addOperation(operations, SupportEntryPointResourceType.REMTRAN);
            Collections.sort(operations, new Comparator<OperationTypesWrapper>(){

                @Override
                public int compare(OperationTypesWrapper wrapper1, OperationTypesWrapper wrapper2) {
                    return wrapper1.getOperationName().compareTo(wrapper2.getOperationName());
                }
            });
            results = operations.toArray();
        }
        catch (SystemManagerConnectionException e) {
            results = new Object[]{new ErrorWrapper(e)};
        }
        DEBUG.exit("getDataChildren", (Object)results);
        return results;
    }

    private void addOperation(List<OperationTypesWrapper> operations, SupportEntryPointResourceType resourceType) throws SystemManagerConnectionException {
        List<ICICSObject> resourceForBundlePart = this.getResourceForApplication(resourceType);
        for (ICICSObject resource : resourceForBundlePart) {
            this.addUniqueOperation(operations, (ICICSResource)resource);
        }
    }

    private boolean isInvalidParmException(CICSSystemManagerException e) {
        SystemManagerConnectionException smce;
        int reason = 1315;
        int response = 1028;
        Throwable cause = e.getCause();
        return cause instanceof SystemManagerConnectionException && reason == (smce = (SystemManagerConnectionException)cause).getReason() && response == smce.getResponse();
    }

    private List<ICICSObject> getResourceForApplication(SupportEntryPointResourceType resourceType) throws SystemManagerConnectionException {
        ArrayList<ICICSObject> results;
        block5: {
            DEBUG.enter("getResourceForApplication", (Object)this);
            String platformName = this.getPlatformNameFromPlatdef(this.application.getPlatformDefinitionName());
            if (platformName.isEmpty()) {
                return Collections.emptyList();
            }
            FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), resourceType.getPlatformName(), platformName);
            filteredContext.setAttributeValue(resourceType.getApplicationName(), (Object)this.application.getName());
            filteredContext.setAttributeValue(resourceType.getMajorVersion(), (Object)this.application.getMajorVersion());
            filteredContext.setAttributeValue(resourceType.getMinorVersion(), (Object)this.application.getMinorVersion());
            filteredContext.setAttributeValue(resourceType.getMicroVersion(), (Object)this.application.getMicroVersion());
            ApplicationContext applicationContext = new ApplicationContext(this.getContext(), platformName, this.application.getName(), this.application.getMajorVersion().longValue(), this.application.getMinorVersion().longValue(), this.application.getMicroVersion().longValue());
            results = new ArrayList<ICICSObject>();
            try {
                results.addAll(Arrays.asList(this.getCICSObjectsWithoutListeners(resourceType.getType(), (IContext)filteredContext)));
            }
            catch (CICSSystemManagerException e) {
                DEBUG.error("getResourceForApplication", (Throwable)e);
            }
            try {
                results.addAll(Arrays.asList(this.getCICSObjectsWithoutListeners(resourceType.getType(), (IContext)applicationContext)));
            }
            catch (CICSSystemManagerException e) {
                if (this.isInvalidParmException(e)) break block5;
                DEBUG.error("getResourceForApplication", (Throwable)e);
            }
        }
        DEBUG.exit("getResourceForApplication", results);
        return results;
    }

    private String getPlatformNameFromPlatdef(String platdef) throws SystemManagerConnectionException {
        String platformName;
        block3: {
            DEBUG.enter("getPlatformNameFromPlatdef", (Object)this, (Object)platdef);
            platformName = "";
            FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), PlatformType.PLATFORM_DEFINITION_NAME, platdef);
            try {
                List results = this.getCICSObjects(PlatformType.getInstance(), (IContext)filteredContext);
                if (results.size() > 0) {
                    IPlatform platform = (IPlatform)results.get(0);
                    platformName = platform.getName();
                }
            }
            catch (CICSSystemManagerException e) {
                DEBUG.event("getPlatformNameFromPlatdef", (Object)e);
                if (e.getCause() == null || !(e.getCause() instanceof SystemManagerConnectionException)) break block3;
                throw (SystemManagerConnectionException)e.getCause();
            }
        }
        DEBUG.exit("getPlatformNameFromPlatdef", (Object)platformName);
        return platformName;
    }

    private void addUniqueOperation(List<OperationTypesWrapper> operations, ICICSResource resource) {
        DEBUG.enter("addUniqueOperation", (Object)this, operations, (Object)resource);
        String newOperationName = null;
        OperationTypesWrapper newOperation = new OperationTypesWrapper(this.application, resource);
        newOperationName = newOperation.getOperationName();
        if (newOperationName.isEmpty()) {
            return;
        }
        for (OperationTypesWrapper existingOperation : operations) {
            if (!existingOperation.getOperationName().equals(newOperationName)) continue;
            DEBUG.exit("addUniqueOperation", (Object)"existing operation found");
            return;
        }
        operations.add(newOperation);
        DEBUG.exit("addUniqueOperation", (Object)"operation added");
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_operations, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationOperationsNodeDeferredWorkbenchAdapter other = (ApplicationOperationsNodeDeferredWorkbenchAdapter)obj;
        return !(this.application == null ? other.application != null : !EqualityHelper.equals((ICICSObject)this.application, (ICICSObject)other.application));
    }

    public String toString() {
        return CloudMessages.ApplicationOperationsNodeDeferredWorkbenchAdapter_operationsLabel;
    }

    public static enum SupportEntryPointResourceType {
        PROGRAM((ICICSAttribute<String>)ProgramType.PLATFORM_NAME, (ICICSAttribute<String>)ProgramType.APPLICATION_NAME, (ICICSAttribute<Long>)ProgramType.MAJOR_VERSION, (ICICSAttribute<Long>)ProgramType.MINOR_VERSION, (ICICSAttribute<Long>)ProgramType.MICRO_VERSION, (ICICSType<?>)ProgramType.getInstance()),
        URIMAP((ICICSAttribute<String>)URIMapType.PLATFORM_NAME, (ICICSAttribute<String>)URIMapType.APPLICATION_NAME, (ICICSAttribute<Long>)URIMapType.MAJOR_VERSION, (ICICSAttribute<Long>)URIMapType.MINOR_VERSION, (ICICSAttribute<Long>)URIMapType.MICRO_VERSION, (ICICSType<?>)URIMapType.getInstance()),
        LOCTRAN((ICICSAttribute<String>)LocalTransactionType.PLATFORM_NAME, (ICICSAttribute<String>)LocalTransactionType.APPLICATION_NAME, (ICICSAttribute<Long>)LocalTransactionType.MAJOR_VERSION, (ICICSAttribute<Long>)LocalTransactionType.MINOR_VERSION, (ICICSAttribute<Long>)LocalTransactionType.MICRO_VERSION, (ICICSType<?>)LocalTransactionType.getInstance()),
        REMTRAN((ICICSAttribute<String>)RemoteTransactionType.PLATFORM_NAME, (ICICSAttribute<String>)RemoteTransactionType.APPLICATION_NAME, (ICICSAttribute<Long>)RemoteTransactionType.MAJOR_VERSION, (ICICSAttribute<Long>)RemoteTransactionType.MINOR_VERSION, (ICICSAttribute<Long>)RemoteTransactionType.MICRO_VERSION, (ICICSType<?>)RemoteTransactionType.getInstance());

        private ICICSAttribute<String> platformName;
        private ICICSAttribute<String> applicationName;
        private ICICSAttribute<Long> majorVersion;
        private ICICSAttribute<Long> minorVersion;
        private ICICSAttribute<Long> microVersion;
        private ICICSType<?> type;

        private SupportEntryPointResourceType(ICICSAttribute<String> platformName, ICICSAttribute<String> applicationName, ICICSAttribute<Long> majorVersion, ICICSAttribute<Long> minorVersion, ICICSAttribute<Long> microVersion, ICICSType<?> type) {
            this.platformName = platformName;
            this.applicationName = applicationName;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.microVersion = microVersion;
            this.type = type;
        }

        public ICICSAttribute<String> getPlatformName() {
            return this.platformName;
        }

        public ICICSAttribute<String> getApplicationName() {
            return this.applicationName;
        }

        public ICICSAttribute<Long> getMajorVersion() {
            return this.majorVersion;
        }

        public ICICSAttribute<Long> getMinorVersion() {
            return this.minorVersion;
        }

        public ICICSAttribute<Long> getMicroVersion() {
            return this.microVersion;
        }

        public ICICSType<?> getType() {
            return this.type;
        }
    }
}

