/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.RootDeferredWorkbenchAdapter;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class ApplicationsDeferredWorkbenchAdapter
extends RootDeferredWorkbenchAdapter<IApplication, IApplicationDefinition> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(ApplicationsDeferredWorkbenchAdapter.class);

    public ApplicationsDeferredWorkbenchAdapter(CloudInput cloudInput, IContext rootContext) {
        super(cloudInput, rootContext, ApplicationType.getInstance(), ApplicationDefinitionType.getInstance());
    }

    @Override
    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = NLS.bind((String)CloudMessages.ApplicationsNodeName, null);
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = UIPlugin.IMGD_APPLICATION_GROUP;
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    @Override
    protected boolean isDefinitionForObject(IApplicationDefinition applDef, IApplication application) {
        IPrimaryKey applicationDefinitionKey = (IPrimaryKey)((ICoreObject)applDef).getAdapter(IPrimaryKey.class);
        IPrimaryKey applicationKey = (IPrimaryKey)((ICoreObject)application).getAdapter(IPrimaryKey.class);
        IPrimaryKey refApplicationDefinitionKey = ApplicationDefinitionType.getPrimaryKey((IContext)applicationKey.getParentContext(), (String)application.getApplicationDefinitionName(), (String)application.getPlatformDefinitionName(), (Long)application.getMajorVersion(), (Long)application.getMinorVersion(), (Long)application.getMicroVersion());
        return refApplicationDefinitionKey.equals(applicationDefinitionKey);
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_applications, null);
    }

    @Override
    protected int compare(IApplication application1, IApplication application2) {
        if (!application1.getName().equals(application2.getName())) {
            return application1.getName().compareToIgnoreCase(application2.getName());
        }
        if (!application1.getMajorVersion().equals(application2.getMajorVersion())) {
            return application1.getMajorVersion().compareTo(application2.getMajorVersion());
        }
        if (!application1.getMinorVersion().equals(application2.getMinorVersion())) {
            return application1.getMinorVersion().compareTo(application2.getMinorVersion());
        }
        if (!application1.getMicroVersion().equals(application2.getMicroVersion())) {
            return application1.getMicroVersion().compareTo(application2.getMicroVersion());
        }
        return 0;
    }
}

