/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.perspectives;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.perspectives.AdminPerspective;
import java.util.logging.Logger;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewRegistry;

public abstract class AbstractCloudPerspective
implements IPerspectiveFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AbstractCloudPerspective.class.getPackage().getName());
    protected IFolderLayout topologyFolder;
    protected IFolderLayout eventsFolder;

    public void createInitialLayout(IPageLayout layout) {
        Debug.enter((Logger)logger, (String)AbstractCloudPerspective.class.getName(), (String)"createInitialLayout", (Object)layout);
        boolean showEditorArea = false;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IEditorPart activeEditor = activePage.getActiveEditor();
            Debug.event((Logger)logger, (String)AdminPerspective.class.getName(), (String)"createInitialLayout", (Object)activeEditor);
            showEditorArea = true;
        }
        layout.setEditorAreaVisible(showEditorArea);
        String editorArea = layout.getEditorArea();
        this.topologyFolder = layout.createFolder("left", 1, 0.25f, editorArea);
        this.eventsFolder = layout.createFolder("bottom", 4, 0.45f, editorArea);
        this.addView(this.eventsFolder, "org.eclipse.ui.views.ProblemView");
        this.addView(this.eventsFolder, "org.eclipse.ui.views.PropertySheet");
        this.addView(this.eventsFolder, "org.eclipse.search.ui.views.SearchView");
        Debug.exit((Logger)logger, (String)AdminPerspective.class.getName(), (String)"createInitialLayout");
    }

    protected void addView(IFolderLayout folderLayout, String viewId) {
        IViewRegistry viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        if (viewRegistry.find(viewId) != null) {
            folderLayout.addView(viewId);
        }
    }

    protected void addPlaceHolder(IPlaceholderFolderLayout folderLayout, String viewId) {
        IViewRegistry viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        if (viewRegistry.find(viewId) != null) {
            folderLayout.addPlaceholder(viewId);
        }
    }
}

