/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.views.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class EnableDisableDecoratorsAction
extends Action {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(EnableDisableDecoratorsAction.class.getName());
    private static EnableDisableDecoratorsAction thisAction = null;
    private static final String DESCRIBABLE_DECORATOR = "com.ibm.cics.core.ui.decorators.describable";
    private static final String CICSPLEX_DECORATOR = "com.ibm.cics.core.ui.decorators.cicsPlex";
    private static final String WLM_DECORATOR = "com.ibm.cics.core.ui.decorators.wlmAdapter";
    public static String ACTION_STRING = Messages.getString("EnableDisableDecoratorsAction.toggle.decorators", new Object[0]);
    private IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
    boolean decorated;

    public static synchronized EnableDisableDecoratorsAction getInstance() {
        if (thisAction == null) {
            thisAction = new EnableDisableDecoratorsAction();
        }
        return thisAction;
    }

    private EnableDisableDecoratorsAction() {
        super(ACTION_STRING);
    }

    public void run() {
        try {
            boolean decorated = this.areDecorationsOn();
            this.decoratorManager.setEnabled(CICSPLEX_DECORATOR, !decorated);
            this.decoratorManager.setEnabled(DESCRIBABLE_DECORATOR, !decorated);
            this.decoratorManager.setEnabled(WLM_DECORATOR, !decorated);
        }
        catch (CoreException e) {
            logger.log(Level.INFO, "Unable to disable decorator", e);
        }
    }

    public boolean areDecorationsOn() {
        return this.decoratorManager.getEnabled(CICSPLEX_DECORATOR);
    }

    public static interface DecorationEnablementListener {
        public void setDecorationEnablement(boolean var1);
    }
}

