/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.ui.adapters.AdapterUtility;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.sm.comm.IContext;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class TextContextDataLoader {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(TextContextDataLoader.class);
    private final boolean LOADER_DEBUG = Platform.getDebugOption((String)"com.ibm.cics.core.ui/textcontextdataloading") != null;
    private ICPSM cpsm;
    private Map<String, ICICSplex> cicsplexesMap = new HashMap<String, ICICSplex>();
    private Map<String, SoftReference<RegionAndGroups>> regionAndGroupMap = new HashMap<String, SoftReference<RegionAndGroups>>();

    public TextContextDataLoader(ICPSM cpsm) {
        this.cpsm = cpsm;
    }

    public void loadCICSplexes(final CICSplexLoaderListener listener) {
        debug.enter("loadCICSplexes");
        Job loadCICSplexesJob = new Job(Messages.getString("TextContextDataLoader.loadingCicsplexes", new Object[0])){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (TextContextDataLoader.this.LOADER_DEBUG) {
                    debug.enter("loadCICSplexesJob.run");
                }
                Map map = TextContextDataLoader.this.cicsplexesMap;
                synchronized (map) {
                    if (TextContextDataLoader.this.cicsplexesMap.isEmpty()) {
                        TextContextDataLoader.this.cicsplexesMap.putAll(AdapterUtility.getUniqueCICSplexes(TextContextDataLoader.this.cpsm));
                    }
                }
                if (listener != null) {
                    listener.loadedCICSplexes(TextContextDataLoader.this.cicsplexesMap);
                }
                if (TextContextDataLoader.this.LOADER_DEBUG) {
                    debug.exit("loadCICSplexesJob.run", (Object)TextContextDataLoader.this.cicsplexesMap.size());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return TextContextDataLoader.this.equals(family);
            }
        };
        loadCICSplexesJob.schedule();
        debug.exit("loadCICSplexes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRegionsAndGroups(final ICICSplex cicsplex, final RegionAndGroupLoaderListener listener) {
        RegionAndGroups regionAndGroups;
        debug.enter("loadRegionsAndGroups", (Object)cicsplex);
        final HashMap icicsObjectMapOfRegionsAndGroups = new HashMap();
        Map<String, SoftReference<RegionAndGroups>> map = this.regionAndGroupMap;
        synchronized (map) {
            RegionAndGroups alreadyCreatedRegionAndGroupMap;
            SoftReference<RegionAndGroups> potentiallyCachedRegionAndGroupMap = this.regionAndGroupMap.get(cicsplex.getName());
            RegionAndGroups regionAndGroups2 = alreadyCreatedRegionAndGroupMap = potentiallyCachedRegionAndGroupMap != null ? potentiallyCachedRegionAndGroupMap.get() : null;
            if (alreadyCreatedRegionAndGroupMap != null) {
                Job retrieveCacheJob = new Job(Messages.getString("TextContextDataLoader.retrievingCachedRegionsAndGroups", cicsplex.getName())){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        RegionAndGroups regionAndGroups = alreadyCreatedRegionAndGroupMap;
                        synchronized (regionAndGroups) {
                            icicsObjectMapOfRegionsAndGroups.putAll(alreadyCreatedRegionAndGroupMap.regionsMap);
                            icicsObjectMapOfRegionsAndGroups.putAll(alreadyCreatedRegionAndGroupMap.groupsMap);
                        }
                        if (listener != null) {
                            listener.loadedRegionsOrGroups(cicsplex, icicsObjectMapOfRegionsAndGroups);
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return TextContextDataLoader.this.equals(family);
                    }
                };
                retrieveCacheJob.schedule();
                if (this.LOADER_DEBUG) {
                    debug.exit("loadRegionsAndGroups", Arrays.asList("Using cache", cicsplex.getName(), icicsObjectMapOfRegionsAndGroups.size()));
                }
                return;
            }
            regionAndGroups = new RegionAndGroups(cicsplex);
            this.regionAndGroupMap.put(cicsplex.getName(), new SoftReference<RegionAndGroups>(regionAndGroups));
        }
        Job loadRegionsJob = new Job(Messages.getString("TextContextDataLoader.loadingRegions", cicsplex.getName())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (TextContextDataLoader.this.LOADER_DEBUG) {
                    debug.enter("loadRegionsJob.run", (Object)cicsplex);
                }
                RegionAndGroups regionAndGroups2 = regionAndGroups;
                synchronized (regionAndGroups2) {
                    IManagedRegion[] managedRegions = TextContextDataLoader.this.cpsm.getManagedRegions(cicsplex);
                    HashMap<String, IManagedRegion> regionsMap = new HashMap<String, IManagedRegion>();
                    IManagedRegion[] iManagedRegionArray = managedRegions;
                    int n = managedRegions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IManagedRegion region = iManagedRegionArray[n2];
                        regionsMap.put(region.getName(), region);
                        ++n2;
                    }
                    regionAndGroups.regionsMap = regionsMap;
                    icicsObjectMapOfRegionsAndGroups.putAll(regionsMap);
                }
                if (listener != null) {
                    listener.loadedRegionsOrGroups(cicsplex, icicsObjectMapOfRegionsAndGroups);
                }
                if (TextContextDataLoader.this.LOADER_DEBUG) {
                    debug.exit("loadRegionsJob.run", (Object)icicsObjectMapOfRegionsAndGroups.size());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return TextContextDataLoader.this.equals(family);
            }
        };
        loadRegionsJob.schedule();
        Job loadGroupsJob = new Job(Messages.getString("TextContextDataLoader.loadingGroups", cicsplex.getName())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (TextContextDataLoader.this.LOADER_DEBUG) {
                    debug.enter("loadGroupsJob.run", (Object)cicsplex);
                }
                RegionAndGroups regionAndGroups2 = regionAndGroups;
                synchronized (regionAndGroups2) {
                    ICICSRegionGroupDefinition[] groups = new ICICSRegionGroupDefinition[]{};
                    try {
                        groups = (ICICSRegionGroupDefinition[])TextContextDataLoader.this.cpsm.getDefinitions2((ICICSType)CICSRegionGroupDefinitionType.getInstance(), (IContext)new Context(cicsplex.getName()));
                    }
                    catch (CICSSystemManagerException e) {
                        debug.event("loadGroupsJob.run", (Object)e);
                    }
                    HashMap<String, ICICSRegionGroupDefinition> groupsMap = new HashMap<String, ICICSRegionGroupDefinition>();
                    ICICSRegionGroupDefinition[] iCICSRegionGroupDefinitionArray = groups;
                    int n = groups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICICSRegionGroupDefinition group = iCICSRegionGroupDefinitionArray[n2];
                        groupsMap.put(group.getName(), group);
                        ++n2;
                    }
                    regionAndGroups.groupsMap = groupsMap;
                    icicsObjectMapOfRegionsAndGroups.putAll(groupsMap);
                }
                if (listener != null) {
                    listener.loadedRegionsOrGroups(cicsplex, icicsObjectMapOfRegionsAndGroups);
                }
                if (TextContextDataLoader.this.LOADER_DEBUG) {
                    debug.exit("loadGroupsJob.run", (Object)icicsObjectMapOfRegionsAndGroups.size());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return TextContextDataLoader.this.equals(family);
            }
        };
        loadGroupsJob.schedule();
        debug.exit("loadRegionsAndGroups");
    }

    static interface CICSplexLoaderListener {
        public void loadedCICSplexes(Map<String, ICICSplex> var1);
    }

    static interface RegionAndGroupLoaderListener {
        public void loadedRegionsOrGroups(ICICSplex var1, Map<String, ICICSObject> var2);
    }

    class RegionAndGroups {
        ICICSplex cicsplex;
        Map<String, IManagedRegion> regionsMap = new HashMap<String, IManagedRegion>();
        Map<String, ICICSRegionGroupDefinition> groupsMap = new HashMap<String, ICICSRegionGroupDefinition>();

        public RegionAndGroups(ICICSplex cicsplex) {
            this.cicsplex = cicsplex;
        }
    }
}

