/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TransactionGroupEntryReference;
import com.ibm.cics.core.model.TransactionGroupEntryType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.ITransactionGroupEntry;
import com.ibm.cics.model.ITransactionGroupReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTransactionGroupEntry;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableTransactionGroupEntry
extends MutableCPSMDefinition
implements IMutableTransactionGroupEntry {
    private ITransactionGroupEntry delegate;
    private MutableSMRecord record;

    public MutableTransactionGroupEntry(ICPSM cpsm, IContext context, ITransactionGroupEntry cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("DTRINGRP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public ITransactionGroupEntry.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        if (result == null) {
            return this.delegate.getChangeAgent();
        }
        return (ITransactionGroupEntry.ChangeAgentValue)((CICSAttribute)TransactionGroupEntryType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    public String getTransactionGroup() {
        return this.delegate.getTransactionGroup();
    }

    public String getTransactionID() {
        return this.delegate.getTransactionID();
    }

    public ITransactionGroupEntry.PseudoConversationalModeValue getPseudoConversationalMode() {
        String result = this.record.get("PCONV");
        if (result == null) {
            return this.delegate.getPseudoConversationalMode();
        }
        return (ITransactionGroupEntry.PseudoConversationalModeValue)((CICSAttribute)TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE).get(result, this.record.getNormalizers());
    }

    public void setChangeAgent(ITransactionGroupEntry.ChangeAgentValue _changeAgent) {
        if (_changeAgent.equals((Object)this.delegate.getChangeAgent())) {
            this.record.set("CHANGEAGENT", null);
        } else {
            TransactionGroupEntryType.CHANGE_AGENT.validate((Object)_changeAgent);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupEntryType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
            this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
        }
    }

    public void setPseudoConversationalMode(ITransactionGroupEntry.PseudoConversationalModeValue _pseudoConversationalMode) {
        if (_pseudoConversationalMode.equals((Object)this.delegate.getPseudoConversationalMode())) {
            this.record.set("PCONV", null);
        } else {
            TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE.validate((Object)_pseudoConversationalMode);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE).set(_pseudoConversationalMode, this.record.getNormalizers());
            this.record.set("PCONV", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionGroupEntryType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == TransactionGroupEntryType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == TransactionGroupEntryType.TRANSACTION_ID) {
            return (V)this.getTransactionID();
        }
        if (attribute == TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE) {
            return (V)this.getPseudoConversationalMode();
        }
        return super.getAttributeValue(attribute);
    }

    public TransactionGroupEntryType getObjectType() {
        return TransactionGroupEntryType.getInstance();
    }

    @Override
    public TransactionGroupEntryReference getCICSObjectReference() {
        return new TransactionGroupEntryReference(this.getCICSContainer(), this.getTransactionGroup(), this.getTransactionID());
    }

    public ITransactionGroupReference getContainingGroup() {
        return (ITransactionGroupReference)TransactionGroupEntryType.CONTAINING_GROUP.getTo((ICICSObject)this);
    }
}

