/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.sm.comm.ApplicationContext;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IApplicationContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;

public class ScopedContext
implements IScopedContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String context;
    private final String scope;
    private IScopedContext.Type scopeType;

    public ScopedContext(IContext context, String scope) {
        this(context.getContext(), scope);
    }

    public ScopedContext(IContext context, String scope, IScopedContext.Type scopeType) {
        this(context.getContext(), scope, scopeType);
    }

    public ScopedContext(String context, String scope) {
        this(context, scope, IScopedContext.Type.REGION);
    }

    public ScopedContext(String context, String scope, IScopedContext.Type scopeType) {
        this.context = context;
        this.scope = scope;
        this.scopeType = scopeType;
    }

    public ScopedContext(IScopedContext scopedContext) {
        this(scopedContext.getContext(), scopedContext.getScope());
    }

    public String getContext() {
        return this.context;
    }

    public String getScope() {
        return this.scope;
    }

    public IScopedContext.Type getScopeType() {
        return this.scopeType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IScopedContext && this.equals((IScopedContext)obj)) {
            IApplicationContext objAppCtxt = (IApplicationContext)ContextHelper.getContextFrom((IContext)((IScopedContext)obj), IApplicationContext.class);
            IApplicationContext thisAppCtxt = (IApplicationContext)ContextHelper.getContextFrom((IContext)this, IApplicationContext.class);
            return ApplicationContext.isApplicationContextTheSame((IApplicationContext)objAppCtxt, (IApplicationContext)thisAppCtxt);
        }
        return false;
    }

    private static boolean contextsEqual(IScopedContext one, IScopedContext two) {
        return one.getContext() == null ? two.getContext() == null : one.getContext().equals(two.getContext());
    }

    private static boolean scopesEquals(IScopedContext one, IScopedContext two) {
        return one.getScope() == null ? two.getScope() == null : one.getScope().equals(two.getScope());
    }

    public boolean equals(IScopedContext that) {
        return that != null && ScopedContext.contextsEqual(this, that) && ScopedContext.scopesEquals(this, that);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.context + "/" + this.scope + "/" + this.scopeType + "]";
    }
}

