/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.IResourceErrors;
import com.ibm.cics.sm.comm.errors.IGenErrors;
import java.lang.reflect.Field;

public abstract class ErrorCodes
implements IGenErrors {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static IResourceErrorCode findErrorCodeByNumber(String resourceType, int errorCode) {
        IResourceErrors resourceErrors = ErrorCodes.findResourceErrors(resourceType);
        if (resourceErrors != null) {
            return resourceErrors.findErrorCodeByNumber(errorCode);
        }
        return null;
    }

    public static IResourceErrorCode findErrorCodeByMnemonic(String resourceType, String mnemonic) {
        IResourceErrors resourceErrors = ErrorCodes.findResourceErrors(resourceType);
        if (resourceErrors != null) {
            return resourceErrors.findErrorCodeByMnemonic(String.valueOf(resourceType) + "_" + mnemonic);
        }
        return null;
    }

    public static IResourceErrors findResourceErrors(String resourceType) {
        try {
            Field field = ErrorCodes.class.getField(resourceType);
            if (IResourceErrors.class.isAssignableFrom(field.getType())) {
                return (IResourceErrors)field.get(null);
            }
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }
}

