/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ISMUpdateException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class SMUpdateException
extends RuntimeException
implements ISMUpdateException {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;
    public List<ISMUpdateException.IError> fErrors = new ArrayList<ISMUpdateException.IError>();
    protected String resp = null;
    protected int resp2 = -1;
    protected String eibFunctionName;

    public SMUpdateException(URL url, String resourceType, IContext context, int response, int reason, String resp, int resp2) {
        this(url, resourceType, context, response, reason, resp, resp2, null);
    }

    public SMUpdateException(URL url, String resourceType, IContext context, int response, int reason, String resp, int resp2, String eibFunctionName) {
        this(url, resourceType, context, response, reason);
        this.eibFunctionName = eibFunctionName;
        this.resp = resp;
        this.resp2 = resp2;
    }

    public SMUpdateException(URL url, String resourceType, IContext context, int response, int reason) {
        super(url + ": response: " + response + " reason: " + reason);
    }

    public SMUpdateException(String string) {
        super(string);
    }

    public SMUpdateException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public SMUpdateException(Exception e) {
        super(e);
    }

    public Error createError() {
        Error error = new Error();
        this.fErrors.add(error);
        return error;
    }

    @Override
    public List<ISMUpdateException.IError> getErrors() {
        return this.fErrors;
    }

    @Override
    public boolean hasErrors() {
        return !this.fErrors.isEmpty();
    }

    @Override
    public String getRESP() {
        return this.resp;
    }

    @Override
    public int getRESP2() {
        return this.resp2;
    }

    @Override
    public String getEibFunctionName() {
        return this.eibFunctionName;
    }

    public class Error
    implements ISMUpdateException.IError {
        private List<String> attributeNames = new ArrayList<String>();
        private String serverResponse;
        private String resourceType;

        @Override
        public void addAttributeName(String anAttributeName, String resourceType) {
            this.resourceType = resourceType;
            this.attributeNames.add(anAttributeName);
        }

        @Override
        public List<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public void setServerResponse(String aString) {
            this.serverResponse = aString;
        }

        @Override
        public String getServerResponse() {
            return this.serverResponse;
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String aResourceType) {
            this.resourceType = aResourceType;
        }
    }
}

