/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionParametersExporter;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.FileConnectionXMLSerializer;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.views.ConnectionsContentProvider;
import com.ibm.cics.core.connections.internal.views.ConnectionsLabelProvider;
import com.ibm.cics.core.connections.internal.views.Messages;
import com.ibm.cics.core.connections.internal.views.ShowProvidersAction;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ExportConnectionsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String LAST_CONNECTIONS_FILE = "LAST_CONNECTIONS_FILE";
    private Text locationText;
    private static final Debug DEBUG = new Debug(ExportConnectionsDialog.class);
    private final ConnectionsContentProvider connectionsContentProvider = new ConnectionsContentProvider(new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry()), ConnectionProviderRegistry.getDefault()){

        @Override
        protected Object[] filteredDescriptors(Object[] array) {
            ArrayList<IConnectionDescriptor> result = new ArrayList<IConnectionDescriptor>(array.length);
            int i = 0;
            while (i < array.length) {
                IConnectionDescriptor connectionDescriptor = (IConnectionDescriptor)array[i];
                if (!connectionDescriptor.getId().equals("com.ibm.ftt.cics.rse.RSE.connection")) {
                    result.add(connectionDescriptor);
                }
                ++i;
            }
            return result.toArray();
        }
    };
    private ContainerCheckedTreeViewer treeViewer;
    private IConnectionManager connectionManager;

    ExportConnectionsDialog(Shell shell, IConnectionManager connectionManager) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.connectionManager = connectionManager;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ExportConnectionsDialog_text);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ExportConnectionsDialog_title);
        this.setMessage(Messages.ExportConnectionsDialog_msg);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(childArea);
        this.createToolBar(childArea);
        this.createConnectionsTree(childArea);
        Composite locationComposite = new Composite(childArea, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(locationComposite);
        GridDataFactory.fillDefaults().applyTo((Control)locationComposite);
        Label l = new Label(locationComposite, 0);
        l.setText(Messages.AddProviderDialog_Location_lbl);
        data = new GridData(4, 0x1000000, false, false);
        l.setLayoutData((Object)data);
        this.locationText = new Text(locationComposite, 2048);
        TextInput.setAccessibleLabel((Text)this.locationText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        this.locationText.setLayoutData((Object)data);
        Button browseButton = new Button(locationComposite, 8);
        browseButton.setText(Messages.AddProviderDialog_Browse_btn);
        data = new GridData(4, 0x1000000, false, false);
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ExportConnectionsDialog.this.getShell(), 8192);
                fd.setOverwrite(true);
                fd.setFilterExtensions(new String[]{"*.pref"});
                String file = fd.open();
                if (file != null) {
                    ExportConnectionsDialog.this.locationText.setText(file);
                }
            }
        });
        String lastFile = InternalConnectionsPlugin.getDefault().getPreferenceStore().getString(LAST_CONNECTIONS_FILE);
        if (StringUtil.hasContent((String)lastFile)) {
            this.locationText.setText(lastFile);
        } else {
            Location instanceLocation = Platform.getInstanceLocation();
            URL workspaceURL = instanceLocation.getURL();
            String absolutePath = workspaceURL.getPath();
            String fileNamePlaceholder = "my_connections";
            File exportLocation = new File(String.valueOf(absolutePath) + fileNamePlaceholder + ".pref");
            this.locationText.setText(exportLocation.getAbsolutePath());
        }
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportConnectionsDialog.this.getButton(0).setEnabled(StringUtil.hasContent((String)ExportConnectionsDialog.this.locationText.getText()));
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connection_export_dialog");
        return c;
    }

    protected void createToolBar(Composite parent) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        this.fillToolBar(toolBarManager);
        if (toolBarManager.getSize() > 0) {
            ToolBar toolBar = toolBarManager.createControl(parent);
            GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
            toolBarManager.update(true);
        }
    }

    private void fillToolBar(ToolBarManager toolBarManager) {
        Action expandAllAction = new Action(Messages.ConnectionsViewPart_Expand_All, 1){

            public void run() {
                ExportConnectionsDialog.this.treeViewer.expandAll();
            }
        };
        expandAllAction.setImageDescriptor(Activator.IMGD_EXPAND_ALL);
        toolBarManager.add((IAction)expandAllAction);
        Action collapseAllAction = new Action(Messages.ConnectionsViewPart_Collapse_All, 1){

            public void run() {
                ExportConnectionsDialog.this.treeViewer.collapseAll();
            }
        };
        collapseAllAction.setImageDescriptor(Activator.IMGD_COLLAPSE_ALL);
        toolBarManager.add((IAction)collapseAllAction);
        toolBarManager.add((IAction)new ShowProvidersAction(this.connectionsContentProvider){

            @Override
            public void run() {
                Object[] checkedElements = ExportConnectionsDialog.this.treeViewer.getCheckedElements();
                List<Object> filteredList = CollectionUtils.filter(Arrays.asList(checkedElements), new Function<Object, Boolean>(){

                    @Override
                    public Boolean evaluate(Object v) {
                        return v instanceof ConnectionProfile;
                    }
                });
                super.run();
                ExportConnectionsDialog.this.treeViewer.setCheckedElements(filteredList.toArray());
                ExportConnectionsDialog.this.treeViewer.expandToLevel(2);
            }
        });
    }

    private void createConnectionsTree(Composite parent) {
        this.treeViewer = new ContainerCheckedTreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)this.connectionsContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionsLabelProvider());
        this.treeViewer.setInput((Object)this.connectionManager);
        this.treeViewer.expandToLevel(2);
        this.treeViewer.setCheckedElements(this.connectionsContentProvider.getElements(this.connectionManager));
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (ExportConnectionsDialog.this.treeViewer.getCheckedElements().length == 0) {
                    ExportConnectionsDialog.this.getButton(0).setEnabled(false);
                } else if (!ExportConnectionsDialog.this.getButton(0).isEnabled()) {
                    ExportConnectionsDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.treeViewer.getTree());
        Composite buttonComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText(Messages.ExportConnectionsDialog_SelectAll);
        GridDataFactory.fillDefaults().applyTo((Control)selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportConnectionsDialog.this.treeViewer.setCheckedElements(ExportConnectionsDialog.this.connectionsContentProvider.getElements(ExportConnectionsDialog.this.connectionManager));
                ExportConnectionsDialog.this.getButton(0).setEnabled(true);
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText(Messages.ExportConnectionsDialog_DeselectAll);
        GridDataFactory.fillDefaults().applyTo((Control)deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportConnectionsDialog.this.treeViewer.setCheckedElements(new Object[0]);
                ExportConnectionsDialog.this.getButton(0).setEnabled(false);
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            boolean confirmed;
            this.setErrorMessage(null);
            String fileName = this.locationText.getText();
            if (!fileName.endsWith(".pref")) {
                fileName = fileName.concat(".pref");
            }
            if (new File(fileName).exists() && !(confirmed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ExportConnectionsDialog_FileExistsDialog_title, (String)Messages.ExportConnectionsDialog_FileExistDialog_message))) {
                return;
            }
            this.exportPreferencesTo(fileName);
            if (this.getErrorMessage() == null) {
                super.buttonPressed(buttonId);
                InternalConnectionsPlugin.getDefault().getPreferenceStore().setValue(LAST_CONNECTIONS_FILE, fileName);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void exportPreferencesTo(String filePath) {
        Object[] checkedElements = this.treeViewer.getCheckedElements();
        ArrayList<ConnectionProfile> connectionProfiles = new ArrayList<ConnectionProfile>();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ConnectionProfile) {
                connectionProfiles.add((ConnectionProfile)object);
            }
            ++n2;
        }
        List<ConnectionParameters> parametersList = CollectionUtils.transform(connectionProfiles, new Function<ConnectionProfile, ConnectionParameters>(){

            @Override
            public ConnectionParameters evaluate(ConnectionProfile v) {
                return v.getConnectionParameters();
            }
        });
        ConnectionParametersExporter exporter = new ConnectionParametersExporter(parametersList, ConnectionRegistry.getConnectionRegistry());
        List<ConnectionParameters> connections = exporter.getConnections();
        try {
            new FileConnectionXMLSerializer((IPath)new Path(filePath)).save(connections);
        }
        catch (IOException e) {
            this.setErrorMessage(String.valueOf(Messages.Connection_export_failed_msg) + " " + e.getLocalizedMessage());
            DEBUG.event("exportPreferencesTo", (Object)filePath, (Object)e);
        }
    }
}

