/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDDefinition;
import com.ibm.cics.model.query.CICSDefinitionsQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQueryResult;
import com.ibm.cics.model.query.CSDDefinitionsQuery;
import com.ibm.cics.model.query.CSDQuery;
import com.ibm.cics.model.query.CSDQueryResult;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSDefinitionsQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CSDDefinitionsQueryImpl;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

class CSDQueryImpl
extends Node<CSDQueryResult>
implements CSDQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String GRAPH_QL_TYPE_NAME = "CSDType";
    private final Map<ICICSType<?>, AggregationMeta> aggregationMeta;
    private NodeParser<JsonObject, Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult>> cicsDefinitions;
    private NodeParser<JsonObject, Map<ICICSType<? extends ICSDDefinition>, CICSObjectRecordsQueryResult>> csdDefinitions;
    private CICSDefinitionsQueryImpl cicsDefinitionQueryImpl;

    public CSDQueryImpl(Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        super(GRAPH_QL_TYPE_NAME);
        this.aggregationMeta = aggregationMeta;
        this.cicsDefinitionQueryImpl = new CICSDefinitionsQueryImpl(aggregationMeta);
    }

    public CSDQuery fragment(FragmentReference<CSDQuery> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    public CSDQuery cicsDefinitions(Consumer<CICSDefinitionsQuery> query) {
        this.cicsDefinitions = this.objectField("cicsDefinitions", this.cicsDefinitionQueryImpl, query).nonNull();
        return this;
    }

    public CSDQuery csdDefinitions(Consumer<CSDDefinitionsQuery> query) {
        this.csdDefinitions = this.objectField("csdDefinitions", new CSDDefinitionsQueryImpl(this.aggregationMeta), query).nonNull();
        return this;
    }

    @Override
    public CSDQueryResult parseObject(JsonObject o) throws NodeParseException {
        return new CSDResultImpl(CSDQueryImpl.parseMap(this.cicsDefinitions, o), CSDQueryImpl.parseMap(this.csdDefinitions, o));
    }

    private static class CSDResultImpl
    implements CSDQueryResult {
        private final Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult> cicsDefinitions;
        private final Map<ICICSType<? extends ICSDDefinition>, CICSObjectRecordsQueryResult> csdDefinitions;

        public CSDResultImpl(Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult> cicsDefinitions, Map<ICICSType<? extends ICSDDefinition>, CICSObjectRecordsQueryResult> csdDefinitions) {
            this.cicsDefinitions = Collections.unmodifiableMap(cicsDefinitions);
            this.csdDefinitions = Collections.unmodifiableMap(csdDefinitions);
        }

        public Map<ICICSType<? extends ICICSDefinition>, CICSObjectRecordsQueryResult> getCICSDefinitions() {
            return this.cicsDefinitions;
        }

        public Map<ICICSType<? extends ICSDDefinition>, CICSObjectRecordsQueryResult> getCSDDefinitions() {
            return this.csdDefinitions;
        }
    }
}

