/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourcesModel;
import com.ibm.cics.model.CICSDateAttributeAggregation;
import com.ibm.cics.model.CICSEnumAttributeAggregation;
import com.ibm.cics.model.CICSNumericAttributeAggregation;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.CICSStringAttributeAggregation;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.sm.comm.IContext;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class AggregatedResourcesModel
extends ResourcesModel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AggregatedResourcesModel.class);
    private CICSObjectAggregateRecord aggregateRecord;
    private IContext filteredContext;
    private boolean isExpandable = true;

    public AggregatedResourcesModel(ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context, List<ICICSAttribute<?>> groupedAttributes, CICSObjectAggregateRecord aggregateRecord) {
        super(cpsm, type, context);
        this.filteredContext = this.createFilteredContext(context, groupedAttributes, aggregateRecord);
        this.aggregateRecord = aggregateRecord;
    }

    private FilteredContext createFilteredContext(IContext context, List<ICICSAttribute<?>> attributes, CICSObjectAggregateRecord aggregateRecord) {
        FilteredContext filteredContext = new FilteredContext(context);
        try {
            for (ICICSAttribute<?> cicsAttribute : attributes) {
                String value;
                if (cicsAttribute.getType() == String.class) {
                    ICICSAttribute<?> stringAttribute = cicsAttribute;
                    CICSStringAttributeAggregation stringAggregation = aggregateRecord.getStringAggregation(stringAttribute);
                    value = (String)stringAggregation.getValue().orElseThrow(() -> new IllegalCICSAttributeException("All unsupported", stringAttribute, (Object)stringAggregation.getUnsupportedCount()));
                    filteredContext.setAttributeValue(stringAttribute, value);
                    continue;
                }
                if (cicsAttribute.getType() == Long.class) {
                    long max;
                    long min;
                    ICICSAttribute<?> longAttribute = cicsAttribute;
                    CICSNumericAttributeAggregation numericAggregation = aggregateRecord.getNumericAggregation(longAttribute);
                    Optional maxO = numericAggregation.getMax();
                    Optional minO = numericAggregation.getMin();
                    if (maxO.isPresent() && minO.isPresent() && (min = ((Long)minO.get()).longValue()) == (max = ((Long)maxO.get()).longValue())) {
                        filteredContext.setAttributeValue(longAttribute, max);
                        continue;
                    }
                    throw new IllegalArgumentException("Can't filter on a range, special values, or not supported values: " + numericAggregation);
                }
                if (cicsAttribute.getType() == Date.class) {
                    String max;
                    String min;
                    ICICSAttribute<?> dateAttribute = cicsAttribute;
                    CICSDateAttributeAggregation dateAggregation = aggregateRecord.getDateAggregation(dateAttribute);
                    Optional minO = dateAggregation.getMin();
                    Optional maxO = dateAggregation.getMax();
                    if (minO.isPresent() && maxO.isPresent() && (min = (String)minO.get()).equals(max = (String)maxO.get())) {
                        filteredContext.setAttributeValue(dateAttribute, (Date)dateAttribute.externalToInternal(max));
                        continue;
                    }
                    throw new IllegalArgumentException("Can't filter on a range, special values, or not supported values: " + dateAggregation);
                }
                if (ICICSEnum.class.isAssignableFrom(cicsAttribute.getType())) {
                    ICICSAttribute<?> enumAttribute = cicsAttribute;
                    CICSEnumAttributeAggregation enumAggregation = aggregateRecord.getEnumerationAggregation(enumAttribute);
                    if (enumAggregation.getValueCounts().size() == 1) {
                        value = ((CICSEnumAttributeAggregation.ValueCountPair)enumAggregation.getValueCounts().get(0)).getValue();
                        ICICSEnum enumValue = (ICICSEnum)enumAttribute.externalToInternal(value);
                        filteredContext.setAttributeValue(enumAttribute, enumValue);
                        continue;
                    }
                    throw new IllegalCICSAttributeException("", enumAttribute, (Object)enumAggregation);
                }
                throw new IllegalArgumentException("Unexpected attribute type " + cicsAttribute.getType());
            }
        }
        catch (IllegalArgumentException e) {
            debug.info("createFilteredContext", (Object)e.getLocalizedMessage());
            filteredContext = null;
            this.isExpandable = false;
        }
        return filteredContext;
    }

    public CICSObjectAggregateRecord getAggregateRecord() {
        return this.aggregateRecord;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public IContext getContext() {
        return this.filteredContext == null ? super.getContext() : this.filteredContext;
    }

    @Override
    public String toString() {
        return "AggregatedResourcesModel@" + Integer.toHexString(this.hashCode()) + "[" + this.getResourceName() + ", " + this.getContext() + ", " + this.aggregateRecord + "]";
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }
}

