/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.CICSObjectReference;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.ICICSDefinitionReference;
import com.ibm.cics.model.ICICSType;

public class CICSDefinitionReference<T extends ICICSDefinition>
extends CICSObjectReference<T>
implements ICICSDefinitionReference<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICICSDefinitionContainer container;

    public CICSDefinitionReference(ICICSType<T> type, ICICSDefinitionContainer container, String name, Long version, String csdGroup) {
        super(type, AttributeValue.av(AbstractCICSDefinitionType.NAME, (Object)name), AttributeValue.av(AbstractCICSDefinitionType.VERSION, (Object)version), AttributeValue.av(AbstractCICSDefinitionType.CSDGROUP, (Object)csdGroup));
        this.container = container;
    }

    public CICSDefinitionReference(ICICSType<T> type, ICICSDefinitionContainer container, T cicsObject) {
        super(type, AttributeValue.av(AbstractCICSDefinitionType.NAME, (Object)((String)cicsObject.getAttributeValue(AbstractCICSDefinitionType.NAME))), AttributeValue.av(AbstractCICSDefinitionType.VERSION, (Object)((Long)cicsObject.getAttributeValue(AbstractCICSDefinitionType.VERSION))), AttributeValue.av(AbstractCICSDefinitionType.CSDGROUP, (Object)((String)cicsObject.getAttributeValue(AbstractCICSDefinitionType.CSDGROUP))));
        this.container = container;
    }

    public CICSDefinitionReference(ICICSType<T> type, ICICSDefinitionContainer container, String name, Long version) {
        this(type, container, name, version, "");
    }

    public CICSDefinitionReference(ICICSType<T> type, ICICSDefinitionContainer container, String name, String csdGroup) {
        this(type, container, name, 0L, csdGroup);
    }

    public static <E extends ICICSDefinition> CICSDefinitionReference<E> create(ICICSType<E> type, ICICSDefinitionContainer container, String name, Long version) {
        return new CICSDefinitionReference<E>(type, container, name, version);
    }

    public static <E extends ICICSDefinition> CICSDefinitionReference<E> create(ICICSType<E> type, ICICSDefinitionContainer container, String name, String csdGroup) {
        return new CICSDefinitionReference<E>(type, container, name, csdGroup);
    }

    public ICICSDefinitionContainer getCICSContainer() {
        return this.container;
    }

    public String getName() {
        return this.getAttributeValue(AbstractCICSDefinitionType.NAME);
    }

    public Long getVersion() {
        return this.getAttributeValue(AbstractCICSDefinitionType.VERSION);
    }

    public String getCSDGroup() {
        return this.getAttributeValue(AbstractCICSDefinitionType.CSDGROUP);
    }
}

