/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.internal.BASRepositoryImpl;
import com.ibm.cics.core.model.internal.CICSResourceContainer;
import com.ibm.cics.core.model.internal.CPSMDefinitionContainer;
import com.ibm.cics.core.model.internal.CSDDefinitionContainer;
import com.ibm.cics.core.model.internal.CSDRepositoryImpl;
import com.ibm.cics.core.model.internal.GenericContainer;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.ICSDDefinitionContainer;
import com.ibm.cics.model.topology.BASRepository;
import com.ibm.cics.model.topology.CICSplex;
import com.ibm.cics.model.topology.CSDRepository;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ScopedContext;

public class ContainerUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static <E extends ICICSObject> ICICSObjectContainer<E> toOnline(ICICSObjectContainer<E> container, ICPSM cpsm) {
        if (container instanceof GenericContainer) {
            return container;
        }
        if (container instanceof BASRepository) {
            CICSplex cicsplex = ((BASRepository)container).getCICSplex();
            return new BASRepositoryImpl(cpsm, (IContext)new Context(cicsplex.getName()));
        }
        if (container instanceof CSDRepository) {
            ICICSResourceContainer cicsRegion = ((CSDRepository)container).getRegion();
            ScopedContext scopedContext = new ScopedContext(cicsRegion.getCICSplex().getName(), cicsRegion.getName());
            return new CSDRepositoryImpl(cpsm, (IContext)scopedContext);
        }
        if (container instanceof ICICSResourceContainer) {
            ICICSResourceContainer existingContainer = (ICICSResourceContainer)container;
            ScopedContext context = new ScopedContext((IContext)new Context(existingContainer.getCICSplex().getName()), existingContainer.getName());
            return new CICSResourceContainer(cpsm, (IContext)context);
        }
        if (container instanceof ICPSMDefinitionContainer) {
            ICPSMDefinitionContainer existingContainer = (ICPSMDefinitionContainer)container;
            CICSplex cicsplex = existingContainer.getCICSplex();
            return new CPSMDefinitionContainer(cpsm, (IContext)new Context(cicsplex.getName()));
        }
        if (container instanceof ICSDDefinitionContainer) {
            ICICSResourceContainer cicsRegion = ((ICSDDefinitionContainer)container).getCICSRegion();
            return new CSDDefinitionContainer(cpsm, (IContext)new ScopedContext(cicsRegion.getCICSplex().getName(), cicsRegion.getName()));
        }
        throw new UnsupportedOperationException("Container conversion not supported for " + container.getClass());
    }

    public static boolean isOffline(ICICSObject object) {
        return ((ICoreObject)object).getCPSM() == null;
    }
}

