/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.AbstractResourcesModel;
import com.ibm.cics.core.model.AggregatedModelSortProperties;
import com.ibm.cics.core.model.AggregatedResourcesModel;
import com.ibm.cics.core.model.AggregatedResourcesModelComparator;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CPSM;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IModelListener;
import com.ibm.cics.core.model.ModelStatus;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinitionType;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResourceType;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMDefinitionType;
import com.ibm.cics.model.ICPSMManagerType;
import com.ibm.cics.model.ICSDDefinitionType;
import com.ibm.cics.model.query.QueryBuilder;
import com.ibm.cics.sm.comm.ComplexFilteredContext;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IChildContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.WarningCountExceededException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourcesModel
extends AbstractResourcesModel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICPSM cpsm;
    private final IContext context;
    private final ICICSType<?> type;
    private boolean disposed = false;
    private ICICSObject[] resources;
    private String activeStub;
    private ModelStatus status;
    private boolean needsReactivation;
    private int defaultWarningCount = -1;
    private boolean overrideable;
    private List<ICICSAttribute<?>> groupByAttributes;
    private boolean isSummarized;
    private List<AggregatedResourcesModel> summarizedResources;
    private AggregatedModelSortProperties sortProperties;
    private static Debug debug = new Debug(ResourcesModel.class);
    private List<ICICSAttribute<?>> visibleColumns;

    protected ResourcesModel(ICPSM cpsm, IContext context, IModelListener listener, ICICSType<?> type, List<ICICSAttribute<?>> groupBy, boolean isSummarized, AggregatedModelSortProperties sortProperties, List<ICICSAttribute<?>> visibleColumns) {
        debug.enter("<init>", new Object[]{cpsm, context, listener, type, groupBy, isSummarized, sortProperties});
        this.groupByAttributes = groupBy;
        this.isSummarized = isSummarized;
        this.sortProperties = sortProperties;
        this.type = type;
        this.cpsm = cpsm;
        this.context = context;
        this.status = ModelStatus.OK;
        List<Object> list = this.visibleColumns = visibleColumns == null ? Arrays.asList(type.attributes()) : visibleColumns;
        if (listener != null) {
            this.addListener(listener);
        }
        debug.exit("<init>", (Object)this);
    }

    protected ResourcesModel(ICPSM cpsm, String context, String scope, IModelListener listener, ICICSType<? extends ICICSObject> resourceType) {
        this(cpsm, (IContext)new ScopedContext(context, scope), listener, resourceType, null, false, null, null);
    }

    public ResourcesModel(ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context) {
        this(cpsm, context, null, type, null, false, null, null);
    }

    public ResourcesModel(ICPSM cpsm, ICICSType<? extends ICICSObject> type, IContext context, List<ICICSAttribute<?>> groupBy, boolean isSummarized, AggregatedModelSortProperties sortProperties, List<ICICSAttribute<?>> visibleColumns) {
        this(cpsm, context, null, type, groupBy, isSummarized, sortProperties, visibleColumns);
    }

    public ResourcesModel(ResourcesModel resourcesModel, IContext context) {
        this(resourcesModel.cpsm, context, null, resourcesModel.type, null, false, null, null);
    }

    public ICPSM getCPSM() {
        return this.cpsm;
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public ModelStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        debug.enter("activate", (Object)this, (Object)this.cpsm, (Object)this.activeStub);
        int sizeLength = -1;
        CICSSystemManagerException exception = null;
        ResourcesModel resourcesModel = this;
        synchronized (resourcesModel) {
            if (!this.disposed && this.resources == null) {
                try {
                    SMConnectionResponse response = this.cpsm.get(this.type.getResourceTableName(), this.context);
                    debug.event("activate", (Object)response);
                    this.status = response.getReason().contentEquals("MAXRECORDS") ? ModelStatus.TRUNCATED : (!response.getStatus().equals("OK") ? ModelStatus.UNSUPPORTED : ModelStatus.OK);
                    this.resources = this.createResources(response.getRecordTotal());
                    this.activeStub = response.getStub();
                    sizeLength = this.resources.length;
                    this.defaultWarningCount = -1;
                    this.overrideable = false;
                    this.needsReactivation = false;
                }
                catch (CICSSystemManagerException ex) {
                    if (ex.getCause() instanceof WarningCountExceededException) {
                        WarningCountExceededException wcee = (WarningCountExceededException)ex.getCause();
                        this.status = ModelStatus.LIMITED;
                        this.resources = this.createResources(wcee.getCurrentRecordCount());
                        sizeLength = this.resources.length;
                        this.defaultWarningCount = wcee.getDefaultWarningCount();
                        this.overrideable = wcee.isOverrideable();
                    } else {
                        exception = ex;
                    }
                    debug.warning("activate", (Object)this, (Object)ex);
                }
            }
        }
        if (exception != null) {
            this.fireExceptionOccured((Exception)((Object)exception));
        } else if (sizeLength > -1) {
            this.fireSizeChanged(sizeLength, -1);
        }
        debug.exit("activate", (Object)this.activeStub);
    }

    @Override
    public int getDefaultWarningCount() {
        return this.defaultWarningCount;
    }

    @Override
    public boolean isOverrideable() {
        return this.overrideable;
    }

    @Override
    public synchronized boolean isActivated() {
        return this.activeStub != null;
    }

    protected ICICSObject[] createResources(int length) {
        ICICSObject[] resources = (ICICSObject[])Array.newInstance(this.type.getImplementationType(), length);
        return resources;
    }

    @Override
    public void reactivate() {
        this.deactivate();
        this.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeFetch(int index, int count) {
        String stub;
        boolean shouldReactivate;
        int start = -1;
        int finish = -1;
        ResourcesModel resourcesModel = this;
        synchronized (resourcesModel) {
            if (this.disposed) {
                return;
            }
            shouldReactivate = this.needsReactivation;
        }
        if (shouldReactivate) {
            this.reactivate();
        }
        resourcesModel = this;
        synchronized (resourcesModel) {
            int i;
            if (!this.isActivated()) {
                return;
            }
            stub = this.activeStub;
            if (!this.itemExists(index + count - 1)) {
                i = index;
                while ((i < index + count || -1 != start && i < start + count) && i < this.resources.length) {
                    if (this.resources[i] == null) {
                        if (-1 == start) {
                            start = i;
                        }
                        finish = i;
                    }
                    ++i;
                }
            } else {
                i = index + count - 1;
                while ((i >= index || -1 != finish && i > finish - count) && i >= 0) {
                    if (this.resources[i] == null) {
                        if (-1 == finish) {
                            finish = i;
                        }
                        start = i;
                    }
                    --i;
                }
            }
            if (start == -1 || finish < start) {
                return;
            }
        }
        debug.event("maybeFetch", (Object)this, (Object)start, (Object)finish);
        try {
            SMConnectionResponse l = this.cpsm.fetch(stub, start + 1, finish - start + 1);
            this.activeStub = l.getStub();
            ResourcesModel resourcesModel2 = this;
            synchronized (resourcesModel2) {
                if (!this.disposed && this.isActivated()) {
                    debug.event("getData", (Object)l);
                    int lastIndex = -1;
                    int i = 0;
                    while (i < l.getRecordCount()) {
                        SMConnectionRecord record = l.getRecord(i);
                        ICICSObject resource = this.createResource(record);
                        if (i == 0) {
                            debug.event("maybeFetch", (Object)(start + i), (Object)record, (Object)resource);
                        }
                        this.resources[start + i] = resource;
                        lastIndex = start + l.getRecordCount() - 1;
                        ++i;
                    }
                    if (lastIndex > -1) {
                        this.fireContentsChanged(start, lastIndex);
                    }
                }
            }
        }
        catch (CICSSystemManagerException ex) {
            debug.warning("getData", (Object)this, (Object)ex);
            ResourcesModel resourcesModel3 = this;
            synchronized (resourcesModel3) {
                if (!this.disposed) {
                    this.fireExceptionOccured((Exception)ex.getCause());
                    this.activeStub = null;
                }
            }
        }
        debug.exit("maybeFetch", (Object)this.activeStub);
    }

    @Override
    public boolean itemExists(int index) {
        return this.resources != null && index >= 0 && index < this.resources.length && this.resources[index] != null;
    }

    protected ICICSObject createResource(SMConnectionRecord record) {
        return record == null ? null : (ICICSObject)CICSCore.create(this.cpsm, record, this.type);
    }

    @Override
    public synchronized int size() {
        if (this.isSummarized()) {
            if (this.summarizedResources == null) {
                return 0;
            }
            return this.summarizedResources.size();
        }
        if (this.resources == null) {
            return 0;
        }
        return this.resources.length;
    }

    @Override
    public synchronized ICICSObject get(int index) {
        if (this.resources == null) {
            return null;
        }
        return this.resources[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        String stubToDiscard = null;
        ResourcesModel resourcesModel = this;
        synchronized (resourcesModel) {
            if (this.activeStub != null) {
                stubToDiscard = this.activeStub;
                debug.event("deactivate", (Object)this);
                this.activeStub = null;
            }
            this.resources = null;
        }
        if (stubToDiscard != null) {
            this.cpsm.discard(stubToDiscard);
        }
    }

    @Override
    public synchronized void dispose() {
        if (!this.disposed) {
            debug.event("dispose", (Object)this);
            this.deactivate();
            ((CPSM)this.cpsm).disposeModel(this);
            this.setDisposed();
        }
    }

    protected synchronized void setDisposed() {
        debug.event("setDisposed", (Object)this);
        this.resources = null;
        this.disposed = true;
    }

    public ICICSObject find(String name) {
        ICICSObject found = null;
        if (!this.isActivated()) {
            this.activate();
        }
        this.maybeFetch(0, this.size());
        int i = 0;
        while (found == null && i < this.size()) {
            ICICSObject object = this.get(i);
            if (object != null && object.getName().equals(name)) {
                found = object;
            }
            ++i;
        }
        return found;
    }

    @Override
    public String getResourceName() {
        return this.type.getResourceTableName();
    }

    public String toString() {
        return "ResourcesModel@" + Integer.toHexString(this.hashCode()) + "[" + this.type.getResourceTableName() + ", " + this.context + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(ICICSObject cicsObject) {
        debug.enter("added", (Object)this, (Object)cicsObject);
        boolean fireInvalid = false;
        ResourcesModel resourcesModel = this;
        synchronized (resourcesModel) {
            if (this.resources != null) {
                this.resources = this.createResources(this.resources.length + 1);
                this.needsReactivation = true;
                fireInvalid = true;
            }
        }
        if (fireInvalid) {
            this.fireContentsInvalid();
        }
        debug.exit("added");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(ICICSObject cicsObject) {
        debug.enter("updated", (Object)this, (Object)cicsObject);
        int changedResource = -1;
        ResourcesModel resourcesModel = this;
        synchronized (resourcesModel) {
            if (this.resources != null) {
                IPrimaryKey updatedKey = (IPrimaryKey)((ICoreObject)cicsObject).getAdapter(IPrimaryKey.class);
                int i = 0;
                while (i < this.resources.length) {
                    IPrimaryKey key;
                    ICICSObject resource = this.resources[i];
                    if (resource != null && (key = (IPrimaryKey)((ICoreObject)resource).getAdapter(IPrimaryKey.class)).equals(updatedKey)) {
                        debug.event("updated", new Object[]{String.valueOf(i), key, resource, cicsObject});
                        this.resources[i] = cicsObject;
                        changedResource = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (changedResource > -1) {
            this.fireContentsChanged(changedResource, changedResource);
        }
        debug.exit("updated");
    }

    public void removed(ICICSObject cicsObject) {
        IPrimaryKey updatedKey = (IPrimaryKey)((ICoreObject)cicsObject).getAdapter(IPrimaryKey.class);
        this.removed(updatedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(IPrimaryKey updatedKey) {
        debug.enter("removed", (Object)this, (Object)updatedKey);
        boolean found = false;
        ResourcesModel resourcesModel = this;
        synchronized (resourcesModel) {
            if (this.resources == null) {
                return;
            }
            int i = 0;
            while (i < this.resources.length && !found) {
                IPrimaryKey key;
                ICICSObject resource = this.resources[i];
                if (resource != null && (key = (IPrimaryKey)((ICoreObject)resource).getAdapter(IPrimaryKey.class)).equals(updatedKey)) {
                    debug.event("removed", new Object[]{String.valueOf(i), key, resource, updatedKey});
                    int newLength = this.resources.length - 1;
                    if (newLength > 0) {
                        this.fireContentsRemoved(resource);
                    }
                    ICICSObject[] newResources = this.createResources(newLength);
                    System.arraycopy(this.resources, 0, newResources, 0, i);
                    System.arraycopy(this.resources, i + 1, newResources, i, newLength - i);
                    this.resources = newResources;
                    found = true;
                }
                ++i;
            }
        }
        if (found) {
            debug.event("removed", (Object)true);
            this.fireSizeChanged(this.resources.length, -1);
        } else if (this.resources.length > 0) {
            debug.event("removed", (Object)false);
            this.resources = this.createResources(this.resources.length - 1);
            this.needsReactivation = true;
            this.fireContentsInvalid();
        }
        debug.exit("removed");
    }

    @Override
    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isSummarized() {
        return this.isSummarized;
    }

    @Override
    public void group() {
        FilterExpression filter = this.getFilterExpression();
        try {
            Stream<AggregatedResourcesModel> s = ((List)this.createAggregationQuery(this.visibleColumns, filter).run(this.cpsm.getTopology())).stream().map(aggregateRecord -> new AggregatedResourcesModel(this.cpsm, (ICICSType<? extends ICICSObject>)this.type, this.context, this.groupByAttributes, (CICSObjectAggregateRecord)aggregateRecord));
            if (this.sortProperties != null) {
                debug.event("group", "sort on: " + this.sortProperties.getAttribute());
                s = s.sorted(new AggregatedResourcesModelComparator(this.sortProperties));
            }
            this.summarizedResources = s.collect(Collectors.toList());
            this.fireSizeChanged(this.summarizedResources.size(), -1);
        }
        catch (CICSActionException e) {
            this.fireExceptionOccured((Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends ICICSObject> QueryBuilder<Void, List<CICSObjectAggregateRecord>> createAggregationQuery(List<ICICSAttribute<?>> attributes, FilterExpression filter) {
        IScopedContext.Type scopeType;
        String scope;
        if (this.cpsm.getConnection().isSMSS()) {
            QueryBuilder smss = QueryBuilder.start((QueryBuilder.QueryUnit)QueryBuilder.smssRegion());
            if (this.type instanceof ICICSDefinitionType) {
                return smss.next(QueryBuilder.REGION_CSD).next(QueryBuilder.CSD_CICS_DEFINITIONS).next(QueryBuilder.cicsDefinition((ICICSDefinitionType)((ICICSDefinitionType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
            }
            if (this.type instanceof ICICSResourceType) {
                return smss.next(QueryBuilder.REGION_CICS_RESOURCES).next(QueryBuilder.cicsResource((ICICSResourceType)((ICICSResourceType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
            }
            if (!(this.type instanceof ICSDDefinitionType)) throw new RuntimeException("Unsupported resource type for SMSS: " + this.type);
            return smss.next(QueryBuilder.REGION_CSD).next(QueryBuilder.CSD_CSD_DEFINITIONS).next(QueryBuilder.csdDefinition((ICSDDefinitionType)((ICSDDefinitionType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
        }
        IScopedContext scopedContext = (IScopedContext)ContextHelper.getContextFrom((IContext)this.context, IScopedContext.class);
        if (scopedContext != null) {
            scope = scopedContext.getScope();
            scopeType = scopedContext.getScopeType();
        } else {
            scope = null;
            scopeType = null;
        }
        QueryBuilder cicsplex = QueryBuilder.start((QueryBuilder.QueryUnit)QueryBuilder.cicsplex((String)this.context.getContext()));
        if (this.type instanceof ICICSDefinitionType) {
            QueryBuilder repo = scope != null ? cicsplex.next(QueryBuilder.region((String)scope)).next(QueryBuilder.REGION_CSD).next(QueryBuilder.CSD_CICS_DEFINITIONS) : cicsplex.next(QueryBuilder.CICSPLEX_DREP).next(QueryBuilder.DREP_CICS_DEFINITIONS);
            return repo.next(QueryBuilder.cicsDefinition((ICICSDefinitionType)((ICICSDefinitionType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
        }
        if (this.type instanceof ICICSResourceType) {
            QueryBuilder resourceContainer;
            if (scope != null) {
                if (scopeType == IScopedContext.Type.REGION) {
                    resourceContainer = cicsplex.next(QueryBuilder.region((String)scope)).next(QueryBuilder.REGION_CICS_RESOURCES);
                    return resourceContainer.next(QueryBuilder.cicsResource((ICICSResourceType)((ICICSResourceType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
                } else if (scopeType == IScopedContext.Type.GROUP) {
                    resourceContainer = cicsplex.next(QueryBuilder.regionGroup((String)scope)).next(QueryBuilder.REGION_GROUP_CICS_RESOURCES);
                    return resourceContainer.next(QueryBuilder.cicsResource((ICICSResourceType)((ICICSResourceType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
                } else {
                    if (scopeType != IScopedContext.Type.UNKNOWN) throw new RuntimeException("Unknown scope type");
                    resourceContainer = cicsplex.next(QueryBuilder.unknownScope((String)scope));
                }
                return resourceContainer.next(QueryBuilder.cicsResource((ICICSResourceType)((ICICSResourceType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
            } else {
                resourceContainer = cicsplex.next(QueryBuilder.CICSPLEX_CICS_RESOURCES);
            }
            return resourceContainer.next(QueryBuilder.cicsResource((ICICSResourceType)((ICICSResourceType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
        }
        if (this.type instanceof ICPSMDefinitionType) {
            return cicsplex.next(QueryBuilder.CICSPLEX_DREP).next(QueryBuilder.DREP_CPSM_DEFINITIONS).next(QueryBuilder.cpsmDefinition((ICPSMDefinitionType)((ICPSMDefinitionType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
        }
        if (this.type instanceof ICPSMManagerType) {
            return cicsplex.next(QueryBuilder.CICSPLEX_CPSM_MANAGERS).next(QueryBuilder.cpsmManager((ICPSMManagerType)((ICPSMManagerType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
        }
        if (!(this.type instanceof ICSDDefinitionType)) throw new RuntimeException("Unsupported aggregation type: " + this.type);
        if (scope == null) {
            throw new RuntimeException("Scope is required to aggregate type: " + this.type);
        }
        QueryBuilder repo = cicsplex.next(QueryBuilder.region((String)scope)).next(QueryBuilder.REGION_CSD).next(QueryBuilder.CSD_CSD_DEFINITIONS);
        return repo.next(QueryBuilder.csdDefinition((ICSDDefinitionType)((ICSDDefinitionType)this.type), (FilterExpression)filter)).next(QueryBuilder.groupBy(this.groupByAttributes)).next(QueryBuilder.aggregate(attributes));
    }

    @Override
    public AggregatedResourcesModel getGroup(int index) {
        return this.summarizedResources != null && index < this.summarizedResources.size() ? this.summarizedResources.get(index) : null;
    }

    private <T> FilterExpression getFilterExpression() {
        Optional<ComplexFilteredContext> cfc = this.findParentComplexFilteredContext(this.context);
        if (cfc.isPresent()) {
            return cfc.get().getFilterExpression();
        }
        return FilterExpression.NULL;
    }

    private Optional<ComplexFilteredContext> findParentComplexFilteredContext(IContext context) {
        if (context instanceof ComplexFilteredContext) {
            return Optional.of((ComplexFilteredContext)context);
        }
        if (context instanceof FilteredContext) {
            debug.error("getFilterExpression", "Unsupported context: " + context, (Throwable)new IllegalArgumentException());
        } else if (context instanceof IChildContext) {
            return this.findParentComplexFilteredContext(((IChildContext)context).getParentContext());
        }
        return Optional.empty();
    }
}

