/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.Messages;
import com.ibm.cics.core.model.TableDescriptions;
import com.ibm.cics.core.model.internal.CICSObjectListFactory;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSObjectListFactory;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import java.util.List;

public abstract class AbstractCICSObjectContainer<T extends ICICSObject>
implements ICICSObjectContainer<T> {
    public <X extends T> ICICSObjectSet<X> getCICSObjectSet(ICICSType<X> type) {
        return new CICSObjectSet<X>(type, this);
    }

    public abstract <X extends T> void delete(ICICSType<X> var1, FilterExpression var2) throws CICSActionException;

    protected abstract <X extends T> IObjectGetter<X> getGetter(ICICSType<X> var1, FilterExpression var2);

    private static class CICSObjectSet<T extends ICICSObject>
    implements ICICSObjectSet<T> {
        private final ICICSType<T> type;
        private final AbstractCICSObjectContainer<? super T> container;
        private FilterExpression filterExpression;

        public CICSObjectSet(ICICSType<T> type, AbstractCICSObjectContainer<? super T> container) {
            this.type = type;
            this.container = container;
        }

        public ICICSObjectListFactory<T> asListFactory() {
            return new CICSObjectListFactory<T>(this.getDescription(), this.container.getGetter(this.type, this.filterExpression));
        }

        public List<T> get() throws CICSActionException {
            return this.asListFactory().getAll();
        }

        public void delete() throws CICSActionException {
            this.container.delete(this.type, this.filterExpression);
        }

        public String getDescription() {
            return Messages.bind((String)Messages.CICSObjectListFactory_description, (Object)TableDescriptions.getPluralTableDescription(this.type), (Object)this.container.getDescription());
        }

        public ICICSType<T> getCICSType() {
            return this.type;
        }

        public void setFilter(FilterExpression filterExpression) {
            this.filterExpression = filterExpression;
        }
    }

    public static interface IObjectGetter<O extends ICICSObject> {
        public ICICSType<O> getCICSType();

        public int get() throws CICSActionException;

        public List<O> fetch(int var1, int var2) throws CICSActionException;

        public void discard() throws CICSActionException;

        public List<O> getAll() throws CICSActionException;
    }
}

