/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CICSRegionTagsReference;
import com.ibm.cics.core.model.CICSRegionTagsType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSRegionTags;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class CICSRegionTags
extends CICSResource
implements ICICSRegionTags {
    private String _tag;
    private String _value;

    public CICSRegionTags(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._tag = (String)avm.getAttributeValue(CICSRegionTagsType.CICS_TAG);
        this._value = (String)avm.getAttributeValue(CICSRegionTagsType.CICS_TAG_VALUE);
    }

    public CICSRegionTags(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("TAG");
        this._tag = (String)((CICSAttribute)CICSRegionTagsType.CICS_TAG).get(stringValue, normalizers);
        stringValue = record.get("VALUE");
        this._value = (String)((CICSAttribute)CICSRegionTagsType.CICS_TAG_VALUE).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return CICSRegionTagsType.CICS_TAG.internalToExternal((Object)this.getCICSTag());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getCICSTag() {
        return this._tag;
    }

    public String getCICSTagValue() {
        return this._value;
    }

    public CICSRegionTagsType getObjectType() {
        return CICSRegionTagsType.getInstance();
    }

    @Override
    public CICSRegionTagsReference getCICSObjectReference() {
        return new CICSRegionTagsReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == CICSRegionTagsType.CICS_TAG) {
            return (V)this.getCICSTag();
        }
        if (attribute == CICSRegionTagsType.CICS_TAG_VALUE) {
            return (V)this.getCICSTagValue();
        }
        return super.getAttributeValue(attribute);
    }
}

