/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.EPAdapterSetReference;
import com.ibm.cics.core.model.EPAdapterSetType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IEPAdapterSet;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableEPAdapterSet;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableEPAdapterSet
extends MutableCICSResource
implements IMutableEPAdapterSet {
    private IEPAdapterSet delegate;
    private MutableSMRecord record;

    public MutableEPAdapterSet(ICPSM cpsm, IContext context, IEPAdapterSet cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("EPADSET");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IEPAdapterSet.StatusValue getStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IEPAdapterSet.StatusValue)((CICSAttribute)EPAdapterSetType.STATUS).get(result, this.record.getNormalizers());
    }

    public Long getEpAdapterNumber() {
        return this.delegate.getEpAdapterNumber();
    }

    public IEPAdapterSet.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public IEPAdapterSet.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public void setStatus(IEPAdapterSet.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            EPAdapterSetType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)EPAdapterSetType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == EPAdapterSetType.NAME) {
            return (V)this.getName();
        }
        if (attribute == EPAdapterSetType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == EPAdapterSetType.EP_ADAPTER_NUMBER) {
            return (V)this.getEpAdapterNumber();
        }
        if (attribute == EPAdapterSetType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == EPAdapterSetType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == EPAdapterSetType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == EPAdapterSetType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == EPAdapterSetType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == EPAdapterSetType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == EPAdapterSetType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == EPAdapterSetType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == EPAdapterSetType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        return super.getAttributeValue(attribute);
    }

    public EPAdapterSetType getObjectType() {
        return EPAdapterSetType.getInstance();
    }

    @Override
    public EPAdapterSetReference getCICSObjectReference() {
        return new EPAdapterSetReference(this.getCICSContainer(), this.getName());
    }
}

