/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TaskReference;
import com.ibm.cics.core.model.TaskType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ITask;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTask;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableTask
extends MutableCICSResource
implements IMutableTask {
    private ITask delegate;
    private MutableSMRecord record;

    public MutableTask(ICPSM cpsm, IContext context, ITask cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("TASK");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getTaskID() {
        return this.delegate.getTaskID();
    }

    public String getPrincipalFacility() {
        return this.delegate.getPrincipalFacility();
    }

    public ITask.FacilityTypeValue getFacilityType() {
        return this.delegate.getFacilityType();
    }

    public String getCurrentSuspendTime() {
        return this.delegate.getCurrentSuspendTime();
    }

    public String getSuspendReason() {
        return this.delegate.getSuspendReason();
    }

    public String getSuspendedForResource() {
        return this.delegate.getSuspendedForResource();
    }

    public Long getPriority() {
        String result = this.record.get("PRIORITY");
        if (result == null) {
            return this.delegate.getPriority();
        }
        return (Long)((CICSAttribute)TaskType.PRIORITY).get(result, this.record.getNormalizers());
    }

    public String getLocalUOWID2() {
        return this.delegate.getLocalUOWID2();
    }

    public ITask.RunStatusValue getRunStatus() {
        return this.delegate.getRunStatus();
    }

    public String getClassName() {
        return this.delegate.getClassName();
    }

    public String getTransactionID() {
        return this.delegate.getTransactionID();
    }

    public String getUserID() {
        return this.delegate.getUserID();
    }

    public String getTransactionType() {
        return this.delegate.getTransactionType();
    }

    public String getRecordType() {
        return this.delegate.getRecordType();
    }

    public Date getStartTime() {
        return this.delegate.getStartTime();
    }

    public Date getStopTime() {
        return this.delegate.getStopTime();
    }

    public String getLUName() {
        return this.delegate.getLUName();
    }

    public String getFirstProgram() {
        return this.delegate.getFirstProgram();
    }

    public String getOriginSystemNetname() {
        return this.delegate.getOriginSystemNetname();
    }

    public Long getErrorFlags() {
        return this.delegate.getErrorFlags();
    }

    public String getOriginalABENDCode() {
        return this.delegate.getOriginalABENDCode();
    }

    public String getCurrentABENDCode() {
        return this.delegate.getCurrentABENDCode();
    }

    public Long getRecvdPrimaryTCMsgs() {
        return this.delegate.getRecvdPrimaryTCMsgs();
    }

    public Long getRecvdPrimaryTCChars() {
        return this.delegate.getRecvdPrimaryTCChars();
    }

    public Long getSentPrimaryTCMsgs() {
        return this.delegate.getSentPrimaryTCMsgs();
    }

    public Long getSentPrimaryTCChars() {
        return this.delegate.getSentPrimaryTCChars();
    }

    public Long getRecvdSecondaryTCMsgs() {
        return this.delegate.getRecvdSecondaryTCMsgs();
    }

    public Long getRecvdSecondaryTCChars() {
        return this.delegate.getRecvdSecondaryTCChars();
    }

    public Long getSentSecondaryTCMsgs() {
        return this.delegate.getSentSecondaryTCMsgs();
    }

    public Long getSentSecondaryTCChars() {
        return this.delegate.getSentSecondaryTCChars();
    }

    public Long getALLOCATERequestCount() {
        return this.delegate.getALLOCATERequestCount();
    }

    public Long getUserGETMAINRequestsBelow16MB() {
        return this.delegate.getUserGETMAINRequestsBelow16MB();
    }

    public Long getUserGETMAINRequestsAbove16MB() {
        return this.delegate.getUserGETMAINRequestsAbove16MB();
    }

    public Long getCDSARequestGETMAIN() {
        return this.delegate.getCDSARequestGETMAIN();
    }

    public Long getGETMAINRequestsECDSA() {
        return this.delegate.getGETMAINRequestsECDSA();
    }

    public Long getUDSAPeakBytes() {
        return this.delegate.getUDSAPeakBytes();
    }

    public Long getEUDSAPeakBytes() {
        return this.delegate.getEUDSAPeakBytes();
    }

    public Long getCDSATaskPeakBytes() {
        return this.delegate.getCDSATaskPeakBytes();
    }

    public Long getPeakBytesECDSA() {
        return this.delegate.getPeakBytesECDSA();
    }

    public Long getAvgStorageUsageBelow16MB() {
        return this.delegate.getAvgStorageUsageBelow16MB();
    }

    public Long getAvgStorageUsageAbove16MB() {
        return this.delegate.getAvgStorageUsageAbove16MB();
    }

    public Long getAvgCDSAStorage() {
        return this.delegate.getAvgCDSAStorage();
    }

    public Long getAverageStorageECDSA() {
        return this.delegate.getAverageStorageECDSA();
    }

    public Long getMaxProgStorageAllDSAs() {
        return this.delegate.getMaxProgStorageAllDSAs();
    }

    public Long getMaxProgStorageBelow16MB() {
        return this.delegate.getMaxProgStorageBelow16MB();
    }

    public Long getMaxProgStorageAbove16MB() {
        return this.delegate.getMaxProgStorageAbove16MB();
    }

    public Long getMaxEUDSAProgramStorage() {
        return this.delegate.getMaxEUDSAProgramStorage();
    }

    public Long getMaxUDSAProgramStorage() {
        return this.delegate.getMaxUDSAProgramStorage();
    }

    public Long getMaxProgStorageECDSA() {
        return this.delegate.getMaxProgStorageECDSA();
    }

    public Long getCDSAMaxProgramStorage() {
        return this.delegate.getCDSAMaxProgramStorage();
    }

    public Long getMaxStorageERDSA() {
        return this.delegate.getMaxStorageERDSA();
    }

    public Long getFileREADCount() {
        return this.delegate.getFileREADCount();
    }

    public Long getFileREWRITECount() {
        return this.delegate.getFileREWRITECount();
    }

    public Long getFileBrowseCount() {
        return this.delegate.getFileBrowseCount();
    }

    public Long getFileWRITECount() {
        return this.delegate.getFileWRITECount();
    }

    public Long getFileDELETECount() {
        return this.delegate.getFileDELETECount();
    }

    public Long getTotalFileControlCount() {
        return this.delegate.getTotalFileControlCount();
    }

    public Long getFileAccessCount() {
        return this.delegate.getFileAccessCount();
    }

    public Long getTDGetCount() {
        return this.delegate.getTDGetCount();
    }

    public Long getTDPutCount() {
        return this.delegate.getTDPutCount();
    }

    public Long getTDPurgeCount() {
        return this.delegate.getTDPurgeCount();
    }

    public Long getTotalTDCount() {
        return this.delegate.getTotalTDCount();
    }

    public Long getTSGetCount() {
        return this.delegate.getTSGetCount();
    }

    public Long getTSPutAUXCount() {
        return this.delegate.getTSPutAUXCount();
    }

    public Long getTSPutMAINCount() {
        return this.delegate.getTSPutMAINCount();
    }

    public Long getTSRequestCount() {
        return this.delegate.getTSRequestCount();
    }

    public Long getBMSMap() {
        return this.delegate.getBMSMap();
    }

    public Long getBMSMapIn() {
        return this.delegate.getBMSMapIn();
    }

    public Long getBMSMapOut() {
        return this.delegate.getBMSMapOut();
    }

    public Long getBMSTotal() {
        return this.delegate.getBMSTotal();
    }

    public Long getLINKCount() {
        return this.delegate.getLINKCount();
    }

    public Long getXCTLCount() {
        return this.delegate.getXCTLCount();
    }

    public Long getProgramLoadCount() {
        return this.delegate.getProgramLoadCount();
    }

    public Long getICSTARTCount() {
        return this.delegate.getICSTARTCount();
    }

    public Long getSyncpointCount() {
        return this.delegate.getSyncpointCount();
    }

    public String getDispatchTime() {
        return this.delegate.getDispatchTime();
    }

    public String getCPUTime() {
        return this.delegate.getCPUTime();
    }

    public String getTaskSuspendTime() {
        return this.delegate.getTaskSuspendTime();
    }

    public String getDispatchWaitTime() {
        return this.delegate.getDispatchWaitTime();
    }

    public String getExceptionWaitTime() {
        return this.delegate.getExceptionWaitTime();
    }

    public String getTerminalIOWaitTime() {
        return this.delegate.getTerminalIOWaitTime();
    }

    public String getFileIOWaitTime() {
        return this.delegate.getFileIOWaitTime();
    }

    public String getJournalIOWaitTime() {
        return this.delegate.getJournalIOWaitTime();
    }

    public String getTSIOWaitTime() {
        return this.delegate.getTSIOWaitTime();
    }

    public String getIRCIOWaitTime() {
        return this.delegate.getIRCIOWaitTime();
    }

    public String getTDIOWaitTime() {
        return this.delegate.getTDIOWaitTime();
    }

    public String getProgramLoadTime() {
        return this.delegate.getProgramLoadTime();
    }

    public String getStartCode() {
        return this.delegate.getStartCode();
    }

    public ITask.CommandSecurityValue getCommandSecurity() {
        return this.delegate.getCommandSecurity();
    }

    public ITask.DTBValue getDTB() {
        return this.delegate.getDTB();
    }

    public Long getDeadlockTimeout() {
        return this.delegate.getDeadlockTimeout();
    }

    public ITask.TransactionDumpValue getTransactionDump() {
        return this.delegate.getTransactionDump();
    }

    public ITask.DataIsolationTypeValue getDataIsolationType() {
        return this.delegate.getDataIsolationType();
    }

    public String getTaskProfile() {
        return this.delegate.getTaskProfile();
    }

    public ITask.PurgeabilityValue getPurgeability() {
        return this.delegate.getPurgeability();
    }

    public ITask.RoutingTypeValue getRoutingType() {
        return this.delegate.getRoutingType();
    }

    public ITask.ResourceSecurityValue getResourceSecurity() {
        return this.delegate.getResourceSecurity();
    }

    public Long getReadTimeout() {
        return this.delegate.getReadTimeout();
    }

    public Long getRunawayTaskTime() {
        return this.delegate.getRunawayTaskTime();
    }

    public ITask.ScreenSizeValue getScreenSize() {
        return this.delegate.getScreenSize();
    }

    public ITask.StorageClearanceStatusValue getStorageClearanceStatus() {
        return this.delegate.getStorageClearanceStatus();
    }

    public ITask.DataStorageKeyValue getDataStorageKey() {
        return this.delegate.getDataStorageKey();
    }

    public ITask.DataLocationValue getDataLocation() {
        return this.delegate.getDataLocation();
    }

    public ITask.TaskTracingTypeValue getTaskTracingType() {
        return this.delegate.getTaskTracingType();
    }

    public Long getTransactionPriority() {
        return this.delegate.getTransactionPriority();
    }

    public String getTransactionRoutingProfileName() {
        return this.delegate.getTransactionRoutingProfileName();
    }

    public Long getTWABytes() {
        return this.delegate.getTWABytes();
    }

    public String getRemoteTransaction() {
        return this.delegate.getRemoteTransaction();
    }

    public String getRemoteSystemID() {
        return this.delegate.getRemoteSystemID();
    }

    public Long getRecvdSecondaryLU62Messages() {
        return this.delegate.getRecvdSecondaryLU62Messages();
    }

    public Long getSecondaryLU62CharReceiveCount() {
        return this.delegate.getSecondaryLU62CharReceiveCount();
    }

    public Long getSentSecondaryLU62Message() {
        return this.delegate.getSentSecondaryLU62Message();
    }

    public Long getSecondaryLU62CharSendCount() {
        return this.delegate.getSecondaryLU62CharSendCount();
    }

    public Long getMaxRDSAReadOnlyStorage() {
        return this.delegate.getMaxRDSAReadOnlyStorage();
    }

    public Long getMaxESDSASharedStorage() {
        return this.delegate.getMaxESDSASharedStorage();
    }

    public Long getMaxSDSASharedStorage() {
        return this.delegate.getMaxSDSASharedStorage();
    }

    public Long getFEPIAllocateRequestCount() {
        return this.delegate.getFEPIAllocateRequestCount();
    }

    public Long getFEPIReceiveCount() {
        return this.delegate.getFEPIReceiveCount();
    }

    public Long getFEPISendCount() {
        return this.delegate.getFEPISendCount();
    }

    public Long getFEPIStartCount() {
        return this.delegate.getFEPIStartCount();
    }

    public Long getFEPICharSendCount() {
        return this.delegate.getFEPICharSendCount();
    }

    public Long getFEPICharReceiveCount() {
        return this.delegate.getFEPICharReceiveCount();
    }

    public Long getFEPIAllocateTimeoutCount() {
        return this.delegate.getFEPIAllocateTimeoutCount();
    }

    public Long getFEPIReceiveTimeoutCount() {
        return this.delegate.getFEPIReceiveTimeoutCount();
    }

    public Long getFEPITotalCount() {
        return this.delegate.getFEPITotalCount();
    }

    public String getFEPISuspendTime() {
        return this.delegate.getFEPISuspendTime();
    }

    public String getDispatchDelayTime() {
        return this.delegate.getDispatchDelayTime();
    }

    public String getTCLDelayTime() {
        return this.delegate.getTCLDelayTime();
    }

    public String getMXTLimit1stDispatchDelayTime() {
        return this.delegate.getMXTLimit1stDispatchDelayTime();
    }

    public String getEnqueueDelay() {
        return this.delegate.getEnqueueDelay();
    }

    public String getLU61IOWaitTime() {
        return this.delegate.getLU61IOWaitTime();
    }

    public String getLU62IOWaitTime() {
        return this.delegate.getLU62IOWaitTime();
    }

    public String getRMITotalTime() {
        return this.delegate.getRMITotalTime();
    }

    public String getRMISuspendTime() {
        return this.delegate.getRMISuspendTime();
    }

    public Long getPerformanceRecordCount() {
        return this.delegate.getPerformanceRecordCount();
    }

    public String getRecoveryManagerUOWID() {
        return this.delegate.getRecoveryManagerUOWID();
    }

    public String getWLMServiceClassName() {
        return this.delegate.getWLMServiceClassName();
    }

    public String getWLMReportClassName() {
        return this.delegate.getWLMReportClassName();
    }

    public String getTransactionFlags() {
        return this.delegate.getTransactionFlags();
    }

    public String getTerminalConnectionName() {
        return this.delegate.getTerminalConnectionName();
    }

    public Long getGETMAINRequestsBelow16MB() {
        return this.delegate.getGETMAINRequestsBelow16MB();
    }

    public Long getGETMAINBytesBelow16MB() {
        return this.delegate.getGETMAINBytesBelow16MB();
    }

    public Long getFREEMAINBytesBelow16MB() {
        return this.delegate.getFREEMAINBytesBelow16MB();
    }

    public Long getGETMAINRequestsAbove16MB() {
        return this.delegate.getGETMAINRequestsAbove16MB();
    }

    public Long getGETMAINBytesAbove16MB() {
        return this.delegate.getGETMAINBytesAbove16MB();
    }

    public Long getFREEMAINBytesAbove16MB() {
        return this.delegate.getFREEMAINBytesAbove16MB();
    }

    public Long getJournalWriteCount() {
        return this.delegate.getJournalWriteCount();
    }

    public Long getCICSLoggerWriteCount() {
        return this.delegate.getCICSLoggerWriteCount();
    }

    public String getSyncpointWaitTime() {
        return this.delegate.getSyncpointWaitTime();
    }

    public String getVSAMRecordSharingWaitTime() {
        return this.delegate.getVSAMRecordSharingWaitTime();
    }

    public String getTerminalInformation() {
        return this.delegate.getTerminalInformation();
    }

    public Date getAttachTime() {
        return this.delegate.getAttachTime();
    }

    public String getUOWID() {
        return this.delegate.getUOWID();
    }

    public ITask.IndoubtActionValue getIndoubtAction() {
        return this.delegate.getIndoubtAction();
    }

    public Long getIndoubtTime() {
        return this.delegate.getIndoubtTime();
    }

    public ITask.IndoubtWaitValue getIndoubtWait() {
        return this.delegate.getIndoubtWait();
    }

    public String getBridgeTransactionID() {
        return this.delegate.getBridgeTransactionID();
    }

    public ICICSEnums.YesNoValue getStartedByBridge() {
        return this.delegate.getStartedByBridge();
    }

    public String getLockManagerWaitTime() {
        return this.delegate.getLockManagerWaitTime();
    }

    public String getExternalWaitTime() {
        return this.delegate.getExternalWaitTime();
    }

    public String getCICSEventWait() {
        return this.delegate.getCICSEventWait();
    }

    public String getICDelay() {
        return this.delegate.getICDelay();
    }

    public String getControlWaitTime() {
        return this.delegate.getControlWaitTime();
    }

    public String getSharedTSWaitTime() {
        return this.delegate.getSharedTSWaitTime();
    }

    public String getVSAMRecordSharingCPUTime() {
        return this.delegate.getVSAMRecordSharingCPUTime();
    }

    public Long getTotalICCount() {
        return this.delegate.getTotalICCount();
    }

    public String getBridgeIdentifier() {
        return this.delegate.getBridgeIdentifier();
    }

    public Long getURMLinkCount() {
        return this.delegate.getURMLinkCount();
    }

    public String getDB2PlanName() {
        return this.delegate.getDB2PlanName();
    }

    public String getCFDTWaitTime() {
        return this.delegate.getCFDTWaitTime();
    }

    public String getCFDTSyncWaitTime() {
        return this.delegate.getCFDTSyncWaitTime();
    }

    public ITask.TCBTypeValue getTCBType() {
        return this.delegate.getTCBType();
    }

    public String getBTSProcessName() {
        return this.delegate.getBTSProcessName();
    }

    public String getBTSProcessID() {
        return this.delegate.getBTSProcessID();
    }

    public String getBTSProcessType() {
        return this.delegate.getBTSProcessType();
    }

    public String getActivityName() {
        return this.delegate.getActivityName();
    }

    public String getActivityID() {
        return this.delegate.getActivityID();
    }

    public Long getBTSRunSync() {
        return this.delegate.getBTSRunSync();
    }

    public Long getBTSRunAsync() {
        return this.delegate.getBTSRunAsync();
    }

    public Long getBTSLink() {
        return this.delegate.getBTSLink();
    }

    public Long getBTSDefineProcess() {
        return this.delegate.getBTSDefineProcess();
    }

    public Long getBTSDefineActivity() {
        return this.delegate.getBTSDefineActivity();
    }

    public Long getBTSReset() {
        return this.delegate.getBTSReset();
    }

    public Long getBTSSuspend() {
        return this.delegate.getBTSSuspend();
    }

    public Long getBTSResume() {
        return this.delegate.getBTSResume();
    }

    public Long getBTSDeleteAndCancel() {
        return this.delegate.getBTSDeleteAndCancel();
    }

    public Long getBTSAcquire() {
        return this.delegate.getBTSAcquire();
    }

    public Long getBTSTotal() {
        return this.delegate.getBTSTotal();
    }

    public Long getBTSProcessDataContainer() {
        return this.delegate.getBTSProcessDataContainer();
    }

    public Long getBTSActivityDataContainer() {
        return this.delegate.getBTSActivityDataContainer();
    }

    public Long getBTSTotalDataContainer() {
        return this.delegate.getBTSTotalDataContainer();
    }

    public Long getBTSRetrieveReattachEvent() {
        return this.delegate.getBTSRetrieveReattachEvent();
    }

    public Long getBTSDefineInputEvent() {
        return this.delegate.getBTSDefineInputEvent();
    }

    public Long getBTSTimerAssoc() {
        return this.delegate.getBTSTimerAssoc();
    }

    public Long getBTSTotalEvent() {
        return this.delegate.getBTSTotalEvent();
    }

    public String getBTSRunSyncWaitTime() {
        return this.delegate.getBTSRunSyncWaitTime();
    }

    public String getParentSyncpointWaitTime() {
        return this.delegate.getParentSyncpointWaitTime();
    }

    public Long getWEBReceiveCount2() {
        return this.delegate.getWEBReceiveCount2();
    }

    public Long getRecvdWEBChars() {
        return this.delegate.getRecvdWEBChars();
    }

    public Long getWEBSendCount2() {
        return this.delegate.getWEBSendCount2();
    }

    public Long getSentWEBChars() {
        return this.delegate.getSentWEBChars();
    }

    public Long getWEBTotalCount() {
        return this.delegate.getWEBTotalCount();
    }

    public Long getWEBRepositoryWriteCount() {
        return this.delegate.getWEBRepositoryWriteCount();
    }

    public Long getDocCreates() {
        return this.delegate.getDocCreates();
    }

    public Long getDocInserts() {
        return this.delegate.getDocInserts();
    }

    public Long getDocSets() {
        return this.delegate.getDocSets();
    }

    public Long getDocRetrieves() {
        return this.delegate.getDocRetrieves();
    }

    public Long getTotalDocRequests() {
        return this.delegate.getTotalDocRequests();
    }

    public Long getTotalDocLength() {
        return this.delegate.getTotalDocLength();
    }

    public String getIMSWaitTime() {
        return this.delegate.getIMSWaitTime();
    }

    public String getDB2ReadyQWaitTime() {
        return this.delegate.getDB2ReadyQWaitTime();
    }

    public String getDB2ConnWaitTime() {
        return this.delegate.getDB2ConnWaitTime();
    }

    public String getDB2WaitTime() {
        return this.delegate.getDB2WaitTime();
    }

    public String getMaxOpenTCBDelayTime() {
        return this.delegate.getMaxOpenTCBDelayTime();
    }

    public String getQRDelayTime() {
        return this.delegate.getQRDelayTime();
    }

    public String getQRDispatchTime() {
        return this.delegate.getQRDispatchTime();
    }

    public String getQRCPUTime() {
        return this.delegate.getQRCPUTime();
    }

    public String getOtherTCBDispatchTime() {
        return this.delegate.getOtherTCBDispatchTime();
    }

    public String getOtherTCBCPUTime() {
        return this.delegate.getOtherTCBCPUTime();
    }

    public String getL8CPUTime() {
        return this.delegate.getL8CPUTime();
    }

    public String getJ8CPUTime() {
        return this.delegate.getJ8CPUTime();
    }

    public String getS8CPUTime() {
        return this.delegate.getS8CPUTime();
    }

    public Long getTotalIMSCount() {
        return this.delegate.getTotalIMSCount();
    }

    public Long getTotalDB2Requests() {
        return this.delegate.getTotalDB2Requests();
    }

    public Long getDispatcherChangeModes() {
        return this.delegate.getDispatcherChangeModes();
    }

    public Long getDispatcherTCBAttachCount() {
        return this.delegate.getDispatcherTCBAttachCount();
    }

    public String getGlobalENQDelay() {
        return this.delegate.getGlobalENQDelay();
    }

    public String getRRMSWaitTime() {
        return this.delegate.getRRMSWaitTime();
    }

    public String getTCPIPIOWaitTime() {
        return this.delegate.getTCPIPIOWaitTime();
    }

    public String getRRMSURID() {
        return this.delegate.getRRMSURID();
    }

    public Long getDPLCount() {
        return this.delegate.getDPLCount();
    }

    public String getClientIPAddress() {
        return this.delegate.getClientIPAddress();
    }

    public Long getEncryptedSocketBytes() {
        return this.delegate.getEncryptedSocketBytes();
    }

    public Long getDecryptedSocketBytes() {
        return this.delegate.getDecryptedSocketBytes();
    }

    public String getTerminalID() {
        return this.delegate.getTerminalID();
    }

    public String getTotalJVMElapsedTime() {
        return this.delegate.getTotalJVMElapsedTime();
    }

    public String getTotalJVMSuspendTime() {
        return this.delegate.getTotalJVMSuspendTime();
    }

    public String getBridgeToken() {
        return this.delegate.getBridgeToken();
    }

    public ITask.PurgeTypeValue getPurgeType() {
        String result = this.record.get("PURGETYPE");
        if (result == null) {
            return this.delegate.getPurgeType();
        }
        return (ITask.PurgeTypeValue)((CICSAttribute)TaskType.PURGE_TYPE).get(result, this.record.getNormalizers());
    }

    public Long getTaskStorageUDSA() {
        return this.delegate.getTaskStorageUDSA();
    }

    public Long getTaskStorageEUDSA() {
        return this.delegate.getTaskStorageEUDSA();
    }

    public Long getTaskStorageCDSA() {
        return this.delegate.getTaskStorageCDSA();
    }

    public Long getTaskStorageECDSA() {
        return this.delegate.getTaskStorageECDSA();
    }

    public Long getProgStorageTotal() {
        return this.delegate.getProgStorageTotal();
    }

    public Long getProgStorageAbove() {
        return this.delegate.getProgStorageAbove();
    }

    public Long getProgStorageBelow() {
        return this.delegate.getProgStorageBelow();
    }

    public Long getProgStorageECDSA() {
        return this.delegate.getProgStorageECDSA();
    }

    public Long getProgStorageCSDA() {
        return this.delegate.getProgStorageCSDA();
    }

    public Long getProgStorageERDSA() {
        return this.delegate.getProgStorageERDSA();
    }

    public Long getProgStorageRSDA() {
        return this.delegate.getProgStorageRSDA();
    }

    public Long getProgStorageESDSA() {
        return this.delegate.getProgStorageESDSA();
    }

    public Long getProgStorageSDSA() {
        return this.delegate.getProgStorageSDSA();
    }

    public Long getNonpersistentSockets() {
        return this.delegate.getNonpersistentSockets();
    }

    public Long getPersistentSockets() {
        return this.delegate.getPersistentSockets();
    }

    public String getTransactionApplName() {
        return this.delegate.getTransactionApplName();
    }

    public String getProgramApplName() {
        return this.delegate.getProgramApplName();
    }

    public String getCurrentProgram() {
        return this.delegate.getCurrentProgram();
    }

    public String getTransSeqNumber() {
        return this.delegate.getTransSeqNumber();
    }

    public String getTransactionGroupID() {
        return this.delegate.getTransactionGroupID();
    }

    public String getNetworkID() {
        return this.delegate.getNetworkID();
    }

    public String getRealLUNAME() {
        return this.delegate.getRealLUNAME();
    }

    public Long getTCPIPServicePort() {
        return this.delegate.getTCPIPServicePort();
    }

    public String getOTSTransactionID() {
        return this.delegate.getOTSTransactionID();
    }

    public Long getOOClassLibraryAPICount() {
        return this.delegate.getOOClassLibraryAPICount();
    }

    public Long getRepositoryReadCount() {
        return this.delegate.getRepositoryReadCount();
    }

    public Long getWebEXTRACTCount() {
        return this.delegate.getWebEXTRACTCount();
    }

    public Long getServerWebBrowseCount() {
        return this.delegate.getServerWebBrowseCount();
    }

    public Long getServerWebREADCount() {
        return this.delegate.getServerWebREADCount();
    }

    public Long getServerWebWRITECount() {
        return this.delegate.getServerWebWRITECount();
    }

    public Long getEXTRACTTCPIPAndCERTIFICATECount() {
        return this.delegate.getEXTRACTTCPIPAndCERTIFICATECount();
    }

    public Long getCREATENonPersistentSocketCount() {
        return this.delegate.getCREATENonPersistentSocketCount();
    }

    public Long getCREATEPersistentSocketCount() {
        return this.delegate.getCREATEPersistentSocketCount();
    }

    public Long getNonpersistentSocketHWM() {
        return this.delegate.getNonpersistentSocketHWM();
    }

    public Long getPersistentSocketHWM() {
        return this.delegate.getPersistentSocketHWM();
    }

    public Long getSocketReceiveCount() {
        return this.delegate.getSocketReceiveCount();
    }

    public Long getRecvdSocketChars() {
        return this.delegate.getRecvdSocketChars();
    }

    public Long getSocketSendCount() {
        return this.delegate.getSocketSendCount();
    }

    public Long getSentSocketChars() {
        return this.delegate.getSentSocketChars();
    }

    public Long getSocketTotalRequestCount() {
        return this.delegate.getSocketTotalRequestCount();
    }

    public Long getRecvdInboundSocketCount() {
        return this.delegate.getRecvdInboundSocketCount();
    }

    public Long getRecvdInboundSocketChars() {
        return this.delegate.getRecvdInboundSocketChars();
    }

    public Long getSendInboundSocketCount() {
        return this.delegate.getSendInboundSocketCount();
    }

    public Long getSendInboundSocketChars() {
        return this.delegate.getSendInboundSocketChars();
    }

    public String getRODispatchTime() {
        return this.delegate.getRODispatchTime();
    }

    public String getROCPUTime() {
        return this.delegate.getROCPUTime();
    }

    public String getKey8DispatchTime() {
        return this.delegate.getKey8DispatchTime();
    }

    public String getKey8CPUTime() {
        return this.delegate.getKey8CPUTime();
    }

    public String getMaxJVMTCBDelayTime() {
        return this.delegate.getMaxJVMTCBDelayTime();
    }

    public String getMaxHotPoolingTCBDelay() {
        return this.delegate.getMaxHotPoolingTCBDelay();
    }

    public String getOutboundSocketIOWaitTime() {
        return this.delegate.getOutboundSocketIOWaitTime();
    }

    public String getRequestReceiverWaitTime() {
        return this.delegate.getRequestReceiverWaitTime();
    }

    public String getRequestProcessorWaitTime() {
        return this.delegate.getRequestProcessorWaitTime();
    }

    public String getOTSInDoubtWaitTime() {
        return this.delegate.getOTSInDoubtWaitTime();
    }

    public String getJVMInitializeElapsedTime() {
        return this.delegate.getJVMInitializeElapsedTime();
    }

    public String getJVMResetElapsedTime() {
        return this.delegate.getJVMResetElapsedTime();
    }

    public String getPartnerWaitTime() {
        return this.delegate.getPartnerWaitTime();
    }

    public ITask.TransactionTypeDetailsValue getTransactionTypeDetails() {
        return this.delegate.getTransactionTypeDetails();
    }

    public ICICSEnums.YesNoValue getBTEPhaseComplete() {
        return this.delegate.getBTEPhaseComplete();
    }

    public ICICSEnums.YesNoValue getWLMExecComplete() {
        return this.delegate.getWLMExecComplete();
    }

    public ICICSEnums.YesNoValue getWLMSubsetExecComplete() {
        return this.delegate.getWLMSubsetExecComplete();
    }

    public ITask.TransOriginTypeValue getTransOriginType() {
        return this.delegate.getTransOriginType();
    }

    public ICICSEnums.YesNoValue getUOWResolvedIndoubt() {
        return this.delegate.getUOWResolvedIndoubt();
    }

    public ICICSEnums.YesNoValue getRecoveryManagerUOWShunted() {
        return this.delegate.getRecoveryManagerUOWShunted();
    }

    public ICICSEnums.YesNoValue getUOWUnshunted() {
        return this.delegate.getUOWUnshunted();
    }

    public ICICSEnums.YesNoValue getIndoubtFailure() {
        return this.delegate.getIndoubtFailure();
    }

    public ICICSEnums.YesNoValue getUOWResourceOwnerFailure() {
        return this.delegate.getUOWResourceOwnerFailure();
    }

    public String getResponseTime() {
        return this.delegate.getResponseTime();
    }

    public String getLU62UOWSequenceNumber() {
        return this.delegate.getLU62UOWSequenceNumber();
    }

    public String getTCPIPServiceName() {
        return this.delegate.getTCPIPServiceName();
    }

    public String getCORBAServerName() {
        return this.delegate.getCORBAServerName();
    }

    public Long getDispatcherTCBHWM() {
        return this.delegate.getDispatcherTCBHWM();
    }

    public Long getBeanStateActivationCount() {
        return this.delegate.getBeanStateActivationCount();
    }

    public Long getBeanStatePassivationCount() {
        return this.delegate.getBeanStatePassivationCount();
    }

    public Long getBeanCreationCount() {
        return this.delegate.getBeanCreationCount();
    }

    public Long getBeanRemovalCount() {
        return this.delegate.getBeanRemovalCount();
    }

    public Long getBeanMethodCallCount() {
        return this.delegate.getBeanMethodCallCount();
    }

    public Long getBeanTotalCount() {
        return this.delegate.getBeanTotalCount();
    }

    public String getKey9DispatchTime() {
        return this.delegate.getKey9DispatchTime();
    }

    public String getKey9CPUTime() {
        return this.delegate.getKey9CPUTime();
    }

    public String getJ9CPUTime() {
        return this.delegate.getJ9CPUTime();
    }

    public String getDispatcherTCBMismatchWaitTime() {
        return this.delegate.getDispatcherTCBMismatchWaitTime();
    }

    public String getDSStorageWaitTime() {
        return this.delegate.getDSStorageWaitTime();
    }

    public String getCorrelationUOW() {
        return this.delegate.getCorrelationUOW();
    }

    public String getNetworkUOWID() {
        return this.delegate.getNetworkUOWID();
    }

    public Long getDPLWithChannelDataLength() {
        return this.delegate.getDPLWithChannelDataLength();
    }

    public Long getDPLReturnWithChannelDataLength() {
        return this.delegate.getDPLReturnWithChannelDataLength();
    }

    public Long getProgramLinkWithChannelCount() {
        return this.delegate.getProgramLinkWithChannelCount();
    }

    public Long getXCTLWithChannelCount() {
        return this.delegate.getXCTLWithChannelCount();
    }

    public Long getDPLWithChannelCount() {
        return this.delegate.getDPLWithChannelCount();
    }

    public Long getProgramReturnWithChannelCount() {
        return this.delegate.getProgramReturnWithChannelCount();
    }

    public Long getProgramReturnWithChannelDataLength() {
        return this.delegate.getProgramReturnWithChannelDataLength();
    }

    public Long getTotalChannelContainerCount() {
        return this.delegate.getTotalChannelContainerCount();
    }

    public Long getChannelContainerBrowseCount() {
        return this.delegate.getChannelContainerBrowseCount();
    }

    public Long getChannelContainerGETCount() {
        return this.delegate.getChannelContainerGETCount();
    }

    public Long getChannelContainerPUTCount() {
        return this.delegate.getChannelContainerPUTCount();
    }

    public Long getChannelContainerMOVECount() {
        return this.delegate.getChannelContainerMOVECount();
    }

    public Long getChannelContainerGETDataLength() {
        return this.delegate.getChannelContainerGETDataLength();
    }

    public Long getChannelContainerPUTDataLength() {
        return this.delegate.getChannelContainerPUTDataLength();
    }

    public Long getInvokeWebServiceCount() {
        return this.delegate.getInvokeWebServiceCount();
    }

    public Long getClientWebREADCount() {
        return this.delegate.getClientWebREADCount();
    }

    public Long getClientWebWRITECount() {
        return this.delegate.getClientWebWRITECount();
    }

    public Long getWebRECEIVECount() {
        return this.delegate.getWebRECEIVECount();
    }

    public Long getWebRECEIVEBytes() {
        return this.delegate.getWebRECEIVEBytes();
    }

    public Long getWebSENDCount() {
        return this.delegate.getWebSENDCount();
    }

    public Long getWebSENDBytes() {
        return this.delegate.getWebSENDBytes();
    }

    public Long getWebPARSEURLCount() {
        return this.delegate.getWebPARSEURLCount();
    }

    public Long getClientWebBrowseCount() {
        return this.delegate.getClientWebBrowseCount();
    }

    public String getMaxCICSSSLTCBDelayTime() {
        return this.delegate.getMaxCICSSSLTCBDelayTime();
    }

    public String getMaxCICSXPLinkTCBDelayTime() {
        return this.delegate.getMaxCICSXPLinkTCBDelayTime();
    }

    public String getTCBChangeModeDelayTime() {
        return this.delegate.getTCBChangeModeDelayTime();
    }

    public String getX8CPUTime() {
        return this.delegate.getX8CPUTime();
    }

    public String getX9CPUTime() {
        return this.delegate.getX9CPUTime();
    }

    public Long getLocalSTARTCHANNELTotalCount() {
        return this.delegate.getLocalSTARTCHANNELTotalCount();
    }

    public Long getLocalSTARTCHANNELDataLength() {
        return this.delegate.getLocalSTARTCHANNELDataLength();
    }

    public Long getRemoteSTARTCHANNELTotalCount() {
        return this.delegate.getRemoteSTARTCHANNELTotalCount();
    }

    public Long getRemoteSTARTCHANNELDataLength() {
        return this.delegate.getRemoteSTARTCHANNELDataLength();
    }

    public String getL9CPUTime() {
        return this.delegate.getL9CPUTime();
    }

    public Long getCurrentDispatcherTCBs() {
        return this.delegate.getCurrentDispatcherTCBs();
    }

    public Long getRepositoryReadDataLength() {
        return this.delegate.getRepositoryReadDataLength();
    }

    public Long getRepositoryWriteDataLength() {
        return this.delegate.getRepositoryWriteDataLength();
    }

    public Long getChannelContainerCreateCount() {
        return this.delegate.getChannelContainerCreateCount();
    }

    public Long getDocumentDeleteCount() {
        return this.delegate.getDocumentDeleteCount();
    }

    public Long getCurrentContainerStorage() {
        return this.delegate.getCurrentContainerStorage();
    }

    public Long getMaxContainerStorage() {
        return this.delegate.getMaxContainerStorage();
    }

    public Long getAssociatedIPFacilitiesCount() {
        return this.delegate.getAssociatedIPFacilitiesCount();
    }

    public String getOriginNetID() {
        return this.delegate.getOriginNetID();
    }

    public String getOriginTaskID() {
        return this.delegate.getOriginTaskID();
    }

    public Date getOriginStartTime() {
        return this.delegate.getOriginStartTime();
    }

    public String getOriginAPPLID() {
        return this.delegate.getOriginAPPLID();
    }

    public String getOriginTransID() {
        return this.delegate.getOriginTransID();
    }

    public String getOriginUserID() {
        return this.delegate.getOriginUserID();
    }

    public String getOriginUserCorrelation() {
        return this.delegate.getOriginUserCorrelation();
    }

    public String getOriginTCPIPSERVICE() {
        return this.delegate.getOriginTCPIPSERVICE();
    }

    public Long getOriginPort() {
        return this.delegate.getOriginPort();
    }

    public String getOriginClientIP() {
        return this.delegate.getOriginClientIP();
    }

    public Long getOriginClientPort() {
        return this.delegate.getOriginClientPort();
    }

    public String getOriginTransFlags() {
        return this.delegate.getOriginTransFlags();
    }

    public String getOriginFacility() {
        return this.delegate.getOriginFacility();
    }

    public Long getWMQRequestTotalCount() {
        return this.delegate.getWMQRequestTotalCount();
    }

    public String getWMQGETWAITTime() {
        return this.delegate.getWMQGETWAITTime();
    }

    public Long getClientPort() {
        return this.delegate.getClientPort();
    }

    public String getIPCONNName() {
        return this.delegate.getIPCONNName();
    }

    public Long getIPCONNAllocateCount() {
        return this.delegate.getIPCONNAllocateCount();
    }

    public String getIPCONNIOWaitTime() {
        return this.delegate.getIPCONNIOWaitTime();
    }

    public String getJVMServerThreadWaitTime() {
        return this.delegate.getJVMServerThreadWaitTime();
    }

    public Long getEXECCICSXMLTRANSFORMCount() {
        return this.delegate.getEXECCICSXMLTRANSFORMCount();
    }

    public Long getWSACONTEXTBUILDCount() {
        return this.delegate.getWSACONTEXTBUILDCount();
    }

    public Long getWSACONTEXTGETCount() {
        return this.delegate.getWSACONTEXTGETCount();
    }

    public Long getWSAEPRCreateCount() {
        return this.delegate.getWSAEPRCreateCount();
    }

    public Long getWSAddressingRequestCount() {
        return this.delegate.getWSAddressingRequestCount();
    }

    public String getT8CPUTime() {
        return this.delegate.getT8CPUTime();
    }

    public String getMaxThreadTCBDelayTime() {
        return this.delegate.getMaxThreadTCBDelayTime();
    }

    public Long getTotalEXECCICSCount() {
        return this.delegate.getTotalEXECCICSCount();
    }

    public Long getSIGNALEVENTCount() {
        return this.delegate.getSIGNALEVENTCount();
    }

    public Long getEVENTFilterCount() {
        return this.delegate.getEVENTFilterCount();
    }

    public Long getEVENTCapturedCount() {
        return this.delegate.getEVENTCapturedCount();
    }

    public String getURIMapName() {
        return this.delegate.getURIMapName();
    }

    public String getPipelineName() {
        return this.delegate.getPipelineName();
    }

    public String getAtomServiceName() {
        return this.delegate.getAtomServiceName();
    }

    public String getWebserviceName() {
        return this.delegate.getWebserviceName();
    }

    public String getProgramName() {
        return this.delegate.getProgramName();
    }

    public Long getEXECCICSASKTIMECount() {
        return this.delegate.getEXECCICSASKTIMECount();
    }

    public Long getEXECCICSXxxTIMECount() {
        return this.delegate.getEXECCICSXxxTIMECount();
    }

    public Long getBIFDIGESTCount() {
        return this.delegate.getBIFDIGESTCount();
    }

    public Long getBIFCount() {
        return this.delegate.getBIFCount();
    }

    public Long getTotalDocumentLength() {
        return this.delegate.getTotalDocumentLength();
    }

    public String getXMLSSCPUTime() {
        return this.delegate.getXMLSSCPUTime();
    }

    public String getWebServicesOperationName() {
        return this.delegate.getWebServicesOperationName();
    }

    public String getWMQAPISRBTime() {
        return this.delegate.getWMQAPISRBTime();
    }

    public Long getSyncEmissionEVENTCapturedCount() {
        return this.delegate.getSyncEmissionEVENTCapturedCount();
    }

    public String getTDIntraLockTime() {
        return this.delegate.getTDIntraLockTime();
    }

    public String getTDExtraLockTime() {
        return this.delegate.getTDExtraLockTime();
    }

    public String getRODelayTime() {
        return this.delegate.getRODelayTime();
    }

    public String getSODelayTime() {
        return this.delegate.getSODelayTime();
    }

    public String getSessionAllocationWaitTime() {
        return this.delegate.getSessionAllocationWaitTime();
    }

    public String getISAllocateWaitTime() {
        return this.delegate.getISAllocateWaitTime();
    }

    public String getCipherSelected() {
        return this.delegate.getCipherSelected();
    }

    public Long getMaxTasks() {
        return this.delegate.getMaxTasks();
    }

    public Long getCurrentTasks() {
        return this.delegate.getCurrentTasks();
    }

    public String getCECMachineType() {
        return this.delegate.getCECMachineType();
    }

    public String getCECModel() {
        return this.delegate.getCECModel();
    }

    public Long getGETMAINRequestsGCDSA() {
        return this.delegate.getGETMAINRequestsGCDSA();
    }

    public Long getPeakStorageGCDSA() {
        return this.delegate.getPeakStorageGCDSA();
    }

    public Long getGETMAINRequestsGUDSA() {
        return this.delegate.getGETMAINRequestsGUDSA();
    }

    public Long getPeakStorageGUDSA() {
        return this.delegate.getPeakStorageGUDSA();
    }

    public Long getGETMAINRequestsAbove2GB() {
        return this.delegate.getGETMAINRequestsAbove2GB();
    }

    public Long getGETMAINBytesAbove2GB() {
        return this.delegate.getGETMAINBytesAbove2GB();
    }

    public Long getFREEMAINBytesAbove2GB() {
        return this.delegate.getFREEMAINBytesAbove2GB();
    }

    public String getFileExclusiveControlWaitTime() {
        return this.delegate.getFileExclusiveControlWaitTime();
    }

    public String getFileVSAMStringWaitTime() {
        return this.delegate.getFileVSAMStringWaitTime();
    }

    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    public String getApplicationPlatformName() {
        return this.delegate.getApplicationPlatformName();
    }

    public String getApplicationOperationName() {
        return this.delegate.getApplicationOperationName();
    }

    public Long getApplicationMajorVersion() {
        return this.delegate.getApplicationMajorVersion();
    }

    public Long getApplicationMinorVersion() {
        return this.delegate.getApplicationMinorVersion();
    }

    public Long getApplicationMicroVersion() {
        return this.delegate.getApplicationMicroVersion();
    }

    public String getCPUTimeOnCP() {
        return this.delegate.getCPUTimeOnCP();
    }

    public String getOffloadEligibleCPUTimeOnStandardCP() {
        return this.delegate.getOffloadEligibleCPUTimeOnStandardCP();
    }

    public Long getThresholdCount() {
        return this.delegate.getThresholdCount();
    }

    public Long getGCDSAPeakBytes() {
        return this.delegate.getGCDSAPeakBytes();
    }

    public Long getGUDSAPeakBytes() {
        return this.delegate.getGUDSAPeakBytes();
    }

    public Long getWbsfcrct() {
        return this.delegate.getWbsfcrct();
    }

    public Long getWbsftoct() {
        return this.delegate.getWbsftoct();
    }

    public Long getWbissfct() {
        return this.delegate.getWbissfct();
    }

    public Long getWbsreqbl() {
        return this.delegate.getWbsreqbl();
    }

    public Long getWbsrspbl() {
        return this.delegate.getWbsrspbl();
    }

    public Long getTSGetSHAREDCount() {
        return this.delegate.getTSGetSHAREDCount();
    }

    public Long getTSPutSHAREDCount() {
        return this.delegate.getTSPutSHAREDCount();
    }

    public Long getNamedCounterGetCount() {
        return this.delegate.getNamedCounterGetCount();
    }

    public Long getJSONRequestBodyLength() {
        return this.delegate.getJSONRequestBodyLength();
    }

    public Long getJSONResponseBodyLength() {
        return this.delegate.getJSONResponseBodyLength();
    }

    public String getPthreadAllocationWaitTime() {
        return this.delegate.getPthreadAllocationWaitTime();
    }

    public Long getTotalAsychronousAPICommands() {
        return this.delegate.getTotalAsychronousAPICommands();
    }

    public Long getEXECCICSRUNTRANSIDCount() {
        return this.delegate.getEXECCICSRUNTRANSIDCount();
    }

    public Long getEXECCICSFETCHCount() {
        return this.delegate.getEXECCICSFETCHCount();
    }

    public Long getEXECCICSFREECount() {
        return this.delegate.getEXECCICSFREECount();
    }

    public String getASFetchWaitTime() {
        return this.delegate.getASFetchWaitTime();
    }

    public String getASRunDelayedTime() {
        return this.delegate.getASRunDelayedTime();
    }

    public Long getSystemRuleEvaluationCount() {
        return this.delegate.getSystemRuleEvaluationCount();
    }

    public Long getSystemRuleActionCount() {
        return this.delegate.getSystemRuleActionCount();
    }

    public String getLPARName() {
        return this.delegate.getLPARName();
    }

    public String getNewSocketConnectionMessage() {
        return this.delegate.getNewSocketConnectionMessage();
    }

    public String getNodeJSApplicationName() {
        return this.delegate.getNodeJSApplicationName();
    }

    public String getMVSSOSWaitTime() {
        return this.delegate.getMVSSOSWaitTime();
    }

    public String getSotlslvl() {
        return this.delegate.getSotlslvl();
    }

    public String getSoflag() {
        return this.delegate.getSoflag();
    }

    public ITask.SrrstatusValue getSrrstatus() {
        String result = this.record.get("SRRSTATUS");
        if (result == null) {
            return this.delegate.getSrrstatus();
        }
        return (ITask.SrrstatusValue)((CICSAttribute)TaskType.SRRSTATUS).get(result, this.record.getNormalizers());
    }

    public Long getSocketCount() {
        return this.delegate.getSocketCount();
    }

    public Long getSocketHWM() {
        return this.delegate.getSocketHWM();
    }

    public Long getNumberOfSockets() {
        return this.delegate.getNumberOfSockets();
    }

    public void setPriority(Long _priority) {
        if (_priority.equals(this.delegate.getPriority())) {
            this.record.set("PRIORITY", null);
        } else {
            TaskType.PRIORITY.validate((Object)_priority);
            String connectionSpecificExternalValue = ((CICSAttribute)TaskType.PRIORITY).set(_priority, this.record.getNormalizers());
            this.record.set("PRIORITY", connectionSpecificExternalValue);
        }
    }

    public void setPurgeType(ITask.PurgeTypeValue _purgeType) {
        if (_purgeType.equals((Object)this.delegate.getPurgeType())) {
            this.record.set("PURGETYPE", null);
        } else {
            TaskType.PURGE_TYPE.validate((Object)_purgeType);
            String connectionSpecificExternalValue = ((CICSAttribute)TaskType.PURGE_TYPE).set(_purgeType, this.record.getNormalizers());
            this.record.set("PURGETYPE", connectionSpecificExternalValue);
        }
    }

    public void setSrrstatus(ITask.SrrstatusValue _srrstatus) {
        if (_srrstatus.equals((Object)this.delegate.getSrrstatus())) {
            this.record.set("SRRSTATUS", null);
        } else {
            TaskType.SRRSTATUS.validate((Object)_srrstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)TaskType.SRRSTATUS).set(_srrstatus, this.record.getNormalizers());
            this.record.set("SRRSTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TaskType.TASK_ID) {
            return (V)this.getTaskID();
        }
        if (attribute == TaskType.PRINCIPAL_FACILITY) {
            return (V)this.getPrincipalFacility();
        }
        if (attribute == TaskType.FACILITY_TYPE) {
            return (V)this.getFacilityType();
        }
        if (attribute == TaskType.CURRENT_SUSPEND_TIME) {
            return (V)this.getCurrentSuspendTime();
        }
        if (attribute == TaskType.SUSPEND_REASON) {
            return (V)this.getSuspendReason();
        }
        if (attribute == TaskType.SUSPENDED_FOR_RESOURCE) {
            return (V)this.getSuspendedForResource();
        }
        if (attribute == TaskType.PRIORITY) {
            return (V)this.getPriority();
        }
        if (attribute == TaskType.LOCAL_UOWID2) {
            return (V)this.getLocalUOWID2();
        }
        if (attribute == TaskType.RUN_STATUS) {
            return (V)this.getRunStatus();
        }
        if (attribute == TaskType.CLASS_NAME) {
            return (V)this.getClassName();
        }
        if (attribute == TaskType.TRANSACTION_ID) {
            return (V)this.getTransactionID();
        }
        if (attribute == TaskType.USER_ID) {
            return (V)this.getUserID();
        }
        if (attribute == TaskType.TRANSACTION_TYPE) {
            return (V)this.getTransactionType();
        }
        if (attribute == TaskType.RECORD_TYPE) {
            return (V)this.getRecordType();
        }
        if (attribute == TaskType.START_TIME) {
            return (V)this.getStartTime();
        }
        if (attribute == TaskType.STOP_TIME) {
            return (V)this.getStopTime();
        }
        if (attribute == TaskType.LU_NAME) {
            return (V)this.getLUName();
        }
        if (attribute == TaskType.FIRST_PROGRAM) {
            return (V)this.getFirstProgram();
        }
        if (attribute == TaskType.ORIGIN_SYSTEM_NETNAME) {
            return (V)this.getOriginSystemNetname();
        }
        if (attribute == TaskType.ERROR_FLAGS) {
            return (V)this.getErrorFlags();
        }
        if (attribute == TaskType.ORIGINAL_ABEND_CODE) {
            return (V)this.getOriginalABENDCode();
        }
        if (attribute == TaskType.CURRENT_ABEND_CODE) {
            return (V)this.getCurrentABENDCode();
        }
        if (attribute == TaskType.RECVD_PRIMARY_TC_MSGS) {
            return (V)this.getRecvdPrimaryTCMsgs();
        }
        if (attribute == TaskType.RECVD_PRIMARY_TC_CHARS) {
            return (V)this.getRecvdPrimaryTCChars();
        }
        if (attribute == TaskType.SENT_PRIMARY_TC_MSGS) {
            return (V)this.getSentPrimaryTCMsgs();
        }
        if (attribute == TaskType.SENT_PRIMARY_TC_CHARS) {
            return (V)this.getSentPrimaryTCChars();
        }
        if (attribute == TaskType.RECVD_SECONDARY_TC_MSGS) {
            return (V)this.getRecvdSecondaryTCMsgs();
        }
        if (attribute == TaskType.RECVD_SECONDARY_TC_CHARS) {
            return (V)this.getRecvdSecondaryTCChars();
        }
        if (attribute == TaskType.SENT_SECONDARY_TC_MSGS) {
            return (V)this.getSentSecondaryTCMsgs();
        }
        if (attribute == TaskType.SENT_SECONDARY_TC_CHARS) {
            return (V)this.getSentSecondaryTCChars();
        }
        if (attribute == TaskType.ALLOCATE_REQUEST_COUNT) {
            return (V)this.getALLOCATERequestCount();
        }
        if (attribute == TaskType.USER_GETMAIN_REQUESTS_BELOW_16MB) {
            return (V)this.getUserGETMAINRequestsBelow16MB();
        }
        if (attribute == TaskType.USER_GETMAIN_REQUESTS_ABOVE_16MB) {
            return (V)this.getUserGETMAINRequestsAbove16MB();
        }
        if (attribute == TaskType.CDSA_REQUEST_GETMAIN) {
            return (V)this.getCDSARequestGETMAIN();
        }
        if (attribute == TaskType.GETMAIN_REQUESTS_ECDSA) {
            return (V)this.getGETMAINRequestsECDSA();
        }
        if (attribute == TaskType.UDSA_PEAK_BYTES) {
            return (V)this.getUDSAPeakBytes();
        }
        if (attribute == TaskType.EUDSA_PEAK_BYTES) {
            return (V)this.getEUDSAPeakBytes();
        }
        if (attribute == TaskType.CDSA_TASK_PEAK_BYTES) {
            return (V)this.getCDSATaskPeakBytes();
        }
        if (attribute == TaskType.PEAK_BYTES_ECDSA) {
            return (V)this.getPeakBytesECDSA();
        }
        if (attribute == TaskType.AVG_STORAGE_USAGE_BELOW_16MB) {
            return (V)this.getAvgStorageUsageBelow16MB();
        }
        if (attribute == TaskType.AVG_STORAGE_USAGE_ABOVE_16MB) {
            return (V)this.getAvgStorageUsageAbove16MB();
        }
        if (attribute == TaskType.AVG_CDSA_STORAGE) {
            return (V)this.getAvgCDSAStorage();
        }
        if (attribute == TaskType.AVERAGE_STORAGE_ECDSA) {
            return (V)this.getAverageStorageECDSA();
        }
        if (attribute == TaskType.MAX_PROG_STORAGE_ALL_DS_AS) {
            return (V)this.getMaxProgStorageAllDSAs();
        }
        if (attribute == TaskType.MAX_PROG_STORAGE_BELOW_16MB) {
            return (V)this.getMaxProgStorageBelow16MB();
        }
        if (attribute == TaskType.MAX_PROG_STORAGE_ABOVE_16MB) {
            return (V)this.getMaxProgStorageAbove16MB();
        }
        if (attribute == TaskType.MAX_EUDSA_PROGRAM_STORAGE) {
            return (V)this.getMaxEUDSAProgramStorage();
        }
        if (attribute == TaskType.MAX_UDSA_PROGRAM_STORAGE) {
            return (V)this.getMaxUDSAProgramStorage();
        }
        if (attribute == TaskType.MAX_PROG_STORAGE_ECDSA) {
            return (V)this.getMaxProgStorageECDSA();
        }
        if (attribute == TaskType.CDSA_MAX_PROGRAM_STORAGE) {
            return (V)this.getCDSAMaxProgramStorage();
        }
        if (attribute == TaskType.MAX_STORAGE_ERDSA) {
            return (V)this.getMaxStorageERDSA();
        }
        if (attribute == TaskType.FILE_READ_COUNT) {
            return (V)this.getFileREADCount();
        }
        if (attribute == TaskType.FILE_REWRITE_COUNT) {
            return (V)this.getFileREWRITECount();
        }
        if (attribute == TaskType.FILE_BROWSE_COUNT) {
            return (V)this.getFileBrowseCount();
        }
        if (attribute == TaskType.FILE_WRITE_COUNT) {
            return (V)this.getFileWRITECount();
        }
        if (attribute == TaskType.FILE_DELETE_COUNT) {
            return (V)this.getFileDELETECount();
        }
        if (attribute == TaskType.TOTAL_FILE_CONTROL_COUNT) {
            return (V)this.getTotalFileControlCount();
        }
        if (attribute == TaskType.FILE_ACCESS_COUNT) {
            return (V)this.getFileAccessCount();
        }
        if (attribute == TaskType.TD_GET_COUNT) {
            return (V)this.getTDGetCount();
        }
        if (attribute == TaskType.TD_PUT_COUNT) {
            return (V)this.getTDPutCount();
        }
        if (attribute == TaskType.TD_PURGE_COUNT) {
            return (V)this.getTDPurgeCount();
        }
        if (attribute == TaskType.TOTAL_TD_COUNT) {
            return (V)this.getTotalTDCount();
        }
        if (attribute == TaskType.TS_GET_COUNT) {
            return (V)this.getTSGetCount();
        }
        if (attribute == TaskType.TS_PUT_AUX_COUNT) {
            return (V)this.getTSPutAUXCount();
        }
        if (attribute == TaskType.TS_PUT_MAIN_COUNT) {
            return (V)this.getTSPutMAINCount();
        }
        if (attribute == TaskType.TS_REQUEST_COUNT) {
            return (V)this.getTSRequestCount();
        }
        if (attribute == TaskType.BMS_MAP) {
            return (V)this.getBMSMap();
        }
        if (attribute == TaskType.BMS_MAP_IN) {
            return (V)this.getBMSMapIn();
        }
        if (attribute == TaskType.BMS_MAP_OUT) {
            return (V)this.getBMSMapOut();
        }
        if (attribute == TaskType.BMS_TOTAL) {
            return (V)this.getBMSTotal();
        }
        if (attribute == TaskType.LINK_COUNT) {
            return (V)this.getLINKCount();
        }
        if (attribute == TaskType.XCTL_COUNT) {
            return (V)this.getXCTLCount();
        }
        if (attribute == TaskType.PROGRAM_LOAD_COUNT) {
            return (V)this.getProgramLoadCount();
        }
        if (attribute == TaskType.ICSTART_COUNT) {
            return (V)this.getICSTARTCount();
        }
        if (attribute == TaskType.SYNCPOINT_COUNT) {
            return (V)this.getSyncpointCount();
        }
        if (attribute == TaskType.DISPATCH_TIME) {
            return (V)this.getDispatchTime();
        }
        if (attribute == TaskType.CPU_TIME) {
            return (V)this.getCPUTime();
        }
        if (attribute == TaskType.TASK_SUSPEND_TIME) {
            return (V)this.getTaskSuspendTime();
        }
        if (attribute == TaskType.DISPATCH_WAIT_TIME) {
            return (V)this.getDispatchWaitTime();
        }
        if (attribute == TaskType.EXCEPTION_WAIT_TIME) {
            return (V)this.getExceptionWaitTime();
        }
        if (attribute == TaskType.TERMINAL_IO_WAIT_TIME) {
            return (V)this.getTerminalIOWaitTime();
        }
        if (attribute == TaskType.FILE_IO_WAIT_TIME) {
            return (V)this.getFileIOWaitTime();
        }
        if (attribute == TaskType.JOURNAL_IO_WAIT_TIME) {
            return (V)this.getJournalIOWaitTime();
        }
        if (attribute == TaskType.TSIO_WAIT_TIME) {
            return (V)this.getTSIOWaitTime();
        }
        if (attribute == TaskType.IRCIO_WAIT_TIME) {
            return (V)this.getIRCIOWaitTime();
        }
        if (attribute == TaskType.TDIO_WAIT_TIME) {
            return (V)this.getTDIOWaitTime();
        }
        if (attribute == TaskType.PROGRAM_LOAD_TIME) {
            return (V)this.getProgramLoadTime();
        }
        if (attribute == TaskType.START_CODE) {
            return (V)this.getStartCode();
        }
        if (attribute == TaskType.COMMAND_SECURITY) {
            return (V)this.getCommandSecurity();
        }
        if (attribute == TaskType.DTB) {
            return (V)this.getDTB();
        }
        if (attribute == TaskType.DEADLOCK_TIMEOUT) {
            return (V)this.getDeadlockTimeout();
        }
        if (attribute == TaskType.TRANSACTION_DUMP) {
            return (V)this.getTransactionDump();
        }
        if (attribute == TaskType.DATA_ISOLATION_TYPE) {
            return (V)this.getDataIsolationType();
        }
        if (attribute == TaskType.TASK_PROFILE) {
            return (V)this.getTaskProfile();
        }
        if (attribute == TaskType.PURGEABILITY) {
            return (V)this.getPurgeability();
        }
        if (attribute == TaskType.ROUTING_TYPE) {
            return (V)this.getRoutingType();
        }
        if (attribute == TaskType.RESOURCE_SECURITY) {
            return (V)this.getResourceSecurity();
        }
        if (attribute == TaskType.READ_TIMEOUT) {
            return (V)this.getReadTimeout();
        }
        if (attribute == TaskType.RUNAWAY_TASK_TIME) {
            return (V)this.getRunawayTaskTime();
        }
        if (attribute == TaskType.SCREEN_SIZE) {
            return (V)this.getScreenSize();
        }
        if (attribute == TaskType.STORAGE_CLEARANCE_STATUS) {
            return (V)this.getStorageClearanceStatus();
        }
        if (attribute == TaskType.DATA_STORAGE_KEY) {
            return (V)this.getDataStorageKey();
        }
        if (attribute == TaskType.DATA_LOCATION) {
            return (V)this.getDataLocation();
        }
        if (attribute == TaskType.TASK_TRACING_TYPE) {
            return (V)this.getTaskTracingType();
        }
        if (attribute == TaskType.TRANSACTION_PRIORITY) {
            return (V)this.getTransactionPriority();
        }
        if (attribute == TaskType.TRANSACTION_ROUTING_PROFILE_NAME) {
            return (V)this.getTransactionRoutingProfileName();
        }
        if (attribute == TaskType.TWA_BYTES) {
            return (V)this.getTWABytes();
        }
        if (attribute == TaskType.REMOTE_TRANSACTION) {
            return (V)this.getRemoteTransaction();
        }
        if (attribute == TaskType.REMOTE_SYSTEM_ID) {
            return (V)this.getRemoteSystemID();
        }
        if (attribute == TaskType.RECVD_SECONDARY_LU62_MESSAGES) {
            return (V)this.getRecvdSecondaryLU62Messages();
        }
        if (attribute == TaskType.SECONDARY_LU62_CHAR_RECEIVE_COUNT) {
            return (V)this.getSecondaryLU62CharReceiveCount();
        }
        if (attribute == TaskType.SENT_SECONDARY_LU62_MESSAGE) {
            return (V)this.getSentSecondaryLU62Message();
        }
        if (attribute == TaskType.SECONDARY_LU62_CHAR_SEND_COUNT) {
            return (V)this.getSecondaryLU62CharSendCount();
        }
        if (attribute == TaskType.MAX_RDSA_READ_ONLY_STORAGE) {
            return (V)this.getMaxRDSAReadOnlyStorage();
        }
        if (attribute == TaskType.MAX_ESDSA_SHARED_STORAGE) {
            return (V)this.getMaxESDSASharedStorage();
        }
        if (attribute == TaskType.MAX_SDSA_SHARED_STORAGE) {
            return (V)this.getMaxSDSASharedStorage();
        }
        if (attribute == TaskType.FEPI_ALLOCATE_REQUEST_COUNT) {
            return (V)this.getFEPIAllocateRequestCount();
        }
        if (attribute == TaskType.FEPI_RECEIVE_COUNT) {
            return (V)this.getFEPIReceiveCount();
        }
        if (attribute == TaskType.FEPI_SEND_COUNT) {
            return (V)this.getFEPISendCount();
        }
        if (attribute == TaskType.FEPI_START_COUNT) {
            return (V)this.getFEPIStartCount();
        }
        if (attribute == TaskType.FEPI_CHAR_SEND_COUNT) {
            return (V)this.getFEPICharSendCount();
        }
        if (attribute == TaskType.FEPI_CHAR_RECEIVE_COUNT) {
            return (V)this.getFEPICharReceiveCount();
        }
        if (attribute == TaskType.FEPI_ALLOCATE_TIMEOUT_COUNT) {
            return (V)this.getFEPIAllocateTimeoutCount();
        }
        if (attribute == TaskType.FEPI_RECEIVE_TIMEOUT_COUNT) {
            return (V)this.getFEPIReceiveTimeoutCount();
        }
        if (attribute == TaskType.FEPI_TOTAL_COUNT) {
            return (V)this.getFEPITotalCount();
        }
        if (attribute == TaskType.FEPI_SUSPEND_TIME) {
            return (V)this.getFEPISuspendTime();
        }
        if (attribute == TaskType.DISPATCH_DELAY_TIME) {
            return (V)this.getDispatchDelayTime();
        }
        if (attribute == TaskType.TCL_DELAY_TIME) {
            return (V)this.getTCLDelayTime();
        }
        if (attribute == TaskType.MXT_LIMIT_1_ST_DISPATCH_DELAY_TIME) {
            return (V)this.getMXTLimit1stDispatchDelayTime();
        }
        if (attribute == TaskType.ENQUEUE_DELAY) {
            return (V)this.getEnqueueDelay();
        }
        if (attribute == TaskType.LU61IO_WAIT_TIME) {
            return (V)this.getLU61IOWaitTime();
        }
        if (attribute == TaskType.LU62IO_WAIT_TIME) {
            return (V)this.getLU62IOWaitTime();
        }
        if (attribute == TaskType.RMI_TOTAL_TIME) {
            return (V)this.getRMITotalTime();
        }
        if (attribute == TaskType.RMI_SUSPEND_TIME) {
            return (V)this.getRMISuspendTime();
        }
        if (attribute == TaskType.PERFORMANCE_RECORD_COUNT) {
            return (V)this.getPerformanceRecordCount();
        }
        if (attribute == TaskType.RECOVERY_MANAGER_UOWID) {
            return (V)this.getRecoveryManagerUOWID();
        }
        if (attribute == TaskType.WLM_SERVICE_CLASS_NAME) {
            return (V)this.getWLMServiceClassName();
        }
        if (attribute == TaskType.WLM_REPORT_CLASS_NAME) {
            return (V)this.getWLMReportClassName();
        }
        if (attribute == TaskType.TRANSACTION_FLAGS) {
            return (V)this.getTransactionFlags();
        }
        if (attribute == TaskType.TERMINAL_CONNECTION_NAME) {
            return (V)this.getTerminalConnectionName();
        }
        if (attribute == TaskType.GETMAIN_REQUESTS_BELOW_16MB) {
            return (V)this.getGETMAINRequestsBelow16MB();
        }
        if (attribute == TaskType.GETMAIN_BYTES_BELOW_16MB) {
            return (V)this.getGETMAINBytesBelow16MB();
        }
        if (attribute == TaskType.FREEMAIN_BYTES_BELOW_16MB) {
            return (V)this.getFREEMAINBytesBelow16MB();
        }
        if (attribute == TaskType.GETMAIN_REQUESTS_ABOVE_16MB) {
            return (V)this.getGETMAINRequestsAbove16MB();
        }
        if (attribute == TaskType.GETMAIN_BYTES_ABOVE_16MB) {
            return (V)this.getGETMAINBytesAbove16MB();
        }
        if (attribute == TaskType.FREEMAIN_BYTES_ABOVE_16MB) {
            return (V)this.getFREEMAINBytesAbove16MB();
        }
        if (attribute == TaskType.JOURNAL_WRITE_COUNT) {
            return (V)this.getJournalWriteCount();
        }
        if (attribute == TaskType.CICS_LOGGER_WRITE_COUNT) {
            return (V)this.getCICSLoggerWriteCount();
        }
        if (attribute == TaskType.SYNCPOINT_WAIT_TIME) {
            return (V)this.getSyncpointWaitTime();
        }
        if (attribute == TaskType.VSAM_RECORD_SHARING_WAIT_TIME) {
            return (V)this.getVSAMRecordSharingWaitTime();
        }
        if (attribute == TaskType.TERMINAL_INFORMATION) {
            return (V)this.getTerminalInformation();
        }
        if (attribute == TaskType.ATTACH_TIME) {
            return (V)this.getAttachTime();
        }
        if (attribute == TaskType.UOWID) {
            return (V)this.getUOWID();
        }
        if (attribute == TaskType.INDOUBT_ACTION) {
            return (V)this.getIndoubtAction();
        }
        if (attribute == TaskType.INDOUBT_TIME) {
            return (V)this.getIndoubtTime();
        }
        if (attribute == TaskType.INDOUBT_WAIT) {
            return (V)this.getIndoubtWait();
        }
        if (attribute == TaskType.BRIDGE_TRANSACTION_ID) {
            return (V)this.getBridgeTransactionID();
        }
        if (attribute == TaskType.STARTED_BY_BRIDGE) {
            return (V)this.getStartedByBridge();
        }
        if (attribute == TaskType.LOCK_MANAGER_WAIT_TIME) {
            return (V)this.getLockManagerWaitTime();
        }
        if (attribute == TaskType.EXTERNAL_WAIT_TIME) {
            return (V)this.getExternalWaitTime();
        }
        if (attribute == TaskType.CICS_EVENT_WAIT) {
            return (V)this.getCICSEventWait();
        }
        if (attribute == TaskType.IC_DELAY) {
            return (V)this.getICDelay();
        }
        if (attribute == TaskType.CONTROL_WAIT_TIME) {
            return (V)this.getControlWaitTime();
        }
        if (attribute == TaskType.SHARED_TS_WAIT_TIME) {
            return (V)this.getSharedTSWaitTime();
        }
        if (attribute == TaskType.VSAM_RECORD_SHARING_CPU_TIME) {
            return (V)this.getVSAMRecordSharingCPUTime();
        }
        if (attribute == TaskType.TOTAL_IC_COUNT) {
            return (V)this.getTotalICCount();
        }
        if (attribute == TaskType.BRIDGE_IDENTIFIER) {
            return (V)this.getBridgeIdentifier();
        }
        if (attribute == TaskType.URM_LINK_COUNT) {
            return (V)this.getURMLinkCount();
        }
        if (attribute == TaskType.DB2_PLAN_NAME) {
            return (V)this.getDB2PlanName();
        }
        if (attribute == TaskType.CFDT_WAIT_TIME) {
            return (V)this.getCFDTWaitTime();
        }
        if (attribute == TaskType.CFDT_SYNC_WAIT_TIME) {
            return (V)this.getCFDTSyncWaitTime();
        }
        if (attribute == TaskType.TCB_TYPE) {
            return (V)this.getTCBType();
        }
        if (attribute == TaskType.BTS_PROCESS_NAME) {
            return (V)this.getBTSProcessName();
        }
        if (attribute == TaskType.BTS_PROCESS_ID) {
            return (V)this.getBTSProcessID();
        }
        if (attribute == TaskType.BTS_PROCESS_TYPE) {
            return (V)this.getBTSProcessType();
        }
        if (attribute == TaskType.ACTIVITY_NAME) {
            return (V)this.getActivityName();
        }
        if (attribute == TaskType.ACTIVITY_ID) {
            return (V)this.getActivityID();
        }
        if (attribute == TaskType.BTS_RUN_SYNC) {
            return (V)this.getBTSRunSync();
        }
        if (attribute == TaskType.BTS_RUN_ASYNC) {
            return (V)this.getBTSRunAsync();
        }
        if (attribute == TaskType.BTS_LINK) {
            return (V)this.getBTSLink();
        }
        if (attribute == TaskType.BTS_DEFINE_PROCESS) {
            return (V)this.getBTSDefineProcess();
        }
        if (attribute == TaskType.BTS_DEFINE_ACTIVITY) {
            return (V)this.getBTSDefineActivity();
        }
        if (attribute == TaskType.BTS_RESET) {
            return (V)this.getBTSReset();
        }
        if (attribute == TaskType.BTS_SUSPEND) {
            return (V)this.getBTSSuspend();
        }
        if (attribute == TaskType.BTS_RESUME) {
            return (V)this.getBTSResume();
        }
        if (attribute == TaskType.BTS_DELETE_AND_CANCEL) {
            return (V)this.getBTSDeleteAndCancel();
        }
        if (attribute == TaskType.BTS_ACQUIRE) {
            return (V)this.getBTSAcquire();
        }
        if (attribute == TaskType.BTS_TOTAL) {
            return (V)this.getBTSTotal();
        }
        if (attribute == TaskType.BTS_PROCESS_DATA_CONTAINER) {
            return (V)this.getBTSProcessDataContainer();
        }
        if (attribute == TaskType.BTS_ACTIVITY_DATA_CONTAINER) {
            return (V)this.getBTSActivityDataContainer();
        }
        if (attribute == TaskType.BTS_TOTAL_DATA_CONTAINER) {
            return (V)this.getBTSTotalDataContainer();
        }
        if (attribute == TaskType.BTS_RETRIEVE_REATTACH_EVENT) {
            return (V)this.getBTSRetrieveReattachEvent();
        }
        if (attribute == TaskType.BTS_DEFINE_INPUT_EVENT) {
            return (V)this.getBTSDefineInputEvent();
        }
        if (attribute == TaskType.BTS_TIMER_ASSOC) {
            return (V)this.getBTSTimerAssoc();
        }
        if (attribute == TaskType.BTS_TOTAL_EVENT) {
            return (V)this.getBTSTotalEvent();
        }
        if (attribute == TaskType.BTS_RUN_SYNC_WAIT_TIME) {
            return (V)this.getBTSRunSyncWaitTime();
        }
        if (attribute == TaskType.PARENT_SYNCPOINT_WAIT_TIME) {
            return (V)this.getParentSyncpointWaitTime();
        }
        if (attribute == TaskType.WEB_RECEIVE_COUNT_2) {
            return (V)this.getWEBReceiveCount2();
        }
        if (attribute == TaskType.RECVD_WEB_CHARS) {
            return (V)this.getRecvdWEBChars();
        }
        if (attribute == TaskType.WEB_SEND_COUNT_2) {
            return (V)this.getWEBSendCount2();
        }
        if (attribute == TaskType.SENT_WEB_CHARS) {
            return (V)this.getSentWEBChars();
        }
        if (attribute == TaskType.WEB_TOTAL_COUNT) {
            return (V)this.getWEBTotalCount();
        }
        if (attribute == TaskType.WEB_REPOSITORY_WRITE_COUNT) {
            return (V)this.getWEBRepositoryWriteCount();
        }
        if (attribute == TaskType.DOC_CREATES) {
            return (V)this.getDocCreates();
        }
        if (attribute == TaskType.DOC_INSERTS) {
            return (V)this.getDocInserts();
        }
        if (attribute == TaskType.DOC_SETS) {
            return (V)this.getDocSets();
        }
        if (attribute == TaskType.DOC_RETRIEVES) {
            return (V)this.getDocRetrieves();
        }
        if (attribute == TaskType.TOTAL_DOC_REQUESTS) {
            return (V)this.getTotalDocRequests();
        }
        if (attribute == TaskType.TOTAL_DOC_LENGTH) {
            return (V)this.getTotalDocLength();
        }
        if (attribute == TaskType.IMS_WAIT_TIME) {
            return (V)this.getIMSWaitTime();
        }
        if (attribute == TaskType.DB2_READY_Q_WAIT_TIME) {
            return (V)this.getDB2ReadyQWaitTime();
        }
        if (attribute == TaskType.DB2_CONN_WAIT_TIME) {
            return (V)this.getDB2ConnWaitTime();
        }
        if (attribute == TaskType.DB2_WAIT_TIME) {
            return (V)this.getDB2WaitTime();
        }
        if (attribute == TaskType.MAX_OPEN_TCB_DELAY_TIME) {
            return (V)this.getMaxOpenTCBDelayTime();
        }
        if (attribute == TaskType.QR_DELAY_TIME) {
            return (V)this.getQRDelayTime();
        }
        if (attribute == TaskType.QR_DISPATCH_TIME) {
            return (V)this.getQRDispatchTime();
        }
        if (attribute == TaskType.QRCPU_TIME) {
            return (V)this.getQRCPUTime();
        }
        if (attribute == TaskType.OTHER_TCB_DISPATCH_TIME) {
            return (V)this.getOtherTCBDispatchTime();
        }
        if (attribute == TaskType.OTHER_TCBCPU_TIME) {
            return (V)this.getOtherTCBCPUTime();
        }
        if (attribute == TaskType.L8CPU_TIME) {
            return (V)this.getL8CPUTime();
        }
        if (attribute == TaskType.J8CPU_TIME) {
            return (V)this.getJ8CPUTime();
        }
        if (attribute == TaskType.S8CPU_TIME) {
            return (V)this.getS8CPUTime();
        }
        if (attribute == TaskType.TOTAL_IMS_COUNT) {
            return (V)this.getTotalIMSCount();
        }
        if (attribute == TaskType.TOTAL_DB2_REQUESTS) {
            return (V)this.getTotalDB2Requests();
        }
        if (attribute == TaskType.DISPATCHER_CHANGE_MODES) {
            return (V)this.getDispatcherChangeModes();
        }
        if (attribute == TaskType.DISPATCHER_TCB_ATTACH_COUNT) {
            return (V)this.getDispatcherTCBAttachCount();
        }
        if (attribute == TaskType.GLOBAL_ENQ_DELAY) {
            return (V)this.getGlobalENQDelay();
        }
        if (attribute == TaskType.RRMS_WAIT_TIME) {
            return (V)this.getRRMSWaitTime();
        }
        if (attribute == TaskType.TCPIPIO_WAIT_TIME) {
            return (V)this.getTCPIPIOWaitTime();
        }
        if (attribute == TaskType.RRMSURID) {
            return (V)this.getRRMSURID();
        }
        if (attribute == TaskType.DPL_COUNT) {
            return (V)this.getDPLCount();
        }
        if (attribute == TaskType.CLIENT_IP_ADDRESS) {
            return (V)this.getClientIPAddress();
        }
        if (attribute == TaskType.ENCRYPTED_SOCKET_BYTES) {
            return (V)this.getEncryptedSocketBytes();
        }
        if (attribute == TaskType.DECRYPTED_SOCKET_BYTES) {
            return (V)this.getDecryptedSocketBytes();
        }
        if (attribute == TaskType.TERMINAL_ID) {
            return (V)this.getTerminalID();
        }
        if (attribute == TaskType.TOTAL_JVM_ELAPSED_TIME) {
            return (V)this.getTotalJVMElapsedTime();
        }
        if (attribute == TaskType.TOTAL_JVM_SUSPEND_TIME) {
            return (V)this.getTotalJVMSuspendTime();
        }
        if (attribute == TaskType.BRIDGE_TOKEN) {
            return (V)this.getBridgeToken();
        }
        if (attribute == TaskType.PURGE_TYPE) {
            return (V)this.getPurgeType();
        }
        if (attribute == TaskType.TASK_STORAGE_UDSA) {
            return (V)this.getTaskStorageUDSA();
        }
        if (attribute == TaskType.TASK_STORAGE_EUDSA) {
            return (V)this.getTaskStorageEUDSA();
        }
        if (attribute == TaskType.TASK_STORAGE_CDSA) {
            return (V)this.getTaskStorageCDSA();
        }
        if (attribute == TaskType.TASK_STORAGE_ECDSA) {
            return (V)this.getTaskStorageECDSA();
        }
        if (attribute == TaskType.PROG_STORAGE_TOTAL) {
            return (V)this.getProgStorageTotal();
        }
        if (attribute == TaskType.PROG_STORAGE_ABOVE) {
            return (V)this.getProgStorageAbove();
        }
        if (attribute == TaskType.PROG_STORAGE_BELOW) {
            return (V)this.getProgStorageBelow();
        }
        if (attribute == TaskType.PROG_STORAGE_ECDSA) {
            return (V)this.getProgStorageECDSA();
        }
        if (attribute == TaskType.PROG_STORAGE_CSDA) {
            return (V)this.getProgStorageCSDA();
        }
        if (attribute == TaskType.PROG_STORAGE_ERDSA) {
            return (V)this.getProgStorageERDSA();
        }
        if (attribute == TaskType.PROG_STORAGE_RSDA) {
            return (V)this.getProgStorageRSDA();
        }
        if (attribute == TaskType.PROG_STORAGE_ESDSA) {
            return (V)this.getProgStorageESDSA();
        }
        if (attribute == TaskType.PROG_STORAGE_SDSA) {
            return (V)this.getProgStorageSDSA();
        }
        if (attribute == TaskType.NONPERSISTENT_SOCKETS) {
            return (V)this.getNonpersistentSockets();
        }
        if (attribute == TaskType.PERSISTENT_SOCKETS) {
            return (V)this.getPersistentSockets();
        }
        if (attribute == TaskType.TRANSACTION_APPL_NAME) {
            return (V)this.getTransactionApplName();
        }
        if (attribute == TaskType.PROGRAM_APPL_NAME) {
            return (V)this.getProgramApplName();
        }
        if (attribute == TaskType.CURRENT_PROGRAM) {
            return (V)this.getCurrentProgram();
        }
        if (attribute == TaskType.TRANS_SEQ_NUMBER) {
            return (V)this.getTransSeqNumber();
        }
        if (attribute == TaskType.TRANSACTION_GROUP_ID) {
            return (V)this.getTransactionGroupID();
        }
        if (attribute == TaskType.NETWORK_ID) {
            return (V)this.getNetworkID();
        }
        if (attribute == TaskType.REAL_LUNAME) {
            return (V)this.getRealLUNAME();
        }
        if (attribute == TaskType.TCPIP_SERVICE_PORT) {
            return (V)this.getTCPIPServicePort();
        }
        if (attribute == TaskType.OTS_TRANSACTION_ID) {
            return (V)this.getOTSTransactionID();
        }
        if (attribute == TaskType.OO_CLASS_LIBRARY_API_COUNT) {
            return (V)this.getOOClassLibraryAPICount();
        }
        if (attribute == TaskType.REPOSITORY_READ_COUNT) {
            return (V)this.getRepositoryReadCount();
        }
        if (attribute == TaskType.WEB_EXTRACT_COUNT) {
            return (V)this.getWebEXTRACTCount();
        }
        if (attribute == TaskType.SERVER_WEB_BROWSE_COUNT) {
            return (V)this.getServerWebBrowseCount();
        }
        if (attribute == TaskType.SERVER_WEB_READ_COUNT) {
            return (V)this.getServerWebREADCount();
        }
        if (attribute == TaskType.SERVER_WEB_WRITE_COUNT) {
            return (V)this.getServerWebWRITECount();
        }
        if (attribute == TaskType.EXTRACTTCPIP_AND_CERTIFICATE_COUNT) {
            return (V)this.getEXTRACTTCPIPAndCERTIFICATECount();
        }
        if (attribute == TaskType.CREATE_NON_PERSISTENT_SOCKET_COUNT) {
            return (V)this.getCREATENonPersistentSocketCount();
        }
        if (attribute == TaskType.CREATE_PERSISTENT_SOCKET_COUNT) {
            return (V)this.getCREATEPersistentSocketCount();
        }
        if (attribute == TaskType.NONPERSISTENT_SOCKET_HWM) {
            return (V)this.getNonpersistentSocketHWM();
        }
        if (attribute == TaskType.PERSISTENT_SOCKET_HWM) {
            return (V)this.getPersistentSocketHWM();
        }
        if (attribute == TaskType.SOCKET_RECEIVE_COUNT) {
            return (V)this.getSocketReceiveCount();
        }
        if (attribute == TaskType.RECVD_SOCKET_CHARS) {
            return (V)this.getRecvdSocketChars();
        }
        if (attribute == TaskType.SOCKET_SEND_COUNT) {
            return (V)this.getSocketSendCount();
        }
        if (attribute == TaskType.SENT_SOCKET_CHARS) {
            return (V)this.getSentSocketChars();
        }
        if (attribute == TaskType.SOCKET_TOTAL_REQUEST_COUNT) {
            return (V)this.getSocketTotalRequestCount();
        }
        if (attribute == TaskType.RECVD_INBOUND_SOCKET_COUNT) {
            return (V)this.getRecvdInboundSocketCount();
        }
        if (attribute == TaskType.RECVD_INBOUND_SOCKET_CHARS) {
            return (V)this.getRecvdInboundSocketChars();
        }
        if (attribute == TaskType.SEND_INBOUND_SOCKET_COUNT) {
            return (V)this.getSendInboundSocketCount();
        }
        if (attribute == TaskType.SEND_INBOUND_SOCKET_CHARS) {
            return (V)this.getSendInboundSocketChars();
        }
        if (attribute == TaskType.RO_DISPATCH_TIME) {
            return (V)this.getRODispatchTime();
        }
        if (attribute == TaskType.ROCPU_TIME) {
            return (V)this.getROCPUTime();
        }
        if (attribute == TaskType.KEY_8_DISPATCH_TIME) {
            return (V)this.getKey8DispatchTime();
        }
        if (attribute == TaskType.KEY_8CPU_TIME) {
            return (V)this.getKey8CPUTime();
        }
        if (attribute == TaskType.MAX_JVMTCB_DELAY_TIME) {
            return (V)this.getMaxJVMTCBDelayTime();
        }
        if (attribute == TaskType.MAX_HOT_POOLING_TCB_DELAY) {
            return (V)this.getMaxHotPoolingTCBDelay();
        }
        if (attribute == TaskType.OUTBOUND_SOCKET_IO_WAIT_TIME) {
            return (V)this.getOutboundSocketIOWaitTime();
        }
        if (attribute == TaskType.REQUEST_RECEIVER_WAIT_TIME) {
            return (V)this.getRequestReceiverWaitTime();
        }
        if (attribute == TaskType.REQUEST_PROCESSOR_WAIT_TIME) {
            return (V)this.getRequestProcessorWaitTime();
        }
        if (attribute == TaskType.OTS_IN_DOUBT_WAIT_TIME) {
            return (V)this.getOTSInDoubtWaitTime();
        }
        if (attribute == TaskType.JVM_INITIALIZE_ELAPSED_TIME) {
            return (V)this.getJVMInitializeElapsedTime();
        }
        if (attribute == TaskType.JVM_RESET_ELAPSED_TIME) {
            return (V)this.getJVMResetElapsedTime();
        }
        if (attribute == TaskType.PARTNER_WAIT_TIME) {
            return (V)this.getPartnerWaitTime();
        }
        if (attribute == TaskType.TRANSACTION_TYPE_DETAILS) {
            return (V)this.getTransactionTypeDetails();
        }
        if (attribute == TaskType.BTE_PHASE_COMPLETE) {
            return (V)this.getBTEPhaseComplete();
        }
        if (attribute == TaskType.WLM_EXEC_COMPLETE) {
            return (V)this.getWLMExecComplete();
        }
        if (attribute == TaskType.WLM_SUBSET_EXEC_COMPLETE) {
            return (V)this.getWLMSubsetExecComplete();
        }
        if (attribute == TaskType.TRANS_ORIGIN_TYPE) {
            return (V)this.getTransOriginType();
        }
        if (attribute == TaskType.UOW_RESOLVED_INDOUBT) {
            return (V)this.getUOWResolvedIndoubt();
        }
        if (attribute == TaskType.RECOVERY_MANAGER_UOW_SHUNTED) {
            return (V)this.getRecoveryManagerUOWShunted();
        }
        if (attribute == TaskType.UOW_UNSHUNTED) {
            return (V)this.getUOWUnshunted();
        }
        if (attribute == TaskType.INDOUBT_FAILURE) {
            return (V)this.getIndoubtFailure();
        }
        if (attribute == TaskType.UOW_RESOURCE_OWNER_FAILURE) {
            return (V)this.getUOWResourceOwnerFailure();
        }
        if (attribute == TaskType.RESPONSE_TIME) {
            return (V)this.getResponseTime();
        }
        if (attribute == TaskType.LU62UOW_SEQUENCE_NUMBER) {
            return (V)this.getLU62UOWSequenceNumber();
        }
        if (attribute == TaskType.TCPIP_SERVICE_NAME) {
            return (V)this.getTCPIPServiceName();
        }
        if (attribute == TaskType.CORBA_SERVER_NAME) {
            return (V)this.getCORBAServerName();
        }
        if (attribute == TaskType.DISPATCHER_TCBHWM) {
            return (V)this.getDispatcherTCBHWM();
        }
        if (attribute == TaskType.BEAN_STATE_ACTIVATION_COUNT) {
            return (V)this.getBeanStateActivationCount();
        }
        if (attribute == TaskType.BEAN_STATE_PASSIVATION_COUNT) {
            return (V)this.getBeanStatePassivationCount();
        }
        if (attribute == TaskType.BEAN_CREATION_COUNT) {
            return (V)this.getBeanCreationCount();
        }
        if (attribute == TaskType.BEAN_REMOVAL_COUNT) {
            return (V)this.getBeanRemovalCount();
        }
        if (attribute == TaskType.BEAN_METHOD_CALL_COUNT) {
            return (V)this.getBeanMethodCallCount();
        }
        if (attribute == TaskType.BEAN_TOTAL_COUNT) {
            return (V)this.getBeanTotalCount();
        }
        if (attribute == TaskType.KEY_9_DISPATCH_TIME) {
            return (V)this.getKey9DispatchTime();
        }
        if (attribute == TaskType.KEY_9CPU_TIME) {
            return (V)this.getKey9CPUTime();
        }
        if (attribute == TaskType.J9CPU_TIME) {
            return (V)this.getJ9CPUTime();
        }
        if (attribute == TaskType.DISPATCHER_TCB_MISMATCH_WAIT_TIME) {
            return (V)this.getDispatcherTCBMismatchWaitTime();
        }
        if (attribute == TaskType.DS_STORAGE_WAIT_TIME) {
            return (V)this.getDSStorageWaitTime();
        }
        if (attribute == TaskType.CORRELATION_UOW) {
            return (V)this.getCorrelationUOW();
        }
        if (attribute == TaskType.NETWORK_UOWID) {
            return (V)this.getNetworkUOWID();
        }
        if (attribute == TaskType.DPL_WITH_CHANNEL_DATA_LENGTH) {
            return (V)this.getDPLWithChannelDataLength();
        }
        if (attribute == TaskType.DPL_RETURN_WITH_CHANNEL_DATA_LENGTH) {
            return (V)this.getDPLReturnWithChannelDataLength();
        }
        if (attribute == TaskType.PROGRAM_LINK_WITH_CHANNEL_COUNT) {
            return (V)this.getProgramLinkWithChannelCount();
        }
        if (attribute == TaskType.XCTL_WITH_CHANNEL_COUNT) {
            return (V)this.getXCTLWithChannelCount();
        }
        if (attribute == TaskType.DPL_WITH_CHANNEL_COUNT) {
            return (V)this.getDPLWithChannelCount();
        }
        if (attribute == TaskType.PROGRAM_RETURN_WITH_CHANNEL_COUNT) {
            return (V)this.getProgramReturnWithChannelCount();
        }
        if (attribute == TaskType.PROGRAM_RETURN_WITH_CHANNEL_DATA_LENGTH) {
            return (V)this.getProgramReturnWithChannelDataLength();
        }
        if (attribute == TaskType.TOTAL_CHANNEL_CONTAINER_COUNT) {
            return (V)this.getTotalChannelContainerCount();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_BROWSE_COUNT) {
            return (V)this.getChannelContainerBrowseCount();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_GET_COUNT) {
            return (V)this.getChannelContainerGETCount();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_PUT_COUNT) {
            return (V)this.getChannelContainerPUTCount();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_MOVE_COUNT) {
            return (V)this.getChannelContainerMOVECount();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_GET_DATA_LENGTH) {
            return (V)this.getChannelContainerGETDataLength();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_PUT_DATA_LENGTH) {
            return (V)this.getChannelContainerPUTDataLength();
        }
        if (attribute == TaskType.INVOKE_WEB_SERVICE_COUNT) {
            return (V)this.getInvokeWebServiceCount();
        }
        if (attribute == TaskType.CLIENT_WEB_READ_COUNT) {
            return (V)this.getClientWebREADCount();
        }
        if (attribute == TaskType.CLIENT_WEB_WRITE_COUNT) {
            return (V)this.getClientWebWRITECount();
        }
        if (attribute == TaskType.WEB_RECEIVE_COUNT) {
            return (V)this.getWebRECEIVECount();
        }
        if (attribute == TaskType.WEB_RECEIVE_BYTES) {
            return (V)this.getWebRECEIVEBytes();
        }
        if (attribute == TaskType.WEB_SEND_COUNT) {
            return (V)this.getWebSENDCount();
        }
        if (attribute == TaskType.WEB_SEND_BYTES) {
            return (V)this.getWebSENDBytes();
        }
        if (attribute == TaskType.WEB_PARSEURL_COUNT) {
            return (V)this.getWebPARSEURLCount();
        }
        if (attribute == TaskType.CLIENT_WEB_BROWSE_COUNT) {
            return (V)this.getClientWebBrowseCount();
        }
        if (attribute == TaskType.MAX_CICSSSLTCB_DELAY_TIME) {
            return (V)this.getMaxCICSSSLTCBDelayTime();
        }
        if (attribute == TaskType.MAX_CICSXP_LINK_TCB_DELAY_TIME) {
            return (V)this.getMaxCICSXPLinkTCBDelayTime();
        }
        if (attribute == TaskType.TCB_CHANGE_MODE_DELAY_TIME) {
            return (V)this.getTCBChangeModeDelayTime();
        }
        if (attribute == TaskType.X8CPU_TIME) {
            return (V)this.getX8CPUTime();
        }
        if (attribute == TaskType.X9CPU_TIME) {
            return (V)this.getX9CPUTime();
        }
        if (attribute == TaskType.LOCAL_STARTCHANNEL_TOTAL_COUNT) {
            return (V)this.getLocalSTARTCHANNELTotalCount();
        }
        if (attribute == TaskType.LOCAL_STARTCHANNEL_DATA_LENGTH) {
            return (V)this.getLocalSTARTCHANNELDataLength();
        }
        if (attribute == TaskType.REMOTE_STARTCHANNEL_TOTAL_COUNT) {
            return (V)this.getRemoteSTARTCHANNELTotalCount();
        }
        if (attribute == TaskType.REMOTE_STARTCHANNEL_DATA_LENGTH) {
            return (V)this.getRemoteSTARTCHANNELDataLength();
        }
        if (attribute == TaskType.L9CPU_TIME) {
            return (V)this.getL9CPUTime();
        }
        if (attribute == TaskType.CURRENT_DISPATCHER_TC_BS) {
            return (V)this.getCurrentDispatcherTCBs();
        }
        if (attribute == TaskType.REPOSITORY_READ_DATA_LENGTH) {
            return (V)this.getRepositoryReadDataLength();
        }
        if (attribute == TaskType.REPOSITORY_WRITE_DATA_LENGTH) {
            return (V)this.getRepositoryWriteDataLength();
        }
        if (attribute == TaskType.CHANNEL_CONTAINER_CREATE_COUNT) {
            return (V)this.getChannelContainerCreateCount();
        }
        if (attribute == TaskType.DOCUMENT_DELETE_COUNT) {
            return (V)this.getDocumentDeleteCount();
        }
        if (attribute == TaskType.CURRENT_CONTAINER_STORAGE) {
            return (V)this.getCurrentContainerStorage();
        }
        if (attribute == TaskType.MAX_CONTAINER_STORAGE) {
            return (V)this.getMaxContainerStorage();
        }
        if (attribute == TaskType.ASSOCIATED_IP_FACILITIES_COUNT) {
            return (V)this.getAssociatedIPFacilitiesCount();
        }
        if (attribute == TaskType.ORIGIN_NET_ID) {
            return (V)this.getOriginNetID();
        }
        if (attribute == TaskType.ORIGIN_TASK_ID) {
            return (V)this.getOriginTaskID();
        }
        if (attribute == TaskType.ORIGIN_START_TIME) {
            return (V)this.getOriginStartTime();
        }
        if (attribute == TaskType.ORIGIN_APPLID) {
            return (V)this.getOriginAPPLID();
        }
        if (attribute == TaskType.ORIGIN_TRANS_ID) {
            return (V)this.getOriginTransID();
        }
        if (attribute == TaskType.ORIGIN_USER_ID) {
            return (V)this.getOriginUserID();
        }
        if (attribute == TaskType.ORIGIN_USER_CORRELATION) {
            return (V)this.getOriginUserCorrelation();
        }
        if (attribute == TaskType.ORIGIN_TCPIPSERVICE) {
            return (V)this.getOriginTCPIPSERVICE();
        }
        if (attribute == TaskType.ORIGIN_PORT) {
            return (V)this.getOriginPort();
        }
        if (attribute == TaskType.ORIGIN_CLIENT_IP) {
            return (V)this.getOriginClientIP();
        }
        if (attribute == TaskType.ORIGIN_CLIENT_PORT) {
            return (V)this.getOriginClientPort();
        }
        if (attribute == TaskType.ORIGIN_TRANS_FLAGS) {
            return (V)this.getOriginTransFlags();
        }
        if (attribute == TaskType.ORIGIN_FACILITY) {
            return (V)this.getOriginFacility();
        }
        if (attribute == TaskType.WMQ_REQUEST_TOTAL_COUNT) {
            return (V)this.getWMQRequestTotalCount();
        }
        if (attribute == TaskType.WMQGETWAIT_TIME) {
            return (V)this.getWMQGETWAITTime();
        }
        if (attribute == TaskType.CLIENT_PORT) {
            return (V)this.getClientPort();
        }
        if (attribute == TaskType.IPCONN_NAME) {
            return (V)this.getIPCONNName();
        }
        if (attribute == TaskType.IPCONN_ALLOCATE_COUNT) {
            return (V)this.getIPCONNAllocateCount();
        }
        if (attribute == TaskType.IPCONNIO_WAIT_TIME) {
            return (V)this.getIPCONNIOWaitTime();
        }
        if (attribute == TaskType.JVM_SERVER_THREAD_WAIT_TIME) {
            return (V)this.getJVMServerThreadWaitTime();
        }
        if (attribute == TaskType.EXECCICSXMLTRANSFORM_COUNT) {
            return (V)this.getEXECCICSXMLTRANSFORMCount();
        }
        if (attribute == TaskType.WSACONTEXTBUILD_COUNT) {
            return (V)this.getWSACONTEXTBUILDCount();
        }
        if (attribute == TaskType.WSACONTEXTGET_COUNT) {
            return (V)this.getWSACONTEXTGETCount();
        }
        if (attribute == TaskType.WSAEPR_CREATE_COUNT) {
            return (V)this.getWSAEPRCreateCount();
        }
        if (attribute == TaskType.WS_ADDRESSING_REQUEST_COUNT) {
            return (V)this.getWSAddressingRequestCount();
        }
        if (attribute == TaskType.T8CPU_TIME) {
            return (V)this.getT8CPUTime();
        }
        if (attribute == TaskType.MAX_THREAD_TCB_DELAY_TIME) {
            return (V)this.getMaxThreadTCBDelayTime();
        }
        if (attribute == TaskType.TOTAL_EXECCICS_COUNT) {
            return (V)this.getTotalEXECCICSCount();
        }
        if (attribute == TaskType.SIGNALEVENT_COUNT) {
            return (V)this.getSIGNALEVENTCount();
        }
        if (attribute == TaskType.EVENT_FILTER_COUNT) {
            return (V)this.getEVENTFilterCount();
        }
        if (attribute == TaskType.EVENT_CAPTURED_COUNT) {
            return (V)this.getEVENTCapturedCount();
        }
        if (attribute == TaskType.URI_MAP_NAME) {
            return (V)this.getURIMapName();
        }
        if (attribute == TaskType.PIPELINE_NAME) {
            return (V)this.getPipelineName();
        }
        if (attribute == TaskType.ATOM_SERVICE_NAME) {
            return (V)this.getAtomServiceName();
        }
        if (attribute == TaskType.WEBSERVICE_NAME) {
            return (V)this.getWebserviceName();
        }
        if (attribute == TaskType.PROGRAM_NAME) {
            return (V)this.getProgramName();
        }
        if (attribute == TaskType.EXECCICSASKTIME_COUNT) {
            return (V)this.getEXECCICSASKTIMECount();
        }
        if (attribute == TaskType.EXECCICS_XXX_TIME_COUNT) {
            return (V)this.getEXECCICSXxxTIMECount();
        }
        if (attribute == TaskType.BIFDIGEST_COUNT) {
            return (V)this.getBIFDIGESTCount();
        }
        if (attribute == TaskType.BIF_COUNT) {
            return (V)this.getBIFCount();
        }
        if (attribute == TaskType.TOTAL_DOCUMENT_LENGTH) {
            return (V)this.getTotalDocumentLength();
        }
        if (attribute == TaskType.XMLSSCPU_TIME) {
            return (V)this.getXMLSSCPUTime();
        }
        if (attribute == TaskType.WEB_SERVICES_OPERATION_NAME) {
            return (V)this.getWebServicesOperationName();
        }
        if (attribute == TaskType.WMQAPISRB_TIME) {
            return (V)this.getWMQAPISRBTime();
        }
        if (attribute == TaskType.SYNC_EMISSION_EVENT_CAPTURED_COUNT) {
            return (V)this.getSyncEmissionEVENTCapturedCount();
        }
        if (attribute == TaskType.TD_INTRA_LOCK_TIME) {
            return (V)this.getTDIntraLockTime();
        }
        if (attribute == TaskType.TD_EXTRA_LOCK_TIME) {
            return (V)this.getTDExtraLockTime();
        }
        if (attribute == TaskType.RO_DELAY_TIME) {
            return (V)this.getRODelayTime();
        }
        if (attribute == TaskType.SO_DELAY_TIME) {
            return (V)this.getSODelayTime();
        }
        if (attribute == TaskType.SESSION_ALLOCATION_WAIT_TIME) {
            return (V)this.getSessionAllocationWaitTime();
        }
        if (attribute == TaskType.I_S_ALLOCATE_WAIT_TIME) {
            return (V)this.getISAllocateWaitTime();
        }
        if (attribute == TaskType.CIPHER_SELECTED) {
            return (V)this.getCipherSelected();
        }
        if (attribute == TaskType.MAX_TASKS) {
            return (V)this.getMaxTasks();
        }
        if (attribute == TaskType.CURRENT_TASKS) {
            return (V)this.getCurrentTasks();
        }
        if (attribute == TaskType.CEC_MACHINE_TYPE) {
            return (V)this.getCECMachineType();
        }
        if (attribute == TaskType.CEC_MODEL) {
            return (V)this.getCECModel();
        }
        if (attribute == TaskType.GETMAIN_REQUESTS_GCDSA) {
            return (V)this.getGETMAINRequestsGCDSA();
        }
        if (attribute == TaskType.PEAK_STORAGE_GCDSA) {
            return (V)this.getPeakStorageGCDSA();
        }
        if (attribute == TaskType.GETMAIN_REQUESTS_GUDSA) {
            return (V)this.getGETMAINRequestsGUDSA();
        }
        if (attribute == TaskType.PEAK_STORAGE_GUDSA) {
            return (V)this.getPeakStorageGUDSA();
        }
        if (attribute == TaskType.GETMAIN_REQUESTS_ABOVE_2GB) {
            return (V)this.getGETMAINRequestsAbove2GB();
        }
        if (attribute == TaskType.GETMAIN_BYTES_ABOVE_2GB) {
            return (V)this.getGETMAINBytesAbove2GB();
        }
        if (attribute == TaskType.FREEMAIN_BYTES_ABOVE_2GB) {
            return (V)this.getFREEMAINBytesAbove2GB();
        }
        if (attribute == TaskType.FILE_EXCLUSIVE_CONTROL_WAIT_TIME) {
            return (V)this.getFileExclusiveControlWaitTime();
        }
        if (attribute == TaskType.FILE_VSAM_STRING_WAIT_TIME) {
            return (V)this.getFileVSAMStringWaitTime();
        }
        if (attribute == TaskType.APPLICATION_NAME) {
            return (V)this.getApplicationName();
        }
        if (attribute == TaskType.APPLICATION_PLATFORM_NAME) {
            return (V)this.getApplicationPlatformName();
        }
        if (attribute == TaskType.APPLICATION_OPERATION_NAME) {
            return (V)this.getApplicationOperationName();
        }
        if (attribute == TaskType.APPLICATION_MAJOR_VERSION) {
            return (V)this.getApplicationMajorVersion();
        }
        if (attribute == TaskType.APPLICATION_MINOR_VERSION) {
            return (V)this.getApplicationMinorVersion();
        }
        if (attribute == TaskType.APPLICATION_MICRO_VERSION) {
            return (V)this.getApplicationMicroVersion();
        }
        if (attribute == TaskType.CPU_TIME_ON_CP) {
            return (V)this.getCPUTimeOnCP();
        }
        if (attribute == TaskType.OFFLOAD_ELIGIBLE_CPU_TIME_ON_STANDARD_CP) {
            return (V)this.getOffloadEligibleCPUTimeOnStandardCP();
        }
        if (attribute == TaskType.THRESHOLD_COUNT) {
            return (V)this.getThresholdCount();
        }
        if (attribute == TaskType.GCDSA_PEAK_BYTES) {
            return (V)this.getGCDSAPeakBytes();
        }
        if (attribute == TaskType.GUDSA_PEAK_BYTES) {
            return (V)this.getGUDSAPeakBytes();
        }
        if (attribute == TaskType.WBSFCRCT) {
            return (V)this.getWbsfcrct();
        }
        if (attribute == TaskType.WBSFTOCT) {
            return (V)this.getWbsftoct();
        }
        if (attribute == TaskType.WBISSFCT) {
            return (V)this.getWbissfct();
        }
        if (attribute == TaskType.WBSREQBL) {
            return (V)this.getWbsreqbl();
        }
        if (attribute == TaskType.WBSRSPBL) {
            return (V)this.getWbsrspbl();
        }
        if (attribute == TaskType.TS_GET_SHARED_COUNT) {
            return (V)this.getTSGetSHAREDCount();
        }
        if (attribute == TaskType.TS_PUT_SHARED_COUNT) {
            return (V)this.getTSPutSHAREDCount();
        }
        if (attribute == TaskType.NAMED_COUNTER_GET_COUNT) {
            return (V)this.getNamedCounterGetCount();
        }
        if (attribute == TaskType.JSON_REQUEST_BODY_LENGTH) {
            return (V)this.getJSONRequestBodyLength();
        }
        if (attribute == TaskType.JSON_RESPONSE_BODY_LENGTH) {
            return (V)this.getJSONResponseBodyLength();
        }
        if (attribute == TaskType.PTHREAD_ALLOCATION_WAIT_TIME) {
            return (V)this.getPthreadAllocationWaitTime();
        }
        if (attribute == TaskType.TOTAL_ASYCHRONOUS_API_COMMANDS) {
            return (V)this.getTotalAsychronousAPICommands();
        }
        if (attribute == TaskType.EXECCICSRUNTRANSID_COUNT) {
            return (V)this.getEXECCICSRUNTRANSIDCount();
        }
        if (attribute == TaskType.EXECCICSFETCH_COUNT) {
            return (V)this.getEXECCICSFETCHCount();
        }
        if (attribute == TaskType.EXECCICSFREE_COUNT) {
            return (V)this.getEXECCICSFREECount();
        }
        if (attribute == TaskType.AS_FETCH_WAIT_TIME) {
            return (V)this.getASFetchWaitTime();
        }
        if (attribute == TaskType.AS_RUN_DELAYED_TIME) {
            return (V)this.getASRunDelayedTime();
        }
        if (attribute == TaskType.SYSTEM_RULE_EVALUATION_COUNT) {
            return (V)this.getSystemRuleEvaluationCount();
        }
        if (attribute == TaskType.SYSTEM_RULE_ACTION_COUNT) {
            return (V)this.getSystemRuleActionCount();
        }
        if (attribute == TaskType.LPAR_NAME) {
            return (V)this.getLPARName();
        }
        if (attribute == TaskType.NEW_SOCKET_CONNECTION_MESSAGE) {
            return (V)this.getNewSocketConnectionMessage();
        }
        if (attribute == TaskType.NODE_JS_APPLICATION_NAME) {
            return (V)this.getNodeJSApplicationName();
        }
        if (attribute == TaskType.MVSSOS_WAIT_TIME) {
            return (V)this.getMVSSOSWaitTime();
        }
        if (attribute == TaskType.SOTLSLVL) {
            return (V)this.getSotlslvl();
        }
        if (attribute == TaskType.SOFLAG) {
            return (V)this.getSoflag();
        }
        if (attribute == TaskType.SRRSTATUS) {
            return (V)this.getSrrstatus();
        }
        if (attribute == TaskType.SOCKET_COUNT) {
            return (V)this.getSocketCount();
        }
        if (attribute == TaskType.SOCKET_HWM) {
            return (V)this.getSocketHWM();
        }
        if (attribute == TaskType.NUMBER_OF_SOCKETS) {
            return (V)this.getNumberOfSockets();
        }
        return super.getAttributeValue(attribute);
    }

    public TaskType getObjectType() {
        return TaskType.getInstance();
    }

    @Override
    public TaskReference getCICSObjectReference() {
        return new TaskReference(this.getCICSContainer(), this.getTaskID());
    }
}

