/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TransactionClassReference;
import com.ibm.cics.core.model.TransactionClassType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ITransactionClass;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTransactionClass;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableTransactionClass
extends MutableCICSResource
implements IMutableTransactionClass {
    private ITransactionClass delegate;
    private MutableSMRecord record;

    public MutableTransactionClass(ICPSM cpsm, IContext context, ITransactionClass cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("TRANCLAS");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public Long getMaxActiveTrans() {
        String result = this.record.get("MAXACTIVE");
        if (result == null) {
            return this.delegate.getMaxActiveTrans();
        }
        return (Long)((CICSAttribute)TransactionClassType.MAX_ACTIVE_TRANS).get(result, this.record.getNormalizers());
    }

    public Long getActiveTrans() {
        return this.delegate.getActiveTrans();
    }

    public Long getQueued() {
        return this.delegate.getQueued();
    }

    public Long getPurgethresh() {
        String result = this.record.get("PURGETHRESH");
        if (result == null) {
            return this.delegate.getPurgethresh();
        }
        return (Long)((CICSAttribute)TransactionClassType.PURGETHRESH).get(result, this.record.getNormalizers());
    }

    public Long getAttaches() {
        return this.delegate.getAttaches();
    }

    public Long getPurgeimmed() {
        return this.delegate.getPurgeimmed();
    }

    public Long getTotquedcnt() {
        return this.delegate.getTotquedcnt();
    }

    public Long getAcceptimmed() {
        return this.delegate.getAcceptimmed();
    }

    public Long getAcceptaftrqd() {
        return this.delegate.getAcceptaftrqd();
    }

    public Long getPurgewhileqd() {
        return this.delegate.getPurgewhileqd();
    }

    public Long getInstalldefs() {
        return this.delegate.getInstalldefs();
    }

    public Long getPeakActiveTrans() {
        return this.delegate.getPeakActiveTrans();
    }

    public Long getQueuedpeak() {
        return this.delegate.getQueuedpeak();
    }

    public Long getMaxReachedCount() {
        return this.delegate.getMaxReachedCount();
    }

    public Long getPurgthrtimes() {
        return this.delegate.getPurgthrtimes();
    }

    public String getQueuetime() {
        return this.delegate.getQueuetime();
    }

    public String getCurquedtime() {
        return this.delegate.getCurquedtime();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public ITransactionClass.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public ITransactionClass.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public Date getLastatmax() {
        return this.delegate.getLastatmax();
    }

    public void setMaxActiveTrans(Long _maxActiveTrans) {
        if (_maxActiveTrans.equals(this.delegate.getMaxActiveTrans())) {
            this.record.set("MAXACTIVE", null);
        } else {
            TransactionClassType.MAX_ACTIVE_TRANS.validate((Object)_maxActiveTrans);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionClassType.MAX_ACTIVE_TRANS).set(_maxActiveTrans, this.record.getNormalizers());
            this.record.set("MAXACTIVE", connectionSpecificExternalValue);
        }
    }

    public void setPurgethresh(Long _purgethresh) {
        if (_purgethresh.equals(this.delegate.getPurgethresh())) {
            this.record.set("PURGETHRESH", null);
        } else {
            TransactionClassType.PURGETHRESH.validate((Object)_purgethresh);
            String connectionSpecificExternalValue = ((CICSAttribute)TransactionClassType.PURGETHRESH).set(_purgethresh, this.record.getNormalizers());
            this.record.set("PURGETHRESH", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionClassType.NAME) {
            return (V)this.getName();
        }
        if (attribute == TransactionClassType.MAX_ACTIVE_TRANS) {
            return (V)this.getMaxActiveTrans();
        }
        if (attribute == TransactionClassType.ACTIVE_TRANS) {
            return (V)this.getActiveTrans();
        }
        if (attribute == TransactionClassType.QUEUED) {
            return (V)this.getQueued();
        }
        if (attribute == TransactionClassType.PURGETHRESH) {
            return (V)this.getPurgethresh();
        }
        if (attribute == TransactionClassType.ATTACHES) {
            return (V)this.getAttaches();
        }
        if (attribute == TransactionClassType.PURGEIMMED) {
            return (V)this.getPurgeimmed();
        }
        if (attribute == TransactionClassType.TOTQUEDCNT) {
            return (V)this.getTotquedcnt();
        }
        if (attribute == TransactionClassType.ACCEPTIMMED) {
            return (V)this.getAcceptimmed();
        }
        if (attribute == TransactionClassType.ACCEPTAFTRQD) {
            return (V)this.getAcceptaftrqd();
        }
        if (attribute == TransactionClassType.PURGEWHILEQD) {
            return (V)this.getPurgewhileqd();
        }
        if (attribute == TransactionClassType.INSTALLDEFS) {
            return (V)this.getInstalldefs();
        }
        if (attribute == TransactionClassType.PEAK_ACTIVE_TRANS) {
            return (V)this.getPeakActiveTrans();
        }
        if (attribute == TransactionClassType.QUEUEDPEAK) {
            return (V)this.getQueuedpeak();
        }
        if (attribute == TransactionClassType.MAX_REACHED_COUNT) {
            return (V)this.getMaxReachedCount();
        }
        if (attribute == TransactionClassType.PURGTHRTIMES) {
            return (V)this.getPurgthrtimes();
        }
        if (attribute == TransactionClassType.QUEUETIME) {
            return (V)this.getQueuetime();
        }
        if (attribute == TransactionClassType.CURQUEDTIME) {
            return (V)this.getCurquedtime();
        }
        if (attribute == TransactionClassType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == TransactionClassType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == TransactionClassType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == TransactionClassType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == TransactionClassType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == TransactionClassType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == TransactionClassType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == TransactionClassType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == TransactionClassType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == TransactionClassType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == TransactionClassType.LASTATMAX) {
            return (V)this.getLastatmax();
        }
        return super.getAttributeValue(attribute);
    }

    public TransactionClassType getObjectType() {
        return TransactionClassType.getInstance();
    }

    @Override
    public TransactionClassReference getCICSObjectReference() {
        return new TransactionClassReference(this.getCICSContainer(), this.getName());
    }
}

