/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.CSDResourceDefinitionType;
import com.ibm.cics.core.model.CSDResourceHelper;
import com.ibm.cics.core.model.FromReferenceAttribute;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.ICICSDefinitionReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDResourceDefinition;
import com.ibm.cics.model.topology.CSDRepository;
import java.util.Arrays;
import java.util.List;

public class CSDGroupMembershipsReference<T extends ICICSDefinition>
extends FromReferenceAttribute<T, ICSDResourceDefinition, ICICSDefinitionReference<T>> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CSDGroupMembershipsReference() {
        super(CSDResourceDefinitionType.getInstance().getResourceTableName(), CSDResourceDefinitionType.getInstance());
    }

    public List<ICICSAttribute<?>> getAttributesUsedInReference() {
        return Arrays.asList(CSDResourceDefinitionType.CSDGROUP, CSDResourceDefinitionType.DEFNAME, CSDResourceDefinitionType.DEFTYPE);
    }

    public ICICSObjectSet<ICSDResourceDefinition> getFrom(ICICSDefinitionReference<T> to) {
        ICICSDefinitionContainer container = to.getCICSContainer();
        if (container instanceof CSDRepository) {
            CSDRepository cicsContainer = (CSDRepository)container;
            ICICSObjectSet set = cicsContainer.getRegion().getCSDCSDDefinitionContainer().getCICSObjectSet(this.getFromType());
            set.setFilter(FilterExpression.is(CSDResourceDefinitionType.DEFNAME, (Object)to.getName()).and(FilterExpression.is(CSDResourceDefinitionType.DEFTYPE, (Object)CSDResourceHelper.getDefType(to.getCICSType())).and(FilterExpression.is(CSDResourceDefinitionType.CSDGROUP, (Object)to.getCSDGroup()))));
            return set;
        }
        return ICICSObjectSet.emptySet((ICICSType)CSDResourceDefinitionType.getInstance());
    }
}

