/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.AtomServiceDefinitionType;
import com.ibm.cics.core.model.BundleDefinitionType;
import com.ibm.cics.core.model.CICSTypesRegistry;
import com.ibm.cics.core.model.ConnectionDefinitionType;
import com.ibm.cics.core.model.CorbaServerDefinitionType;
import com.ibm.cics.core.model.DB2ConnectionDefinitionType;
import com.ibm.cics.core.model.DB2EntryDefinitionType;
import com.ibm.cics.core.model.DB2TransactionDefinitionType;
import com.ibm.cics.core.model.DeployedJARFileDefinitionType;
import com.ibm.cics.core.model.DocumentTemplateDefinitionType;
import com.ibm.cics.core.model.EnqueueModelDefinitionType;
import com.ibm.cics.core.model.FileDefinitionType;
import com.ibm.cics.core.model.IPICConnectionDefinitionType;
import com.ibm.cics.core.model.JVMServerDefinitionType;
import com.ibm.cics.core.model.JournalModelDefinitionType;
import com.ibm.cics.core.model.LSRPoolDefinitionType;
import com.ibm.cics.core.model.LibraryDefinitionType;
import com.ibm.cics.core.model.MapSetDefinitionType;
import com.ibm.cics.core.model.PartitionSetDefinitionType;
import com.ibm.cics.core.model.PartnerDefinitionType;
import com.ibm.cics.core.model.PipelineDefinitionType;
import com.ibm.cics.core.model.ProcessTypeDefinitionType;
import com.ibm.cics.core.model.ProfileDefinitionType;
import com.ibm.cics.core.model.ProgramDefinitionType;
import com.ibm.cics.core.model.RequestModelDefinitionType;
import com.ibm.cics.core.model.SessionDefinitionType;
import com.ibm.cics.core.model.TCPIPServiceDefinitionType;
import com.ibm.cics.core.model.TDQueueDefinitionType;
import com.ibm.cics.core.model.TSModelDefinitionType;
import com.ibm.cics.core.model.TerminalDefinitionType;
import com.ibm.cics.core.model.TransactionClassDefinitionType;
import com.ibm.cics.core.model.TransactionDefinitionType;
import com.ibm.cics.core.model.TypetermDefinitionType;
import com.ibm.cics.core.model.URIMapDefinitionType;
import com.ibm.cics.core.model.WMQConnectionDefinitionType;
import com.ibm.cics.core.model.WebServiceDefinitionType;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDResourceDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CSDResourceHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<ICSDResourceDefinition.DeftypeValue, Class<? extends ICICSType<? extends ICICSDefinition>>> typeMap = new HashMap<ICSDResourceDefinition.DeftypeValue, Class<? extends ICICSType<? extends ICICSDefinition>>>();

    static {
        typeMap.put(ICSDResourceDefinition.DeftypeValue.ATOMSERVICE, AtomServiceDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.BUNDLE, BundleDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.CONNECTION, ConnectionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.CORBASERVER, CorbaServerDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.DB2CONN, DB2ConnectionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.DB2ENTRY, DB2EntryDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.DB2TRAN, DB2TransactionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.DJAR, DeployedJARFileDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.DOCTEMPLATE, DocumentTemplateDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.ENQMODEL, EnqueueModelDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.FILE, FileDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.IPCONN, IPICConnectionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.JOURNALMODEL, JournalModelDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.JVMSERVER, JVMServerDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.LIBRARY, LibraryDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.LSRPOOL, LSRPoolDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.MAP, MapSetDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.MQCONN, WMQConnectionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.PARTITIONSET, PartitionSetDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.PARTNER, PartnerDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.PIPELINE, PipelineDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.PROCESSTYPE, ProcessTypeDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.PROFILE, ProfileDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.PROGRAM, ProgramDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.REQUESTMODEL, RequestModelDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.SESSIONS, SessionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TCPIPSERVICE, TCPIPServiceDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TDQUEUE, TDQueueDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TERMINAL, TerminalDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TRANCLASS, TransactionClassDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TRANSACTION, TransactionDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TSMODEL, TSModelDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.TYPETERM, TypetermDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.URIMAP, URIMapDefinitionType.class);
        typeMap.put(ICSDResourceDefinition.DeftypeValue.WEBSERVICE, WebServiceDefinitionType.class);
    }

    public static <T extends ICICSDefinition> ICICSType<T> getCICSType(ICSDResourceDefinition.DeftypeValue deftype) {
        Class<? extends ICICSType<? extends ICICSDefinition>> definitionClass = typeMap.get(deftype);
        if (definitionClass != null) {
            ICICSType cicsTypeInstance = CICSTypesRegistry.getCICSTypeInstance(definitionClass);
            return cicsTypeInstance;
        }
        return null;
    }

    public static <T extends ICICSDefinition> ICSDResourceDefinition.DeftypeValue getDefType(ICICSType<T> cicsType) {
        List definitionSet;
        Class<?> cicsTypeClass = cicsType.getClass();
        if (cicsTypeClass != null && !(definitionSet = typeMap.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), cicsTypeClass)).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
            return (ICSDResourceDefinition.DeftypeValue)definitionSet.get(0);
        }
        throw new IllegalArgumentException("Unsupported CICS attribute of type " + cicsTypeClass);
    }
}

