/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FeatureReference;
import com.ibm.cics.core.model.FeatureType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IFeature;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class Feature
extends CICSResource
implements IFeature {
    private String _name;
    private String _value;
    private String _filepath;

    public Feature(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(FeatureType.NAME);
        this._value = (String)avm.getAttributeValue(FeatureType.VALUE, true);
        this._filepath = (String)avm.getAttributeValue(FeatureType.FILE_PATH, true);
    }

    public Feature(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)FeatureType.NAME).get(stringValue, normalizers);
        stringValue = record.get("VALUE");
        this._value = (String)((CICSAttribute)FeatureType.VALUE).get(stringValue, normalizers);
        stringValue = record.get("FILEPATH");
        this._filepath = (String)((CICSAttribute)FeatureType.FILE_PATH).get(stringValue, normalizers);
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getFilePath() {
        return this._filepath;
    }

    public FeatureType getObjectType() {
        return FeatureType.getInstance();
    }

    @Override
    public FeatureReference getCICSObjectReference() {
        return new FeatureReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FeatureType.NAME) {
            return (V)this.getName();
        }
        if (attribute == FeatureType.VALUE) {
            return (V)this.getValue();
        }
        if (attribute == FeatureType.FILE_PATH) {
            return (V)this.getFilePath();
        }
        return super.getAttributeValue(attribute);
    }
}

