/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DB2TransactionReference;
import com.ibm.cics.core.model.DB2TransactionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IDB2Transaction;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableDB2Transaction;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableDB2Transaction
extends MutableCICSResource
implements IMutableDB2Transaction {
    private IDB2Transaction delegate;
    private MutableSMRecord record;

    public MutableDB2Transaction(ICPSM cpsm, IContext context, IDB2Transaction cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("DB2TRN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getDB2Entry() {
        String result = this.record.get("DB2ENTRY");
        if (result == null) {
            return this.delegate.getDB2Entry();
        }
        return (String)((CICSAttribute)DB2TransactionType.DB2_ENTRY).get(result, this.record.getNormalizers());
    }

    public String getTransaction() {
        String result = this.record.get("TRANSID");
        if (result == null) {
            return this.delegate.getTransaction();
        }
        return (String)((CICSAttribute)DB2TransactionType.TRANSACTION).get(result, this.record.getNormalizers());
    }

    public String getPlan() {
        return this.delegate.getPlan();
    }

    public String getPlanExit() {
        return this.delegate.getPlanExit();
    }

    public IDB2Transaction.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IDB2Transaction.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public void setDB2Entry(String _DB2Entry) {
        if (_DB2Entry.equals(this.delegate.getDB2Entry())) {
            this.record.set("DB2ENTRY", null);
        } else {
            DB2TransactionType.DB2_ENTRY.validate((Object)_DB2Entry);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionType.DB2_ENTRY).set(_DB2Entry, this.record.getNormalizers());
            this.record.set("DB2ENTRY", connectionSpecificExternalValue);
        }
    }

    public void setTransaction(String _transaction) {
        if (_transaction.equals(this.delegate.getTransaction())) {
            this.record.set("TRANSID", null);
        } else {
            DB2TransactionType.TRANSACTION.validate((Object)_transaction);
            String connectionSpecificExternalValue = ((CICSAttribute)DB2TransactionType.TRANSACTION).set(_transaction, this.record.getNormalizers());
            this.record.set("TRANSID", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DB2TransactionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == DB2TransactionType.DB2_ENTRY) {
            return (V)this.getDB2Entry();
        }
        if (attribute == DB2TransactionType.TRANSACTION) {
            return (V)this.getTransaction();
        }
        if (attribute == DB2TransactionType.PLAN) {
            return (V)this.getPlan();
        }
        if (attribute == DB2TransactionType.PLAN_EXIT) {
            return (V)this.getPlanExit();
        }
        if (attribute == DB2TransactionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == DB2TransactionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == DB2TransactionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == DB2TransactionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == DB2TransactionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == DB2TransactionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == DB2TransactionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == DB2TransactionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == DB2TransactionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == DB2TransactionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        return super.getAttributeValue(attribute);
    }

    public DB2TransactionType getObjectType() {
        return DB2TransactionType.getInstance();
    }

    @Override
    public DB2TransactionReference getCICSObjectReference() {
        return new DB2TransactionReference(this.getCICSContainer(), this.getName());
    }
}

