/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMServerDefinitionReference;
import com.ibm.cics.core.model.JVMServerDefinitionType;
import com.ibm.cics.core.model.internal.MutableCICSDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.IJVMServerDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableJVMServerDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableJVMServerDefinition
extends MutableCICSDefinition
implements IMutableJVMServerDefinition {
    private IJVMServerDefinition delegate;
    private MutableSMRecord record;

    public MutableJVMServerDefinition(ICPSM cpsm, IContext context, IJVMServerDefinition cicsObject) {
        super(cpsm, context, (ICICSDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("JVMSVDEF");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IJVMServerDefinition.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getUserdata1() {
        String result = this.record.get("USERDATA1");
        if (result == null) {
            return this.delegate.getUserdata1();
        }
        return (String)((CICSAttribute)JVMServerDefinitionType.USERDATA_1).get(result, this.record.getNormalizers());
    }

    public String getUserdata2() {
        String result = this.record.get("USERDATA2");
        if (result == null) {
            return this.delegate.getUserdata2();
        }
        return (String)((CICSAttribute)JVMServerDefinitionType.USERDATA_2).get(result, this.record.getNormalizers());
    }

    public String getUserdata3() {
        String result = this.record.get("USERDATA3");
        if (result == null) {
            return this.delegate.getUserdata3();
        }
        return (String)((CICSAttribute)JVMServerDefinitionType.USERDATA_3).get(result, this.record.getNormalizers());
    }

    public String getJvmProfile() {
        String result = this.record.get("JVMPROFILE");
        if (result == null) {
            return this.delegate.getJvmProfile();
        }
        return (String)((CICSAttribute)JVMServerDefinitionType.JVM_PROFILE).get(result, this.record.getNormalizers());
    }

    public ICICSEnums.EnablementValue getEnabledStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getEnabledStatus();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)JVMServerDefinitionType.ENABLED_STATUS).get(result, this.record.getNormalizers());
    }

    public String getLeRuntimeOptionsProgram() {
        String result = this.record.get("LERUNOPTS");
        if (result == null) {
            return this.delegate.getLeRuntimeOptionsProgram();
        }
        return (String)((CICSAttribute)JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM).get(result, this.record.getNormalizers());
    }

    public Long getThreadlimit() {
        String result = this.record.get("THREADLIMIT");
        if (result == null) {
            return this.delegate.getThreadlimit();
        }
        return (Long)((CICSAttribute)JVMServerDefinitionType.THREADLIMIT).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)JVMServerDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public void setUserdata1(String _userdata1) {
        if (_userdata1.equals(this.delegate.getUserdata1())) {
            this.record.set("USERDATA1", null);
        } else {
            JVMServerDefinitionType.USERDATA_1.validate((Object)_userdata1);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.USERDATA_1).set(_userdata1, this.record.getNormalizers());
            this.record.set("USERDATA1", connectionSpecificExternalValue);
        }
    }

    public void setUserdata2(String _userdata2) {
        if (_userdata2.equals(this.delegate.getUserdata2())) {
            this.record.set("USERDATA2", null);
        } else {
            JVMServerDefinitionType.USERDATA_2.validate((Object)_userdata2);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.USERDATA_2).set(_userdata2, this.record.getNormalizers());
            this.record.set("USERDATA2", connectionSpecificExternalValue);
        }
    }

    public void setUserdata3(String _userdata3) {
        if (_userdata3.equals(this.delegate.getUserdata3())) {
            this.record.set("USERDATA3", null);
        } else {
            JVMServerDefinitionType.USERDATA_3.validate((Object)_userdata3);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.USERDATA_3).set(_userdata3, this.record.getNormalizers());
            this.record.set("USERDATA3", connectionSpecificExternalValue);
        }
    }

    public void setJvmProfile(String _jvmProfile) {
        if (_jvmProfile.equals(this.delegate.getJvmProfile())) {
            this.record.set("JVMPROFILE", null);
        } else {
            JVMServerDefinitionType.JVM_PROFILE.validate((Object)_jvmProfile);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.JVM_PROFILE).set(_jvmProfile, this.record.getNormalizers());
            this.record.set("JVMPROFILE", connectionSpecificExternalValue);
        }
    }

    public void setEnabledStatus(ICICSEnums.EnablementValue _enabledStatus) {
        if (_enabledStatus.equals((Object)this.delegate.getEnabledStatus())) {
            this.record.set("STATUS", null);
        } else {
            JVMServerDefinitionType.ENABLED_STATUS.validate((Object)_enabledStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.ENABLED_STATUS).set(_enabledStatus, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setLeRuntimeOptionsProgram(String _leRuntimeOptionsProgram) {
        if (_leRuntimeOptionsProgram.equals(this.delegate.getLeRuntimeOptionsProgram())) {
            this.record.set("LERUNOPTS", null);
        } else {
            JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM.validate((Object)_leRuntimeOptionsProgram);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM).set(_leRuntimeOptionsProgram, this.record.getNormalizers());
            this.record.set("LERUNOPTS", connectionSpecificExternalValue);
        }
    }

    public void setThreadlimit(Long _threadlimit) {
        if (_threadlimit.equals(this.delegate.getThreadlimit())) {
            this.record.set("THREADLIMIT", null);
        } else {
            JVMServerDefinitionType.THREADLIMIT.validate((Object)_threadlimit);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.THREADLIMIT).set(_threadlimit, this.record.getNormalizers());
            this.record.set("THREADLIMIT", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESCRIPTION", null);
        } else {
            JVMServerDefinitionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)JVMServerDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESCRIPTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMServerDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == JVMServerDefinitionType.USERDATA_1) {
            return (V)this.getUserdata1();
        }
        if (attribute == JVMServerDefinitionType.USERDATA_2) {
            return (V)this.getUserdata2();
        }
        if (attribute == JVMServerDefinitionType.USERDATA_3) {
            return (V)this.getUserdata3();
        }
        if (attribute == JVMServerDefinitionType.JVM_PROFILE) {
            return (V)this.getJvmProfile();
        }
        if (attribute == JVMServerDefinitionType.ENABLED_STATUS) {
            return (V)this.getEnabledStatus();
        }
        if (attribute == JVMServerDefinitionType.LE_RUNTIME_OPTIONS_PROGRAM) {
            return (V)this.getLeRuntimeOptionsProgram();
        }
        if (attribute == JVMServerDefinitionType.THREADLIMIT) {
            return (V)this.getThreadlimit();
        }
        return super.getAttributeValue(attribute);
    }

    public JVMServerDefinitionType getObjectType() {
        return JVMServerDefinitionType.getInstance();
    }

    @Override
    public JVMServerDefinitionReference getCICSObjectReference() {
        return new JVMServerDefinitionReference(this.getCICSContainer(), this.getName(), this.getVersion(), this.getCSDGroup());
    }
}

