/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.CICSRelease;

public class CICSReleaseHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2020 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CICSReleaseHelper.class);

    public static CICSRelease getCICSReleaseForLevel(String cicsTSLevel) {
        CICSRelease cicsRelease = CICSRelease.fromVersion(cicsTSLevel);
        if (cicsRelease == null && CICSReleaseHelper.isConnectAnyCICSRelease()) {
            cicsRelease = CICSRelease.getLatestRelease();
            debug.event("getCICSRelease", "Version check overridden for internal use only, using latest release: " + cicsRelease.getCICSTSLevel());
        }
        return cicsRelease;
    }

    private static boolean isConnectAnyCICSRelease() {
        return System.getProperty("internalUseOnlyUnsupportedConnectToAnyCicsTsVersion", "").equals("true");
    }
}

