/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import com.ibm.cics.common.util.Debug;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class DebugEncrypter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PUBLIC_KEY_MODULUS_RSA = "17715368299570509714375893166461428750415624072294472134572971577591276777318860832916370629618916269925089819293499470563530196278461973850618391116139877645342308253523038276412484052824526505528396338865147905838042444771499087570658430001574394378714359782773538508529127618782799209238537489922151817785738732563210695021515419604835138559572861588439679110796776327888876029076457213774038741454247438078290503254451611516575212992675139755005669414980888224116763880676203049850820198912155619187668936649890160048116853265808923171977945900190141450921044122684198220915672531287535557319065083549134035658641";
    private static final String PUBLIC_KEY_EXPONENT_RSA = "65537";
    private PublicKey publicKeyRSA;
    private static Debug DEBUG = new Debug(DebugEncrypter.class);

    public DebugEncrypter() {
        this.initialiseKeyRSA();
    }

    private static void generateKeyPairRSA() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyModulus = publicKey.getModulus().toString();
        String publicKeyExponent = publicKey.getPublicExponent().toString();
        String privateKeyModulus = privateKey.getModulus().toString();
        String privateKeyExponent = privateKey.getPrivateExponent().toString();
        System.out.println("publicKeyModulus=[" + publicKeyModulus + "]");
        System.out.println("publicKeyExponent=[" + publicKeyExponent + "]");
        System.out.println("privateKeyModulus=[" + privateKeyModulus + "]");
        System.out.println("privateKeyExponent=[" + privateKeyExponent + "]");
    }

    private void initialiseKeyRSA() {
        BigInteger publicKeyModulus = new BigInteger(PUBLIC_KEY_MODULUS_RSA);
        BigInteger publicKeyExponent = new BigInteger(PUBLIC_KEY_EXPONENT_RSA);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(publicKeyModulus, publicKeyExponent);
        try {
            KeyFactory factory = KeyFactory.getInstance("RSA");
            this.publicKeyRSA = factory.generatePublic(publicKeySpec);
        }
        catch (GeneralSecurityException e) {
            DEBUG.error("initialiseKeyRSA", "Failed to initialise RSA key. Any attempts at encryption will now also fail.", e);
        }
    }

    private SecretKey generateKeyAES() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }

    private String encryptBytes(byte[] inputBytes, String algorithm, Key key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, key);
        byte[] encryptedBytes = cipher.doFinal(inputBytes);
        String encryptedString = new String(Base64.encodeBase64((byte[])encryptedBytes));
        return encryptedString;
    }

    private String encryptBytesRSA(byte[] inputBytes) throws GeneralSecurityException {
        return this.encryptBytes(inputBytes, "RSA", this.publicKeyRSA);
    }

    private String encryptBytesAES(byte[] inputBytes, SecretKey key) throws GeneralSecurityException {
        return this.encryptBytes(inputBytes, "AES", key);
    }

    public String encryptLogMessage(String messageString) {
        try {
            System.out.println(messageString);
            SecretKey keyAES = this.generateKeyAES();
            String encryptedKeyString = this.encryptBytesRSA(keyAES.getEncoded());
            byte[] messageBytes = messageString.getBytes(Charset.forName("UTF-8"));
            String encryptedMessageString = this.encryptBytesAES(messageBytes, keyAES);
            String logString = "[Encrypted][KeyStart]" + encryptedKeyString + "[KeyEnd][MessageStart]" + encryptedMessageString + "[MessageEnd]";
            return logString;
        }
        catch (GeneralSecurityException e) {
            DEBUG.error("encryptLogMessage", "Failed to encrypt message.", e);
            return "[Failed to encrypt]";
        }
    }
}

