/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SMResponse
extends SMConnectionResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String stub;
    private final String resourceType;
    private final IContext context;
    private final String status;
    private final String response;
    private final String reason;
    private final int recordTotal;
    private final List<? extends SMConnectionRecord> records;

    public SMResponse(String stub, String resourceType, IContext context, String status, String response, int recordTotal, List<? extends SMConnectionRecord> records) {
        this(stub, resourceType, context, status, response, "OK", recordTotal, records);
    }

    public SMResponse(String stub, String resourceType, IContext context, String status, String response, String reason, int recordTotal, List<? extends SMConnectionRecord> records) {
        this.stub = stub;
        this.resourceType = resourceType;
        this.context = context;
        this.status = status;
        this.response = response;
        this.reason = reason;
        this.recordTotal = recordTotal;
        this.records = Collections.unmodifiableList(records);
    }

    public static SMResponse noRecords(String stub, String resourceType, IContext context) {
        return new SMResponse(stub, resourceType, context, "OK", "OK", 0, Collections.emptyList());
    }

    public static SMResponse summary(String stub, String resourceType, int recordTotal, boolean recordsLimited, IContext context) {
        return new SMResponse(stub, resourceType, context, "OK", "WARNING", "MAXRECORDS", recordTotal, Collections.emptyList());
    }

    public static SMResponse summary(String stub, String resourceType, int recordTotal, IContext context) {
        return new SMResponse(stub, resourceType, context, "OK", "OK", recordTotal, Collections.emptyList());
    }

    public static SMResponse records(String stub, String resouceType, List<? extends SMConnectionRecord> records, IContext context) {
        return new SMResponse(stub, resouceType, context, "OK", "OK", records.size(), new ArrayList<SMConnectionRecord>(records));
    }

    public SMResponse subResponse(int start, int count) {
        return SMResponse.records(this.getStub(), this.getResourceType(), this.getRecords(start, count), this.getContext());
    }

    private List<? extends SMConnectionRecord> getRecords(int start, int count) {
        if (count == -1) {
            count = this.records.size();
        }
        return this.records.subList(start, start + count);
    }

    public List<? extends SMConnectionRecord> getRecords() {
        return this.records;
    }

    public SMConnectionRecord getRecord(int index) {
        return this.records.get(index);
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public int getRecordStart() {
        return 0;
    }

    public int getRecordTotal() {
        return this.recordTotal;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getStub() {
        return this.stub;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResponse() {
        return this.response;
    }

    public String getReason() {
        return this.reason;
    }

    public IContext getContext() {
        return this.context;
    }

    public String toString() {
        return "SMResponse[" + this.resourceType + ", " + this.getRecordCount() + ", " + this.stub + "]";
    }
}

