/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.sm.internal.GraphQLArgumentValue;
import com.ibm.cics.sm.comm.sm.internal.GraphQLQueryElement;
import com.ibm.cics.sm.comm.sm.internal.GraphQLSimpleArgumentValue;

class GraphQLArgument
implements GraphQLQueryElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String name;
    private final GraphQLArgumentValue value;

    public GraphQLArgument(String name, GraphQLArgumentValue value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("Arguments must have a name");
        }
        if (value == null) {
            throw new IllegalStateException("Arguments must have a value");
        }
        this.name = name.trim();
        this.value = value;
    }

    public GraphQLArgument(String name, String value) {
        this(name, new GraphQLSimpleArgumentValue(value));
    }

    public static Builder newArgument() {
        return new Builder();
    }

    @Override
    public void render(StringBuilder sb) {
        sb.append(this.name).append(":");
        this.value.render(sb);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphQLArgument other = (GraphQLArgument)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static class Builder {
        private String name;
        private GraphQLArgumentValue value;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(GraphQLArgumentValue value) {
            this.value = value;
            return this;
        }

        public GraphQLArgument build() {
            return new GraphQLArgument(this.name, this.value);
        }
    }
}

