/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.offline;

import com.ibm.cics.model.ICPSMManagerContainer;
import com.ibm.cics.model.topology.CICSplex;
import com.ibm.cics.model.topology.CPSM;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineBASRepository;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegion;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegionGroup;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCPSMDefinitionRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OfflineCICSplex
implements CICSplex {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final Map<String, OfflineCICSRegion> regions = new HashMap<String, OfflineCICSRegion>();
    private final Map<String, OfflineCICSRegionGroup> regionGroups = new HashMap<String, OfflineCICSRegionGroup>();
    private final OfflineCPSMDefinitionRepository cpsmDefinitionRepository;
    private final OfflineBASRepository basRepository;
    private final String context;
    private CPSM cpsm;

    public OfflineCICSplex(String context, CPSM cpsm) {
        this.context = context;
        this.cpsm = cpsm;
        this.basRepository = new OfflineBASRepository(this, cpsm);
        this.cpsmDefinitionRepository = new OfflineCPSMDefinitionRepository(this, cpsm);
    }

    public OfflineCICSplex(String context, String scope, CPSM cpsm) {
        this.context = context;
        this.cpsm = cpsm;
        this.basRepository = new OfflineBASRepository(this, cpsm);
        this.cpsmDefinitionRepository = new OfflineCPSMDefinitionRepository(this, cpsm);
    }

    public CPSM getCPSM() {
        return this.cpsm;
    }

    public String getName() {
        return this.context;
    }

    public OfflineCPSMDefinitionRepository getCPSMDefinitionRepository() {
        return this.cpsmDefinitionRepository;
    }

    public OfflineBASRepository getBASRepository() {
        return this.basRepository;
    }

    public OfflineCICSRegionGroup getOrCreateOfflineRegionGroup(String name) {
        if (this.regionGroups.containsKey(name)) {
            return this.regionGroups.get(name);
        }
        OfflineCICSRegionGroup regionGroup = new OfflineCICSRegionGroup(name, this);
        this.regionGroups.put(name, regionGroup);
        return regionGroup;
    }

    public OfflineCICSRegion getOrCreateOfflineRegion(String name) {
        if (this.regions.containsKey(name)) {
            return this.regions.get(name);
        }
        OfflineCICSRegion region = new OfflineCICSRegion(name, this);
        this.regions.put(name, region);
        return region;
    }

    public Map<String, OfflineCICSRegion> getRegions() {
        return Collections.unmodifiableMap(this.regions);
    }

    public Optional<OfflineCICSRegion> getRegion(String name) {
        return Optional.ofNullable(this.regions.get(name));
    }

    public Map<String, OfflineCICSRegionGroup> getRegionGroups() {
        return Collections.unmodifiableMap(this.regionGroups);
    }

    public Optional<OfflineCICSRegionGroup> getRegionGroup(String name) {
        return Optional.ofNullable(this.regionGroups.get(name));
    }

    public ICPSMManagerContainer getCPSMManagerRepository() {
        return null;
    }
}

