/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

public enum CICSRelease {
    e410(null),
    e510("010100"),
    e520("010200"),
    e530("010300"),
    e610("020100"),
    e620("020200"),
    e630("020300"),
    e640("030100"),
    e650("030200"),
    e660("040100"),
    e670("040200"),
    e680("050100"),
    e690("050200"),
    e700("050300"),
    e710("050400"),
    e720("050500"),
    e730("050600"),
    e740("060100");

    private final String cicsTSLevel;

    private CICSRelease(String cicsTSLevel) {
        this.cicsTSLevel = cicsTSLevel;
    }

    public String getCICSTSLevel() {
        return this.cicsTSLevel;
    }

    public boolean laterThan(String cicsTSLevel) {
        if (this.cicsTSLevel != null) {
            return this.cicsTSLevel.compareTo(cicsTSLevel) > 0;
        }
        return false;
    }

    public boolean laterThanOrEqualTo(String cicsTSLevel) {
        if (this.cicsTSLevel != null) {
            return this.cicsTSLevel.compareTo(cicsTSLevel) >= 0;
        }
        return false;
    }

    protected static CICSRelease fromVersion(String cicsTSLevel) {
        CICSRelease[] cICSReleaseArray = CICSRelease.values();
        int n = cICSReleaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            CICSRelease r = cICSReleaseArray[n2];
            if (r.getCICSTSLevel() != null && r.getCICSTSLevel().equals(cicsTSLevel)) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static CICSRelease getLatestRelease() {
        return CICSRelease.values()[CICSRelease.values().length - 1];
    }
}

