/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CredentialsLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();

    String getConnectionImageString(CredentialsConfiguration credentialsConfiguration) {
        boolean authenticatedInthisSession = credentialsManager.isAuthenticatedInthisSession(credentialsConfiguration.getID());
        if (credentialsConfiguration.isCertificateCredential()) {
            if (credentialsConfiguration.getCertificate().getSource().equals("SOURCE_CARD")) {
                return "CREDENTIAL_CARD";
            }
            return "CREDENTIAL_CERT";
        }
        if (credentialsConfiguration.isOneTimePassword()) {
            return "CREDENTIAL_MFA";
        }
        if (authenticatedInthisSession) {
            return "ACTIVE_CREDENTIAL";
        }
        return "CREDENTIAL";
    }

    public Image getImage(Object element) {
        CredentialsConfiguration credentialsConfiguration = (CredentialsConfiguration)element;
        return ConnectionsImages.getImage(this.getConnectionImageString(credentialsConfiguration));
    }

    public String getText(Object element) {
        CredentialsConfiguration credentialsConfiguration = (CredentialsConfiguration)element;
        StringBuffer buffer = new StringBuffer();
        buffer.append(credentialsConfiguration.getName());
        return buffer.toString();
    }

    public void refreshLabels() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = CredentialsLabelProvider.this.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ILabelProviderListener labelProviderListener = (ILabelProviderListener)listener;
                    labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)CredentialsLabelProvider.this));
                    ++n2;
                }
            }
        });
    }

    public void update(ViewerCell cell) {
        cell.setText(this.getText(cell.getElement()));
        cell.setImage(this.getImage(cell.getElement()));
    }
}

